/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.gmm;

import java.util.List;
import org.ddogleg.clustering.AssignCluster;
import org.ddogleg.clustering.ComputeClusters;
import org.ddogleg.clustering.gmm.AssignGmm_F64;
import org.ddogleg.clustering.gmm.GaussianGmm_F64;
import org.ddogleg.clustering.gmm.GaussianLikelihoodManager;
import org.ddogleg.clustering.gmm.InitializeGmm_F64;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;
import org.ejml.dense.row.CommonOps_DDRM;

public class ExpectationMaximizationGmm_F64
implements ComputeClusters<double[]> {
    InitializeGmm_F64 selectInitial;
    FastQueue<GaussianGmm_F64> mixture;
    FastQueue<PointInfo> info = new FastQueue<PointInfo>(PointInfo.class, true);
    int maxIterations;
    double convergeTol;
    GaussianLikelihoodManager likelihoodManager;
    double[] dx = new double[1];
    double errorChiSquare;
    boolean verbose;

    public ExpectationMaximizationGmm_F64(int maxIterations, double convergeTol, InitializeGmm_F64 selectInitial) {
        this.maxIterations = maxIterations;
        this.convergeTol = convergeTol;
        this.selectInitial = selectInitial;
        System.err.println("WARNING:  GMM-EM is a work in progress!  Might not work in your situation");
    }

    @Override
    public void init(final int pointDimension, long randomSeed) {
        this.mixture = new FastQueue<GaussianGmm_F64>(GaussianGmm_F64.class, true){

            @Override
            protected GaussianGmm_F64 createInstance() {
                return new GaussianGmm_F64(pointDimension);
            }
        };
        this.selectInitial.init(pointDimension, randomSeed);
        if (this.dx.length < pointDimension) {
            this.dx = new double[pointDimension];
        }
        this.likelihoodManager = new GaussianLikelihoodManager(pointDimension, this.mixture.toList());
    }

    @Override
    public void process(List<double[]> points, int numCluster) {
        this.mixture.resize(numCluster);
        for (int i = 0; i < points.size(); ++i) {
            PointInfo p = this.info.grow();
            p.point = points.get(i);
            p.weights.resize(numCluster);
        }
        if (this.verbose) {
            System.out.println("GMM-EM: Selecting initial seeds");
        }
        this.selectInitial.selectSeeds(points, this.mixture.toList());
        this.likelihoodManager.precomputeAll();
        if (this.verbose) {
            System.out.println("GMM-EM: Entering main loop");
        }
        double errorBefore = Double.MAX_VALUE;
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            double fractionChange;
            this.errorChiSquare = this.expectation();
            if (this.verbose) {
                System.out.println("GMM-EM: " + iteration + " errorChiSquare " + this.errorChiSquare);
            }
            if ((fractionChange = 1.0 - this.errorChiSquare / errorBefore) >= 0.0 && fractionChange <= this.convergeTol) {
                if (!this.verbose) break;
                System.out.println("GMM-EM: CONVERGED");
                break;
            }
            errorBefore = this.errorChiSquare;
            this.maximization();
            this.likelihoodManager.precomputeAll();
        }
        for (int i = 0; i < this.info.size; ++i) {
            ((PointInfo[])this.info.data)[i].point = null;
        }
        this.info.reset();
    }

    protected double expectation() {
        double sumChiSq = 0.0;
        for (int i = 0; i < this.info.size(); ++i) {
            int j;
            PointInfo p = this.info.get(i);
            double bestLikelihood = 0.0;
            double bestChiSq = Double.MAX_VALUE;
            double total = 0.0;
            for (j = 0; j < this.mixture.size; ++j) {
                double likelihood;
                GaussianLikelihoodManager.Likelihood g = this.likelihoodManager.getLikelihood(j);
                p.weights.data[j] = likelihood = g.likelihood(p.point);
                total += p.weights.data[j];
                if (!(likelihood > bestLikelihood)) continue;
                bestLikelihood = likelihood;
                bestChiSq = g.getChisq();
            }
            if (total > 0.0) {
                j = 0;
                while (j < this.mixture.size) {
                    int n = j++;
                    p.weights.data[n] = p.weights.data[n] / total;
                }
            }
            sumChiSq += bestChiSq;
        }
        return sumChiSq;
    }

    protected void maximization() {
        int i;
        int i2;
        for (i2 = 0; i2 < this.mixture.size; ++i2) {
            this.mixture.get(i2).zero();
        }
        for (i2 = 0; i2 < this.info.size; ++i2) {
            PointInfo p = this.info.get(i2);
            for (int j = 0; j < this.mixture.size; ++j) {
                this.mixture.get(j).addMean(p.point, p.weights.get(j));
            }
        }
        for (i2 = 0; i2 < this.mixture.size; ++i2) {
            GaussianGmm_F64 g = this.mixture.get(i2);
            if (!(g.weight > 0.0)) continue;
            CommonOps_DDRM.divide(g.mean, g.weight);
        }
        for (i2 = 0; i2 < this.info.size; ++i2) {
            PointInfo pp = this.info.get(i2);
            double[] p = pp.point;
            for (int j = 0; j < this.mixture.size; ++j) {
                GaussianGmm_F64 g = this.mixture.get(j);
                for (int k = 0; k < p.length; ++k) {
                    this.dx[k] = p[k] - g.mean.data[k];
                }
                this.mixture.get(j).addCovariance(this.dx, pp.weights.get(j));
            }
        }
        double totalMixtureWeight = 0.0;
        for (i = 0; i < this.mixture.size; ++i) {
            GaussianGmm_F64 g = this.mixture.get(i);
            if (!(g.weight > 0.0)) continue;
            CommonOps_DDRM.divide(g.covariance, g.weight);
            totalMixtureWeight += g.weight;
        }
        for (i = 0; i < this.mixture.size; ++i) {
            this.mixture.get((int)i).weight /= totalMixtureWeight;
        }
    }

    @Override
    public AssignCluster<double[]> getAssignment() {
        return new AssignGmm_F64(this.mixture.toList());
    }

    @Override
    public double getDistanceMeasure() {
        return this.errorChiSquare;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.selectInitial.setVerbose(verbose);
        this.verbose = verbose;
    }

    public static class PointInfo {
        public double[] point;
        public GrowQueue_F64 weights = new GrowQueue_F64();
    }
}

