/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.se;

import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class InterpolateLinearSe3_F64 {
    Se3_F64 initial = new Se3_F64();
    Rodrigues_F64 rotation = new Rodrigues_F64();
    double rotMagnitude;
    Vector3D_F64 translation = new Vector3D_F64();
    DMatrixRMaj R = new DMatrixRMaj(3, 3);

    public void setTransforms(Se3_F64 initial, Se3_F64 end) {
        this.initial.set(initial);
        this.translation.x = end.T.x - initial.T.x;
        this.translation.y = end.T.y - initial.T.y;
        this.translation.z = end.T.z - initial.T.z;
        CommonOps_DDRM.multTransA(initial.getR(), end.getR(), this.R);
        ConvertRotation3D_F64.matrixToRodrigues(this.R, this.rotation);
        this.rotMagnitude = this.rotation.theta;
    }

    public void interpolate(double where, Se3_F64 output) {
        this.rotation.setTheta(where * this.rotMagnitude);
        ConvertRotation3D_F64.rodriguesToMatrix(this.rotation, this.R);
        output.T.x = this.initial.T.x + where * this.translation.x;
        output.T.y = this.initial.T.y + where * this.translation.y;
        output.T.z = this.initial.T.z + where * this.translation.z;
        CommonOps_DDRM.mult(this.initial.R, this.R, output.R);
    }
}

