/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.plane;

import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.linsol.qr.SolveNullSpaceQRP_DDRM;
import org.ejml.interfaces.SolveNullSpace;

public class FitPlane3D_F64 {
    SolveNullSpace<DMatrixRMaj> solverNull = new SolveNullSpaceQRP_DDRM();
    DMatrixRMaj A = new DMatrixRMaj(3, 3);
    DMatrixRMaj nullspace = new DMatrixRMaj(3, 1);

    public boolean svd(List<Point3D_F64> points, Point3D_F64 outputCenter, Vector3D_F64 outputNormal) {
        int N = points.size();
        outputCenter.set(0.0, 0.0, 0.0);
        for (int i = 0; i < N; ++i) {
            Point3D_F64 p = points.get(i);
            outputCenter.x += p.x;
            outputCenter.y += p.y;
            outputCenter.z += p.z;
        }
        outputCenter.x /= (double)N;
        outputCenter.y /= (double)N;
        outputCenter.z /= (double)N;
        return this.solvePoint(points, outputCenter, outputNormal);
    }

    public boolean solvePoint(List<Point3D_F64> points, Point3D_F64 pointOnPlane, Vector3D_F64 outputNormal) {
        int N = points.size();
        this.A.reshape(N, 3);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            Point3D_F64 p = points.get(i);
            this.A.data[index++] = p.x - pointOnPlane.x;
            this.A.data[index++] = p.y - pointOnPlane.y;
            this.A.data[index++] = p.z - pointOnPlane.z;
        }
        if (!this.solverNull.process(this.A, 1, this.nullspace)) {
            return false;
        }
        outputNormal.x = this.nullspace.unsafe_get(0, 0);
        outputNormal.y = this.nullspace.unsafe_get(1, 0);
        outputNormal.z = this.nullspace.unsafe_get(2, 0);
        return true;
    }
}

