/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.interest;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.abst.feature.detect.intensity.WrapperFastCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperGradientCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperKitRosCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperMedianCornerIntensity;
import boofcv.abst.feature.detect.interest.ConfigFastCorner;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.detect.interest.ConfigHarrisCorner;
import boofcv.abst.feature.detect.interest.ConfigShiTomasi;
import boofcv.abst.feature.detect.interest.PointDetector;
import boofcv.abst.feature.detect.interest.WrapFastToPointDetector;
import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.feature.detect.intensity.FastCornerDetector;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPoint;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import javax.annotation.Nullable;

public class FactoryDetectPoint {
    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createHarris(@Nullable ConfigGeneralDetector configDetector, @Nullable ConfigHarrisCorner configCorner, Class<D> derivType) {
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        if (configCorner == null) {
            configCorner = new ConfigHarrisCorner();
            configCorner.radius = configDetector.radius;
        }
        GradientCornerIntensity<D> cornerIntensity = FactoryIntensityPointAlg.harris(configCorner.radius, (float)configCorner.kappa, configCorner.weighted, derivType);
        return FactoryDetectPoint.createGeneral(cornerIntensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createShiTomasi(@Nullable ConfigGeneralDetector configDetector, @Nullable ConfigShiTomasi configCorner, Class<D> derivType) {
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        if (configCorner == null) {
            configCorner = new ConfigShiTomasi();
            configCorner.radius = configDetector.radius;
        }
        GradientCornerIntensity<D> cornerIntensity = FactoryIntensityPointAlg.shiTomasi(configCorner.radius, configCorner.weighted, derivType);
        return FactoryDetectPoint.createGeneral(cornerIntensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createKitRos(@Nullable ConfigGeneralDetector configDetector, Class<D> derivType) {
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        WrapperKitRosCornerIntensity intensity = new WrapperKitRosCornerIntensity(derivType);
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createFast(@Nullable ConfigFastCorner configFast, ConfigGeneralDetector configDetector, Class<T> imageType) {
        if (configFast == null) {
            configFast = new ConfigFastCorner();
        }
        configFast.checkValidity();
        FastCornerDetector<T> alg = FactoryIntensityPointAlg.fast(configFast.pixelTol, configFast.minContinuous, imageType);
        alg.setMaxFeaturesFraction(configFast.maxFeatures);
        WrapperFastCornerIntensity intensity = new WrapperFastCornerIntensity(alg);
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageGray<T>> PointDetector<T> createFast(@Nullable ConfigFastCorner configFast, Class<T> imageType) {
        if (configFast == null) {
            configFast = new ConfigFastCorner();
        }
        configFast.checkValidity();
        FastCornerDetector<T> alg = FactoryIntensityPointAlg.fast(configFast.pixelTol, configFast.minContinuous, imageType);
        alg.setMaxFeaturesFraction(configFast.maxFeatures);
        return new WrapFastToPointDetector<T>(alg);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createMedian(@Nullable ConfigGeneralDetector configDetector, Class<T> imageType) {
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        BlurStorageFilter<T> medianFilter = FactoryBlurFilter.median(ImageType.single(imageType), configDetector.radius);
        WrapperMedianCornerIntensity intensity = new WrapperMedianCornerIntensity(medianFilter);
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createHessianDeriv(HessianBlobIntensity.Type type, @Nullable ConfigGeneralDetector configDetector, Class<D> derivType) {
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        GeneralFeatureIntensity intensity = FactoryIntensityPoint.hessian(type, derivType);
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createHessianDirect(HessianBlobIntensity.Type type, @Nullable ConfigGeneralDetector configDetector) {
        GeneralFeatureIntensity intensity;
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        switch (type) {
            case DETERMINANT: {
                intensity = FactoryIntensityPoint.hessianDet();
                break;
            }
            case TRACE: {
                intensity = FactoryIntensityPoint.laplacian();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type");
            }
        }
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createGeneral(GradientCornerIntensity<D> cornerIntensity, ConfigGeneralDetector config) {
        WrapperGradientCornerIntensity intensity = new WrapperGradientCornerIntensity(cornerIntensity);
        return FactoryDetectPoint.createGeneral(intensity, config);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createGeneral(GeneralFeatureIntensity<T, D> intensity, ConfigGeneralDetector config) {
        ConfigGeneralDetector foo = new ConfigGeneralDetector();
        foo.setTo(config);
        config = foo;
        config.ignoreBorder += config.radius;
        if (!intensity.localMaximums()) {
            config.detectMaximums = false;
        }
        if (!intensity.localMinimums()) {
            config.detectMinimums = false;
        }
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(config);
        GeneralFeatureDetector<T, D> det = new GeneralFeatureDetector<T, D>(intensity, extractor);
        det.setMaxFeatures(config.maxFeatures);
        return det;
    }
}

