/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ImagePyramid;
import boofcv.struct.pyramid.PyramidDiscrete;
import georegression.geometry.UtilPoint2D_F32;
import georegression.struct.shapes.Rectangle2D_F64;
import java.lang.reflect.Array;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.FastQueue;

public class TldRegionTracker<I extends ImageGray<I>, D extends ImageGray<D>> {
    private double maxErrorFB;
    private ImagePyramid<I> currentImage;
    private D[] currentDerivX;
    private D[] currentDerivY;
    private ImagePyramid<I> previousImage;
    private D[] previousDerivX;
    private D[] previousDerivY;
    private Class<D> derivType;
    private ImageGradient<I, D> gradient;
    private int numPyramidLayers;
    private PyramidKltTracker<I, D> tracker;
    private Track[] tracks;
    private FastQueue<AssociatedPair> pairs = new FastQueue<AssociatedPair>(AssociatedPair.class, true);
    private double[] errorsFB;
    private int gridWidth;
    private int featureRadius;
    private Rectangle2D_F64 spawnRect = new Rectangle2D_F64();

    public TldRegionTracker(int gridWidth, int featureRadius, double maxErrorFB, ImageGradient<I, D> gradient, PyramidKltTracker<I, D> tracker, Class<I> imageType, Class<D> derivType) {
        this.gridWidth = gridWidth;
        this.featureRadius = featureRadius;
        this.maxErrorFB = maxErrorFB;
        this.tracker = tracker;
        this.gradient = gradient;
        this.derivType = derivType;
        this.tracks = new Track[gridWidth * gridWidth];
        this.errorsFB = new double[gridWidth * gridWidth];
    }

    public void initialize(PyramidDiscrete<I> image) {
        if (this.previousDerivX == null || this.previousDerivX.length != image.getNumLayers() || this.previousImage.getInputWidth() != image.getInputWidth() || this.previousImage.getInputHeight() != image.getInputHeight()) {
            this.declareDataStructures(image);
        }
        for (int i = 0; i < image.getNumLayers(); ++i) {
            this.gradient.process(image.getLayer(i), this.previousDerivX[i], this.previousDerivY[i]);
        }
        this.previousImage.setTo(image);
    }

    protected void declareDataStructures(PyramidDiscrete<I> image) {
        this.numPyramidLayers = image.getNumLayers();
        this.previousDerivX = (ImageGray[])Array.newInstance(this.derivType, image.getNumLayers());
        this.previousDerivY = (ImageGray[])Array.newInstance(this.derivType, image.getNumLayers());
        this.currentDerivX = (ImageGray[])Array.newInstance(this.derivType, image.getNumLayers());
        this.currentDerivY = (ImageGray[])Array.newInstance(this.derivType, image.getNumLayers());
        for (int i = 0; i < image.getNumLayers(); ++i) {
            int w = image.getWidth(i);
            int h = image.getHeight(i);
            this.previousDerivX[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
            this.previousDerivY[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
            this.currentDerivX[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
            this.currentDerivY[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
        }
        Class imageClass = image.getImageType().getImageClass();
        this.previousImage = FactoryPyramid.discreteGaussian(image.getScales(), -1.0, 1, false, ImageType.single(imageClass));
        this.previousImage.initialize(image.getInputWidth(), image.getInputHeight());
        for (int i = 0; i < this.tracks.length; ++i) {
            Track t = new Track();
            t.klt = new PyramidKltFeature(this.numPyramidLayers, this.featureRadius);
            this.tracks[i] = t;
        }
    }

    public boolean process(ImagePyramid<I> image, Rectangle2D_F64 targetRectangle) {
        boolean success = true;
        this.updateCurrent(image);
        this.spawnGrid(targetRectangle);
        if (!this.trackFeature()) {
            success = false;
        }
        this.setCurrentToPrevious();
        return success;
    }

    protected void updateCurrent(ImagePyramid<I> image) {
        this.currentImage = image;
        for (int i = 0; i < image.getNumLayers(); ++i) {
            this.gradient.process(image.getLayer(i), this.currentDerivX[i], this.currentDerivY[i]);
        }
    }

    private void setCurrentToPrevious() {
        this.previousImage.setTo(this.currentImage);
        D[] tmp = this.previousDerivX;
        this.previousDerivX = this.currentDerivX;
        this.currentDerivX = tmp;
        tmp = this.previousDerivY;
        this.previousDerivY = this.currentDerivY;
        this.currentDerivY = tmp;
    }

    protected boolean trackFeature() {
        this.pairs.reset();
        int numTracksFB = 0;
        int numTracksRemaining = 0;
        for (int i = 0; i < this.tracks.length; ++i) {
            Track t = this.tracks[i];
            if (!t.active) continue;
            float prevX = t.klt.x;
            float prevY = t.klt.y;
            this.tracker.setImage(this.currentImage, (ImageGray[])this.currentDerivX, (ImageGray[])this.currentDerivY);
            KltTrackFault result = this.tracker.track(t.klt);
            if (result != KltTrackFault.SUCCESS) {
                t.active = false;
                continue;
            }
            float currX = t.klt.x;
            float currY = t.klt.y;
            this.tracker.setDescription(t.klt);
            this.tracker.setImage(this.previousImage, (ImageGray[])this.previousDerivX, (ImageGray[])this.previousDerivY);
            result = this.tracker.track(t.klt);
            if (result != KltTrackFault.SUCCESS) {
                t.active = false;
                continue;
            }
            double errorForwardBackwards = UtilPoint2D_F32.distanceSq(prevX, prevY, t.klt.x, t.klt.y);
            this.errorsFB[numTracksFB++] = errorForwardBackwards;
            if (errorForwardBackwards > this.maxErrorFB) {
                t.active = false;
                continue;
            }
            AssociatedPair p = this.pairs.grow();
            p.p1.set(prevX, prevY);
            p.p2.set(currX, currY);
            ++numTracksRemaining;
        }
        double medianFB = QuickSelect.select(this.errorsFB, numTracksFB / 2, numTracksFB);
        return !(medianFB > this.maxErrorFB) && numTracksRemaining >= 4;
    }

    protected void spawnGrid(Rectangle2D_F64 prevRect) {
        this.spawnRect.p0.x = prevRect.p0.x + (double)this.featureRadius;
        this.spawnRect.p0.y = prevRect.p0.y + (double)this.featureRadius;
        this.spawnRect.p1.x = prevRect.p1.x - (double)this.featureRadius;
        this.spawnRect.p1.y = prevRect.p1.y - (double)this.featureRadius;
        double spawnWidth = this.spawnRect.getWidth();
        double spawnHeight = this.spawnRect.getHeight();
        this.tracker.setImage(this.previousImage, (ImageGray[])this.previousDerivX, (ImageGray[])this.previousDerivY);
        for (int i = 0; i < this.gridWidth; ++i) {
            float y = (float)(this.spawnRect.p0.y + (double)i * spawnHeight / (double)(this.gridWidth - 1));
            for (int j = 0; j < this.gridWidth; ++j) {
                float x = (float)(this.spawnRect.p0.x + (double)j * spawnWidth / (double)(this.gridWidth - 1));
                Track t = this.tracks[i * this.gridWidth + j];
                t.klt.x = x;
                t.klt.y = y;
                t.active = this.tracker.setDescription(t.klt);
            }
        }
    }

    public FastQueue<AssociatedPair> getPairs() {
        return this.pairs;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public static class Track {
        PyramidKltFeature klt;
        boolean active;
    }
}

