/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.detdesc.DetectDescribeMulti;
import boofcv.abst.feature.detdesc.PointDescSet;
import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.EulerType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class VisOdomQuadPnP<T extends ImageGray<T>, TD extends TupleDesc> {
    private Triangulate2ViewsMetric triangulate;
    private ModelMatcher<Se3_F64, Stereo2D3D> matcher;
    private ModelFitter<Se3_F64, Stereo2D3D> modelRefiner;
    private FastQueue<Stereo2D3D> modelFitData = new FastQueue<Stereo2D3D>(10, Stereo2D3D.class, true);
    private DetectDescribeMulti<T, TD> detector;
    private AssociateDescription2D<TD> assocSame;
    private AssociateDescription2D<TD> assocL2R;
    private FastQueue<QuadView> quadViews = new FastQueue<QuadView>(10, QuadView.class, true);
    private ImageInfo<TD> featsLeft0;
    private ImageInfo<TD> featsLeft1;
    private ImageInfo<TD> featsRight0;
    private ImageInfo<TD> featsRight1;
    private SetMatches[] setMatches;
    private Se3_F64 leftToRight = new Se3_F64();
    private Point2Transform2_F64 leftImageToNorm;
    private Point2Transform2_F64 rightImageToNorm;
    private Se3_F64 newToOld = new Se3_F64();
    private Se3_F64 leftCamToWorld = new Se3_F64();
    private boolean first = true;
    private boolean[] usedLeft = new boolean[1];
    private boolean[] usedRight = new boolean[1];
    private int[] oldToNewLeft = new int[1];
    private int[] oldToNewRight = new int[1];

    public VisOdomQuadPnP(DetectDescribeMulti<T, TD> detector, AssociateDescription2D<TD> assocSame, AssociateDescription2D<TD> assocL2R, Triangulate2ViewsMetric triangulate, ModelMatcher<Se3_F64, Stereo2D3D> matcher, ModelFitter<Se3_F64, Stereo2D3D> modelRefiner) {
        this.detector = detector;
        this.assocSame = assocSame;
        this.assocL2R = assocL2R;
        this.triangulate = triangulate;
        this.matcher = matcher;
        this.modelRefiner = modelRefiner;
        this.setMatches = new SetMatches[detector.getNumberOfSets()];
        for (int i = 0; i < this.setMatches.length; ++i) {
            this.setMatches[i] = new SetMatches();
        }
        this.featsLeft0 = new ImageInfo<TD>(detector);
        this.featsLeft1 = new ImageInfo<TD>(detector);
        this.featsRight0 = new ImageInfo<TD>(detector);
        this.featsRight1 = new ImageInfo<TD>(detector);
    }

    public void setCalibration(StereoParameters param) {
        param.rightToLeft.invert(this.leftToRight);
        this.leftImageToNorm = LensDistortionFactory.narrow(param.left).undistort_F64(true, false);
        this.rightImageToNorm = LensDistortionFactory.narrow(param.right).undistort_F64(true, false);
    }

    public void reset() {
        this.featsLeft0.reset();
        this.featsLeft1.reset();
        this.featsRight0.reset();
        this.featsRight1.reset();
        for (SetMatches m : this.setMatches) {
            m.reset();
        }
        this.newToOld.reset();
        this.leftCamToWorld.reset();
        this.first = true;
    }

    public boolean process(T left, T right) {
        if (this.first) {
            this.associateL2R(left, right);
            this.first = false;
        } else {
            this.associateL2R(left, right);
            this.associateF2F();
            this.cyclicConsistency();
            if (!this.estimateMotion()) {
                return false;
            }
        }
        return true;
    }

    private void associateL2R(T left, T right) {
        ImageInfo<TD> tmp = this.featsLeft1;
        this.featsLeft1 = this.featsLeft0;
        this.featsLeft0 = tmp;
        tmp = this.featsRight1;
        this.featsRight1 = this.featsRight0;
        this.featsRight0 = tmp;
        this.featsLeft1.reset();
        this.featsRight1.reset();
        this.describeImage(left, this.featsLeft1);
        this.describeImage(right, this.featsRight1);
        for (int i = 0; i < this.detector.getNumberOfSets(); ++i) {
            SetMatches matches = this.setMatches[i];
            matches.swap();
            matches.match2to3.reset();
            FastQueue<Point2D_F64> leftLoc = this.featsLeft1.location[i];
            FastQueue<Point2D_F64> rightLoc = this.featsRight1.location[i];
            this.assocL2R.setSource(leftLoc, this.featsLeft1.description[i]);
            this.assocL2R.setDestination(rightLoc, this.featsRight1.description[i]);
            this.assocL2R.associate();
            FastQueue<AssociatedIndex> found = this.assocL2R.getMatches();
            this.setMatches(matches.match2to3, found, leftLoc.size);
        }
    }

    private void removeUnassociated(FastQueue<Point2D_F64> leftLoc, FastQueue<TD> leftDesc, FastQueue<Point2D_F64> rightLoc, FastQueue<TD> rightDesc, FastQueue<AssociatedIndex> matches) {
        AssociatedIndex a;
        int i;
        int N = Math.max(leftLoc.size, rightLoc.size);
        if (this.usedLeft.length < N) {
            this.usedLeft = new boolean[N];
            this.usedRight = new boolean[N];
            this.oldToNewLeft = new int[N];
            this.oldToNewRight = new int[N];
        } else {
            for (i = 0; i < N; ++i) {
                this.usedLeft[i] = false;
                this.usedRight[i] = false;
            }
        }
        for (i = 0; i < matches.size; ++i) {
            a = matches.get(i);
            this.usedLeft[a.src] = true;
            this.usedRight[a.dst] = true;
        }
        this.removeUnused(leftLoc, leftDesc, this.usedLeft, this.oldToNewLeft);
        this.removeUnused(rightLoc, rightDesc, this.usedRight, this.oldToNewRight);
        for (i = 0; i < matches.size; ++i) {
            a = matches.get(i);
            a.src = this.oldToNewLeft[a.src];
            a.dst = this.oldToNewRight[a.dst];
        }
    }

    private void removeUnused(FastQueue<Point2D_F64> loc, FastQueue<TD> desc, boolean[] used, int[] oldToNew) {
        int count = 0;
        for (int i = 0; i < loc.size; ++i) {
            if (used[i]) {
                oldToNew[i] = count;
                if (count != i) {
                    Point2D_F64 a = ((Point2D_F64[])loc.data)[count];
                    ((Point2D_F64[])loc.data)[count] = ((Point2D_F64[])loc.data)[i];
                    ((Point2D_F64[])loc.data)[i] = a;
                    TupleDesc d = ((TupleDesc[])desc.data)[count];
                    ((TupleDesc[])desc.data)[count] = ((TupleDesc[])desc.data)[i];
                    ((TupleDesc[])desc.data)[i] = d;
                }
                ++count;
                continue;
            }
            oldToNew[i] = -1;
        }
        loc.size = desc.size = count;
    }

    private void associateF2F() {
        this.quadViews.reset();
        for (int i = 0; i < this.detector.getNumberOfSets(); ++i) {
            SetMatches matches = this.setMatches[i];
            this.assocSame.setSource(this.featsLeft0.location[i], this.featsLeft0.description[i]);
            this.assocSame.setDestination(this.featsLeft1.location[i], this.featsLeft1.description[i]);
            this.assocSame.associate();
            this.setMatches(matches.match0to2, this.assocSame.getMatches(), this.featsLeft0.location[i].size);
            this.assocSame.setSource(this.featsRight0.location[i], this.featsRight0.description[i]);
            this.assocSame.setDestination(this.featsRight1.location[i], this.featsRight1.description[i]);
            this.assocSame.associate();
            this.setMatches(matches.match1to3, this.assocSame.getMatches(), this.featsRight0.location[i].size);
        }
    }

    private void cyclicConsistency() {
        for (int i = 0; i < this.detector.getNumberOfSets(); ++i) {
            FastQueue<Point2D_F64> obs0 = this.featsLeft0.location[i];
            FastQueue<Point2D_F64> obs1 = this.featsRight0.location[i];
            FastQueue<Point2D_F64> obs2 = this.featsLeft1.location[i];
            FastQueue<Point2D_F64> obs3 = this.featsRight1.location[i];
            SetMatches matches = this.setMatches[i];
            if (matches.match0to1.size != matches.match0to2.size) {
                throw new RuntimeException("Failed sanity check");
            }
            for (int j = 0; j < matches.match0to1.size; ++j) {
                int indexIn1 = matches.match0to1.data[j];
                int indexIn2 = matches.match0to2.data[j];
                if (indexIn1 < 0 || indexIn2 < 0) continue;
                int indexIn3a = matches.match1to3.data[indexIn1];
                int indexIn3b = matches.match2to3.data[indexIn2];
                if (indexIn3a < 0 || indexIn3b < 0 || indexIn3a != indexIn3b) continue;
                QuadView v = this.quadViews.grow();
                v.v0 = obs0.get(j);
                v.v1 = obs1.get(indexIn1);
                v.v2 = obs2.get(indexIn2);
                v.v3 = obs3.get(indexIn3a);
            }
        }
    }

    private void setMatches(GrowQueue_I32 matches, FastQueue<AssociatedIndex> found, int sizeSrc) {
        int j;
        matches.resize(sizeSrc);
        for (j = 0; j < sizeSrc; ++j) {
            matches.data[j] = -1;
        }
        for (j = 0; j < found.size; ++j) {
            AssociatedIndex a = found.get(j);
            matches.data[a.src] = a.dst;
        }
    }

    private void describeImage(T left, ImageInfo<TD> info) {
        this.detector.process(left);
        for (int i = 0; i < this.detector.getNumberOfSets(); ++i) {
            PointDescSet<TD> set = this.detector.getFeatureSet(i);
            FastQueue<Point2D_F64> l = info.location[i];
            FastQueue d = info.description[i];
            for (int j = 0; j < set.getNumberOfFeatures(); ++j) {
                l.grow().set(set.getLocation(j));
                ((TupleDesc)d.grow()).setTo(set.getDescription(j));
            }
        }
    }

    private boolean estimateMotion() {
        this.modelFitData.reset();
        Point2D_F64 normLeft = new Point2D_F64();
        Point2D_F64 normRight = new Point2D_F64();
        for (int i = 0; i < this.quadViews.size; ++i) {
            QuadView obs = this.quadViews.get(i);
            this.leftImageToNorm.compute(obs.v0.x, obs.v0.y, normLeft);
            this.rightImageToNorm.compute(obs.v1.x, obs.v1.y, normRight);
            this.triangulate.triangulate(normLeft, normRight, this.leftToRight, obs.X);
            if (Double.isInfinite(obs.X.normSq())) continue;
            Stereo2D3D data = this.modelFitData.grow();
            this.leftImageToNorm.compute(obs.v2.x, obs.v2.y, data.leftObs);
            this.rightImageToNorm.compute(obs.v3.x, obs.v3.y, data.rightObs);
            data.location.set(obs.X);
        }
        if (!this.matcher.process(this.modelFitData.toList())) {
            return false;
        }
        Se3_F64 oldToNew = this.matcher.getModelParameters();
        if (this.modelRefiner != null) {
            Se3_F64 found = new Se3_F64();
            if (this.modelRefiner.fitModel(this.matcher.getMatchSet(), oldToNew, found)) {
                found.invert(this.newToOld);
            } else {
                oldToNew.invert(this.newToOld);
            }
        } else {
            oldToNew.invert(this.newToOld);
        }
        Se3_F64 temp = new Se3_F64();
        this.newToOld.concat(this.leftCamToWorld, temp);
        this.leftCamToWorld.set(temp);
        return true;
    }

    private String toString(Se3_F64 motion) {
        double[] euler = ConvertRotation3D_F64.matrixToEuler(motion.getR(), EulerType.XYZ, null);
        return String.format("%5e %5e %5e", euler[0], euler[1], euler[2]);
    }

    public ModelMatcher<Se3_F64, Stereo2D3D> getMatcher() {
        return this.matcher;
    }

    public FastQueue<QuadView> getQuadViews() {
        return this.quadViews;
    }

    public Se3_F64 getLeftToWorld() {
        return this.leftCamToWorld;
    }

    public static class QuadView {
        public Point3D_F64 X = new Point3D_F64();
        public Point2D_F64 v0;
        public Point2D_F64 v1;
        public Point2D_F64 v2;
        public Point2D_F64 v3;
    }

    public static class SetMatches {
        GrowQueue_I32 match0to1 = new GrowQueue_I32(10);
        GrowQueue_I32 match0to2 = new GrowQueue_I32(10);
        GrowQueue_I32 match2to3 = new GrowQueue_I32(10);
        GrowQueue_I32 match1to3 = new GrowQueue_I32(10);

        public void swap() {
            GrowQueue_I32 tmp = this.match2to3;
            this.match2to3 = this.match0to1;
            this.match0to1 = tmp;
        }

        public void reset() {
            this.match0to1.reset();
            this.match0to2.reset();
            this.match2to3.reset();
            this.match1to3.reset();
        }
    }

    public static class ImageInfo<TD extends TupleDesc> {
        FastQueue<Point2D_F64>[] location;
        FastQueue<TD>[] description;

        public ImageInfo(DetectDescribeMulti<?, TD> detector) {
            this.location = new FastQueue[detector.getNumberOfSets()];
            this.description = new FastQueue[detector.getNumberOfSets()];
            for (int i = 0; i < this.location.length; ++i) {
                this.location[i] = new FastQueue<Point2D_F64>(100, Point2D_F64.class, true);
                this.description[i] = UtilFeature.createQueue(detector, 100);
            }
        }

        public void reset() {
            for (int i = 0; i < this.location.length; ++i) {
                this.location[i].reset();
                this.description[i].reset();
            }
        }
    }
}

