/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.triangulate;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.CameraPinhole;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;

public class Triangulate2ViewReprojectionMetricError {
    CameraPinhole intrinsicA;
    CameraPinhole intrinsicB;
    Point3D_F64 Xb = new Point3D_F64();
    Point2D_F64 pixelN = new Point2D_F64();
    Point2D_F64 pixelX = new Point2D_F64();

    public void configure(CameraPinhole parametersA, CameraPinhole parametersB) {
        this.intrinsicA = parametersA;
        this.intrinsicB = parametersB;
    }

    public double process(Point2D_F64 a, Point2D_F64 b, Se3_F64 a_to_b, Point3D_F64 Xa) {
        PerspectiveOps.convertNormToPixel(this.intrinsicA, a.x, a.y, this.pixelN);
        PerspectiveOps.convertNormToPixel(this.intrinsicA, Xa.x / Xa.z, Xa.y / Xa.z, this.pixelX);
        double error = this.pixelN.distance2(this.pixelX);
        a_to_b.transform(Xa, this.Xb);
        PerspectiveOps.convertNormToPixel(this.intrinsicB, b.x, b.y, this.pixelN);
        PerspectiveOps.convertNormToPixel(this.intrinsicB, this.Xb.x / this.Xb.z, this.Xb.y / this.Xb.z, this.pixelX);
        return (error + this.pixelN.distance2(this.pixelX)) / 2.0;
    }
}

