/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.triangulate;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public class PixelDepthLinearMetric {
    private DMatrixRMaj temp0 = new DMatrixRMaj(3, 3);
    private Vector3D_F64 temp1 = new Vector3D_F64();
    private Vector3D_F64 temp2 = new Vector3D_F64();

    public double depthNView(List<Point2D_F64> obs, List<Se3_F64> motion) {
        double top = 0.0;
        double bottom = 0.0;
        Point2D_F64 a = obs.get(0);
        for (int i = 1; i < obs.size(); ++i) {
            Se3_F64 se = motion.get(i - 1);
            Point2D_F64 b = obs.get(i);
            GeometryMath_F64.multCrossA(b, se.getR(), this.temp0);
            GeometryMath_F64.mult(this.temp0, a, (GeoTuple3D_F64)this.temp1);
            GeometryMath_F64.cross((GeoTuple2D_F64)b, (GeoTuple3D_F64)se.getT(), (GeoTuple3D_F64)this.temp2);
            top += this.temp2.x + this.temp2.y + this.temp2.z;
            bottom += this.temp1.x + this.temp1.y + this.temp1.z;
        }
        return -top / bottom;
    }

    public double depth2View(Point2D_F64 a, Point2D_F64 b, Se3_F64 fromAtoB) {
        DMatrixRMaj R = fromAtoB.getR();
        Vector3D_F64 T = fromAtoB.getT();
        GeometryMath_F64.multCrossA(b, R, this.temp0);
        GeometryMath_F64.mult(this.temp0, a, (GeoTuple3D_F64)this.temp1);
        GeometryMath_F64.cross((GeoTuple2D_F64)b, (GeoTuple3D_F64)T, (GeoTuple3D_F64)this.temp2);
        return -(this.temp2.x + this.temp2.y + this.temp2.z) / (this.temp1.x + this.temp1.y + this.temp1.z);
    }
}

