/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.alg.feature.detect.extract.NonMaxBlock;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I32;

public abstract class NonMaxBlockSearchRelaxed
implements NonMaxBlock.Search {
    Point2D_I32[] foundMax;
    Point2D_I32[] foundMin;
    float thresholdMin;
    float thresholdMax;
    int radius;
    private QueueCorner localMin;
    private QueueCorner localMax;
    GrayF32 img;

    @Override
    public void initialize(NonMaxBlock.Configuration configuration, GrayF32 image, QueueCorner localMin, QueueCorner localMax) {
        this.thresholdMin = configuration.thresholdMin;
        this.thresholdMax = configuration.thresholdMax;
        this.radius = configuration.radius;
        this.img = image;
        this.localMin = localMin;
        this.localMax = localMax;
        int w = 2 * this.radius + 1;
        if (this.foundMax == null || this.foundMax.length != w * w) {
            int i;
            this.foundMax = new Point2D_I32[w * w];
            for (i = 0; i < this.foundMax.length; ++i) {
                this.foundMax[i] = new Point2D_I32();
            }
            this.foundMin = new Point2D_I32[w * w];
            for (i = 0; i < this.foundMin.length; ++i) {
                this.foundMin[i] = new Point2D_I32();
            }
        }
    }

    protected void checkLocalMax(int x_c, int y_c, float peakVal, GrayF32 img) {
        int x0 = x_c - this.radius;
        int x1 = x_c + this.radius;
        int y0 = y_c - this.radius;
        int y1 = y_c + this.radius;
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (x1 >= img.width) {
            x1 = img.width - 1;
        }
        if (y1 >= img.height) {
            y1 = img.height - 1;
        }
        for (int y = y0; y <= y1; ++y) {
            int index = img.startIndex + y * img.stride + x0;
            for (int x = x0; x <= x1; ++x) {
                int n = index++;
                float v = img.data[n];
                if (!(v > peakVal)) continue;
                return;
            }
        }
        this.localMax.add(x_c, y_c);
    }

    protected void checkLocalMin(int x_c, int y_c, float peakVal, GrayF32 img) {
        int x0 = x_c - this.radius;
        int x1 = x_c + this.radius;
        int y0 = y_c - this.radius;
        int y1 = y_c + this.radius;
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (x1 >= img.width) {
            x1 = img.width - 1;
        }
        if (y1 >= img.height) {
            y1 = img.height - 1;
        }
        for (int y = y0; y <= y1; ++y) {
            int index = img.startIndex + y * img.stride + x0;
            for (int x = x0; x <= x1; ++x) {
                int n = index++;
                float v = img.data[n];
                if (!(v < peakVal)) continue;
                return;
            }
        }
        this.localMin.add(x_c, y_c);
    }

    public static class MinMax
    extends NonMaxBlockSearchRelaxed {
        @Override
        public void searchBlock(int x0, int y0, int x1, int y1) {
            int i;
            int numMinPeaks = 0;
            float peakMinVal = this.thresholdMin;
            int numMaxPeaks = 0;
            float peakMaxVal = this.thresholdMax;
            for (int y = y0; y < y1; ++y) {
                int index = this.img.startIndex + y * this.img.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    int n = index++;
                    float v = this.img.data[n];
                    if (v < peakMinVal) {
                        peakMinVal = v;
                        this.foundMin[0].set(x, y);
                        numMinPeaks = 1;
                    } else if (v == peakMinVal) {
                        this.foundMin[numMinPeaks++].set(x, y);
                    }
                    if (v > peakMaxVal) {
                        peakMaxVal = v;
                        this.foundMax[0].set(x, y);
                        numMaxPeaks = 1;
                        continue;
                    }
                    if (v != peakMaxVal) continue;
                    this.foundMax[numMaxPeaks++].set(x, y);
                }
            }
            if (numMinPeaks > 0 && peakMinVal != -3.4028235E38f) {
                for (i = 0; i < numMinPeaks; ++i) {
                    Point2D_I32 p = this.foundMin[i];
                    this.checkLocalMin(p.x, p.y, peakMinVal, this.img);
                }
            }
            if (numMaxPeaks > 0 && peakMaxVal != Float.MAX_VALUE) {
                for (i = 0; i < numMaxPeaks; ++i) {
                    Point2D_I32 p = this.foundMax[i];
                    this.checkLocalMax(p.x, p.y, peakMaxVal, this.img);
                }
            }
        }

        @Override
        public boolean isDetectMinimums() {
            return true;
        }

        @Override
        public boolean isDetectMaximums() {
            return true;
        }

        @Override
        public NonMaxBlock.Search newInstance() {
            return new MinMax();
        }
    }

    public static class Min
    extends NonMaxBlockSearchRelaxed {
        @Override
        public void searchBlock(int x0, int y0, int x1, int y1) {
            int numPeaks = 0;
            float peakVal = this.thresholdMin;
            for (int y = y0; y < y1; ++y) {
                int index = this.img.startIndex + y * this.img.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    int n = index++;
                    float v = this.img.data[n];
                    if (v < peakVal) {
                        peakVal = v;
                        this.foundMin[0].set(x, y);
                        numPeaks = 1;
                        continue;
                    }
                    if (v != peakVal) continue;
                    this.foundMin[numPeaks++].set(x, y);
                }
            }
            if (numPeaks > 0 && peakVal != -3.4028235E38f) {
                for (int i = 0; i < numPeaks; ++i) {
                    Point2D_I32 p = this.foundMin[i];
                    this.checkLocalMin(p.x, p.y, peakVal, this.img);
                }
            }
        }

        @Override
        public boolean isDetectMinimums() {
            return true;
        }

        @Override
        public boolean isDetectMaximums() {
            return false;
        }

        @Override
        public NonMaxBlock.Search newInstance() {
            return new Min();
        }
    }

    public static class Max
    extends NonMaxBlockSearchRelaxed {
        @Override
        public void searchBlock(int x0, int y0, int x1, int y1) {
            int numPeaks = 0;
            float peakVal = this.thresholdMax;
            for (int y = y0; y < y1; ++y) {
                int index = this.img.startIndex + y * this.img.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    int n = index++;
                    float v = this.img.data[n];
                    if (v > peakVal) {
                        peakVal = v;
                        this.foundMax[0].set(x, y);
                        numPeaks = 1;
                        continue;
                    }
                    if (v != peakVal) continue;
                    this.foundMax[numPeaks++].set(x, y);
                }
            }
            if (numPeaks > 0 && peakVal != Float.MAX_VALUE) {
                for (int i = 0; i < numPeaks; ++i) {
                    Point2D_I32 p = this.foundMax[i];
                    this.checkLocalMax(p.x, p.y, peakVal, this.img);
                }
            }
        }

        @Override
        public boolean isDetectMinimums() {
            return false;
        }

        @Override
        public boolean isDetectMaximums() {
            return true;
        }

        @Override
        public NonMaxBlock.Search newInstance() {
            return new Max();
        }
    }
}

