(function () {
	var courriel = angular.module("courriel", ['ui.grid', 'ui.grid.selection', 'ui.grid.pagination', 'ui.bootstrap', 'patient']);

	courriel.run(function ($templateCache, $http, $transitions, model) {

		$transitions.onSuccess({ to: 'root.view.Courriels' }, function(transition) {
			// console.log("Now at 'root.view.Courriels'' state" + transition.params().folder);
			var folder = parseInt(transition.params().folder);
			var courrielId = parseInt(transition.params().msg);
			model.courriel().activeCourrielFolder = folder !== NaN ? folder: transition.params().folder;
			if(courrielId !== NaN){
				model.courriel().activeCourrielId = courrielId
			}
			model.callDashBoardCount();
		});

		$http.get('/dashboard/resources/ofys/user/user_dataItem.html?v=bk').then(
			function (res) {
				$templateCache.put('/dashboard/resources/ofys/user/user_dataItem.html?v=bk', res.data);
			}
		);
	});
	
	courriel.factory('MessageLink',['$log','Event','model', function($log, Event, model){
		//reinitializes the message link objects.
		function flushMessageLink(){
			accessor.active = {};
			accessor.list = [];
		}
		var accessor = {
				linkTypes : {none:'S_O', patient:'PATIENT',labo:'LABO', doc:'SCAN', encounter:'RENCONTRE', form:'FORM'},
				linkTypesArray : ['S_O', 'PATIENT','LABO', 'SCAN', 'RENCONTRE', 'FORM'],
				//Sets a messagelink object as the current messagelink of the application and returns an id
				//The returned id can be used to remove the link when the context changes or the scope is destroy.
				//The messageLink Object structure is {patient: '{id: 23, }', linkType : 'SCAN' ; id:123}
				setLinkType: function(messageLink, scope){
					// flushMessageLink();
					var key = messageLink.linkType+messageLink.id;
					if(accessor.active[key]){
						accessor.active[key].linkCount++;
						// $log.log("Link ++:"+ accessor.active[key].linkCount+ key  );
					}else{
						accessor.active[key] = messageLink;
						accessor.active[key].linkCount = 1;
						// $log.log("Initial link add:"+ accessor.active[key].linkCount+ key  );
						
						accessor.list.push(key);
					}
					if(scope){
						scope.$on("$destroy", function() {
							accessor.removeLinkType(key);
						});
					}
					// console.log("setLinkType::::::");
					// console.log(accessor.list)
					return key;
				},
				active: {},
				list: [],
				removeLinkType: function(id){
					var index = accessor.list.indexOf(id);
					if(accessor.active[id] && accessor.active[id].linkCount){
						accessor.active[id].linkCount--;

						// $log.log("Link --:"+ accessor.active[id].linkCount+ id  );
						if(accessor.active[id].linkCount < 1){
							doRemove();
						}
					}else{
						doRemove()
					}

					function doRemove(){
						if(accessor.active[id]){
							// $log.log("Link del:"+accessor.active[id].linkCount+ id );
							delete accessor.active[id];
							if(index > -1){
								accessor.list.splice(index, 1);
							}
						}
					}
					// console.log("removeLinkType::::::");
					// console.log(accessor.list)
				},
				getMessageLink: function(data){
					if(accessor.list.length > 0){
						data = accessor.active[accessor.list[accessor.list.length -1]];
					}
					return data;
				},
				linkParams:function(data){
					data = accessor.getMessageLink(data);
					var params = "";
					if(angular.isDefined(data) && typeof data !== "function"){
						params = "?"+"linkType="+ data.linkType + "&linkPatient="+ data.patient+"&linkId="+data.id;
					}
					return params;
				},
				allManagers:{},//Index of all linkManagers.
				/**
				 * This function manages link adding and removing strategies that work to make sure that 
				 * The link is not added more than required and that no leaks 
				 * 
				 * When called it adds the link immediately.
				 * it can be called multiple times on update of a document and it provides a clear() function.
				 * 
				 */
				linkManager: function(accessorObj, activeElement, addingDocumentid, scope){
					//Function not supported in External Quickview
					if(model.qv().isExternal){
						return {clear:angular.noop};
					}

					var managerApi = {
						clear: function (){
							if(angular.isDefined(accessorObj.messageLinkKey) && 
								accessorObj.messageLinkKey !== "" &&
								accessorObj.msgLinkMap[addingDocumentid] !== undefined){
								accessor.removeLinkType(accessorObj.messageLinkKey);
								if(Object.keys(accessorObj.msgLinkMap).length === 0){
									delete accessorObj.messageLinkKey
								}
								delete accessorObj.msgLinkMap[addingDocumentid]
								if(managerApi.activityChangedListener){
									Event.off(managerApi.activityChangedListener)
									delete managerApi.activityChangedListener;
								}
								if(managerApi.activityClosedListener){
									Event.off(managerApi.activityClosedListener)
									delete managerApi.activityClosedListener;
								}
								if(managerApi.activityMinimizeListener){
									Event.off(managerApi.activityMinimizeListener)
									delete managerApi.activityMinimizeListener;
								}
								delete accessor.allManagers[addingDocumentid];
							}
						}
					}

					function addMessageLink(){
						var alreadyAddedDocs = Object.keys(accessorObj.msgLinkMap);
						if(alreadyAddedDocs.length > 0){
							//In this case the same editor is trying to add another file while on is already in current cue.
							//remove the previous before adding the new ones.
							alreadyAddedDocs.forEach(function(e){
								if(typeof accessor.allManagers[e] != "undefined"){
									accessor.allManagers[e].clear();
								}
							})
						}

						if (addingDocumentid) {
							managerApi.clear();
							accessorObj.updateMessageLink(activeElement,undefined,addingDocumentid);
							scope.$on('$destroy',  managerApi.clear);
							if(scope.qv && scope.qv.onQvActivityChange){
								managerApi.activityChangedListener = Event.on(scope.qv.onQvActivityChange, managerApi.clear)
							}
							if(scope.qv && scope.qv.onQvClose){
								managerApi.activityClosedListener = Event.on(scope.qv.onQvClose, managerApi.clear)
							}
							if(scope.qv && scope.qv.onQvMinimize){
								managerApi.activityMinimizeListener = Event.on(scope.qv.onQvMinimize, managerApi.clear)
							}
						}
					}
					addMessageLink();
					accessor.allManagers[addingDocumentid] = managerApi;
					return managerApi;
				}
		}
		return accessor;
	}]);

	courriel.factory('CourrielAccessor', ['DashAPI', 'MessageLink', 'model', '$filter', 'QuickEdit',
		function (DashAPI, MessageLink, model, $filter, QuickEdit) {
			function emptyCourrielOpen(){
				var allQe = Object.keys(model.qe().items)
				for (var i = 0; i < allQe.length; i++) {
					var qeItem = model.qe().items[allQe[i]];
					if(qeItem.quickEditData.viewerType === "courriel" &&
						(qeItem.qe.message == undefined ||
						(qeItem.qe.message.dataText == undefined &&
							(qeItem.qe.message.courrielDest == undefined || qeItem.qe.message.courrielDest.length == 0)
						))
					){
							return qeItem;
					}
				}
			}
			var accessor = {
				presetFolders: {
					SEARCH:"SEARCH",
					NEW:1,
					INBOX:2,
					ARCH:3,	// les deleted
					ENV:4,
				},
				patientlist: function (data, callback, error) {
					DashAPI.get('/dashboard/courriel/ws/list/bypat?id=' + data.id, callback, error);
				},
				find: function (query, callback, error) {
					return DashAPI.post('/dashboard/courriel/ws/find', query, callback, error);
				},
				findIds: function (query, callback, error) {
					return DashAPI.post('/dashboard/courriel/ws/findIds', query, callback, error);
				},
				findIdsByfolder: function (data, callback, error) {
					var q = 'idPerson=' + data.idPerson + '&folderId='+data.folderId;
					return DashAPI.get('/dashboard/courriel/ws/findIdsPerFolder?' + q, callback, error);
				},
				bypat: function (data, callback, error) {
					return DashAPI.get('/dashboard/courriel/ws/list/bypat?id='+data.id, callback, error);
				},
				frompat:function(data, callback,error){
					return DashAPI.get('/dashboard/courriel/ws/list/frompat?patId='+data.id, callback, error);
				},
				byIds: function (data, callback, error) {
					return DashAPI.get('/dashboard/courriel/ws/byIds?ids=' + data.ids, callback, error);
				},
				responses: function (data, callback, error) {
					return DashAPI.get('/dashboard/courriel/ws/responses?id=' + data.id, callback, error);
				},
				previous: function (data, callback, error) {
					return DashAPI.get('/dashboard/courriel/ws/previous?id=' + data.id, callback, error);
				},
				setRead: function (data, callback, error) {
					return DashAPI.get('/dashboard/courriel/ws/setRead?ids=' + data.ids, callback, error);
				},
				setUnread: function (data, callback, error) {
					return DashAPI.get('/dashboard/courriel/ws/setUnread?ids=' + data.ids, callback, error);
				},
				setArchive: function (data, callback, error) {
					return DashAPI.get('/dashboard/courriel/ws/setArchive?ids=' + data.ids, callback, error);
				},
				setUnarchive: function (data, callback, error) {
					return DashAPI.get('/dashboard/courriel/ws/setUnarchive?ids=' + data.ids, callback, error);
				},
				moveTo: function (data, callback, error) {
					return DashAPI.get('/dashboard/courriel/ws/moveTo?ids=' + data.ids+ "&folder="+ data.folder, callback, error);
				},
				openNew: function (data, patient) {
					var emptyCourrielQe = emptyCourrielOpen();
					if(emptyCourrielQe == undefined){
						var act = { className: "CCourrielTexte" };
						var payload = { quickEditData: {allowClose: true,allowSettings: false, qeActData: { className: "CCourrielTexte" } }, templateUrl: "qe_courriel_editor_index.html", heading: $filter('translate')('NEW_MSG')};
						if(data){
							$.extend(act, data);
							payload.qe = { message: act, parseMessage: true };
						} else {
							payload.qe = { message: act, parseMessage: false };
						}
						if(patient){
							payload.qe.type = "TO_PATIENT";
						}
						return QuickEdit.open(payload);
					}else{
						console.log("An empty courriel text was already opened.");
						// QuickEdit.api.setActiveEditor(emptyCourrielQe);
					}
				},
				openNewToPatient: function(patient, text){
//					var title;
//					var texte;
//					if (text && text.length>10) {
//						const lines = text.split('\n');
//						// Regex to match either "Objet:" or "Object:" (case-insensitive)
//						const objetRegex = /^(Objet|Object):\s*/i;
//						
//						// Extract first line and remove the "Objet:" or "Object:" prefix
//						const objetLine = lines[0].replace(objetRegex, '').trim();
//						
//						// Skip first two lines (the title and the blank line)
//						const reste = lines.slice(2).join('\n').trim();
//						
//						title = objetLine;
//						texte = reste;						
//					}
					this.openNew({presetPat: patient, dataText:text}, patient);
				},
				nameFolder: function (folder, callback, error) {
					var q = "?id="+folder.folder+"&idUser="+folder.idUser+"&name="+ b64EncodeUnicode(folder.name);
					if(folder.sendContentTo !== undefined){
						q += "&toFolder="+ folder.sendContentTo;
					}
					return DashAPI.get('/dashboard/courriel/ws/nameFolder'+q, callback, error);
				},
				open: function (id, callback, error) {
					return DashAPI.get('/dashboard/courriel/ws/openCourriel?id=' + id, callback, error);
				},
				save: function (courriel, callback, error) {
					return DashAPI.post('/dashboard/courriel/ws/save', courriel, callback, error);
				},
				// pour les cas où le nom attribué à la tâche est un employé ou un user
				getUserName: function (id) {
					if (!angular.isUndefined(id) && !angular.isUndefined(model.user().list[id])) {
						var user = model.user().list[id];
						if (!angular.isUndefined(user.personName)) {
							return user.personName;
						} else if (!angular.isUndefined(user.str)) {
							return user.str;
						}
					} else {
						return null;
					}
				},
				getFromUserName: function (courriel) {
					if (!angular.isUndefined(courriel.fromUserNMd)) {
						return courriel.fromUserNMd;
					} else if (!angular.isUndefined(courriel.fromUserNEmp)) {
						return courriel.fromUserNEmp;
					} else if (!angular.isUndefined(courriel.fromUserNClin)) {
						return courriel.fromUserNClin;
					} else {
						return null;
					}
				},
				msgLinkMap:{},//Used for message/courriel link of current document.
				updateMessageLink: function (patient,scope, uid){
					accessor.messageLinkKey = MessageLink.setLinkType({
						patient: patient.id,
						linkType: MessageLink.linkTypes.patient,
						id: patient.id,
						pat: patient
					},scope);
					accessor.msgLinkMap[uid] = accessor.messageLinkKey
				}
			};
			return accessor;
	}]);

	courriel.directive('courrielSearch',['CourrielAccessor', 'PatientAccessor', '$q', 'utils', '$timeout','$filter','model',
		function(CourrielAccessor, PatientAccessor, $q, utils, $timeout,$filter, model ){
		return {
			restrict:'AE',
			link:function(scope, element, attrs){
				var patientSearchTemplate = '/dashboard/resources/ofys/pat/profil/patient_searchItem.html?v=bk';
				var patientSearchItemHtml;
				utils.getTemplate(patientSearchTemplate, function(html){
					patientSearchItemHtml = html;
				});
				scope.searchableFolders = [
					{ name: ""},
					{ folder: 1, name: $filter('translate')('UnreadMessages')},
					{ folder: 2, name: $filter('translate')('Inbox')},
					{ folder: 3, name: $filter('translate')('Archived')},
					{ folder: 4, name: $filter('translate')('Sent')}
				].concat(scope.folders);

				// console.log(scope.folders);

				scope.startDateDyna = {
					format: 'YYYY-MM-DD',
					acceptFutureDate: false,
				}
				scope.endDateDyna = {
					format: 'YYYY-MM-DD',
					acceptFutureDate: false,
				}

				scope.fromPersonSearchScope= {
					setUser: function(user){
						scope.vb.setFrom(user);
					}
				}

				scope.toPersonSearchScope= {
					setUser: function(user){
						scope.vb.setTo(user);
					}
				}

				function getCriteria(){
					var c = angular.copy(scope.vb.criteria);
					if(scope.vb.start || scope.vb.end){
						if(scope.vb.start && scope.vb.end && scope.vb.end < scope.vb.start){
							scope.vb.end = "";
						}
						c.sendDateRange = {};
						if(scope.vb.start){
							c.sendDateRange.start = OfysUtils.stringToLocalDate(scope.vb.start);
						}
						if(scope.vb.end){
							c.sendDateRange.end = OfysUtils.stringToLocalDate(scope.vb.end);
						}
					}
					c.idPersonMailbox = model.currentCourrielUser().personId;
					return c;
				}

				scope.patientSearchAssist = {
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					trigger: 'focus',
					getAsyncData: function(query, assist){
						query = query.replace(',', '');//make sure that composed names with commas are searchable too
						return $q(function(resolve, reject) {
							if(query.length > 2){
								PatientAccessor.search(b64EncodeUnicode(query), function(res){
									resolve(res.data);
								}, angular.noop);
							}else{
								resolve([]);
							}
						});
					},
					getKey: function(recipient) {
						var newScope = scope.$new();
						newScope.item = recipient;
						var res =  utils.getTemplateAndCompileSync(newScope, patientSearchTemplate);
						$timeout(function(){
							if(!newScope.$$phase) {
								newScope.$digest();
							}
						},0);
						return res;
					},
					selection: function(pat, assistObject) {
						scope.vb.criteria.idPatient = pat.id;
						scope.vb.pat = pat;
						scope.vb.patName = pat.lastName + ', '+ pat.firstName;
						return scope.vb.patName;
					}
				};
				scope.setName = function(){
					if(scope.vb.pat){
						scope.vb.patName = scope.vb.pat.lastName + ', '+ scope.vb.pat.firstName;
					}
				}
				scope.removePatient = function(){
					delete scope.vb.criteria.idPatient;
					delete scope.vb.pat;
					scope.vb.patName = "";
				}

				scope.search = function(){
					var criteria = getCriteria();
					CourrielAccessor.findIds(criteria, function(res){
						if(res){
							model.courriel().activeCourrielFolder = scope.presetFolders.SEARCH;
							scope.setActiveIds(res)
							if(scope.$parent && scope.$parent.$hide){
								scope.$parent.$hide();
							}
						}
					});
				}
			}
		}
	}]);

	courriel.controller('CourrielController', ['$scope', 'CourrielAccessor', 'model', 'UserAccessor', '$transitions', '$state', '$filter',
		function ($scope, CourrielAccessor, model, UserAccessor, $transitions, $state, $filter) {
			$scope.model = model;
			$scope.sessionUserId = model.user().profil.idPerson;
			$scope.activeFolderIds = [];
			$scope.presetFolders = CourrielAccessor.presetFolders;
			$scope.courrielOptions = {
				onOpen: function(api){
					if(api){
						this.api = api;
					}
					// set initial mail if already set. Useful for quickview state persistance of courrielview.
					if(model.courriel().currMail && this.api && this.api.setAsCurrent){
						this.api.setAsCurrent(model.courriel().currMail);
					}
				},
			}
			var allFolders = (function(){
				var res = [];
				for (let i = 5; i < 20; i++) {
					res.push(i);
				}
				return res;
			})();

			$scope.folders = [];
			var userPref = model.user().sessionUser.user.userPreferences;
			for (let i = 5; i < 20; i++) {
				if (userPref['courrielDossier'+i]) {
					$scope.folders.push({folder:i, name:userPref['courrielDossier'+i]});
				}
			}

			function getNextAvailableFolder(){
				if($scope.folders){
					for (let i = 0; i < allFolders.length; i++) {
						var match = $scope.folders.find(function(f){return f.folder == allFolders[i]});
						if(!match){
							return allFolders[i]
						}
					}
				}
			}

			$scope.addFolder = function(){
				var inEdit = $scope.folders.findIndex(function(e){return e.editMode}) != -1;
				if(!inEdit && $scope.folders.length < 16){
					$scope.folders.push({editMode: true, newFolder: true, folder: getNextAvailableFolder()});
				}
			}
			$scope.editFolder = function(folder){
				var inEdit = $scope.folders.findIndex(function(e){return e.editMode}) != -1;
				if(!inEdit){
					folder.editName = folder.name;
					folder.editMode = true;
				}
			}

			$scope.openNewMessage = function(){
				CourrielAccessor.openNew();
			};

			$scope.removeFolder = function(f){
				var i = $scope.folders.indexOf(f);
				if(i > -1){
					userPref['courrielDossier'+f.folder] = "";
					$scope.folders.splice(i, 1);
					model.courrielViewUpdate(true);
				}
			}

			$scope.commitFolder = function(f){
				// check for name collisions before commit
				//var user = model.user().sessionUser.user;
				//var dos5 = user.userPreferences.courrielDossier5;
				f.idUser = model.user().sessionUser.user.id;
				// FIXME il faudra bloquer les changements de noms de dossier si currentCourrielUser != currentUser
				// en fait, si activeUser!=currentCourrielUser, les dossiers ne devraient pas être visible - ce qui est mis dans un dossier devient dont privé à l'utilisateur!
				if(f.editName){
					var saveF = angular.copy(f);
					saveF.name = f.editName;
					CourrielAccessor.nameFolder(saveF, function(response){
						// console.log(response);
						if(response && response.data && !response.data.success){
							model.notice().fail($filter('translate')('MAX_BOX_MSG'));
						}else{
							f.editMode = false;
							f.newFolder = false;
							f.name = saveF.name;
							model.user().sessionUser.user.userPreferences['courrielDossier'+f.folder] = saveF.name
							delete f.editName;
							model.courrielViewUpdate(true);
						}
					})
				}else if(f.newFolder){
					$scope.removeFolder(f);
				}else{
					f.editMode = false;
					delete f.editName;
				}
			}

			model.courriel().tabLoaded = true;
			model.activeController('mail');

			$scope.updateActiveFolder = function(activeFolder){
				$scope.courrielOptions.api.closeCurrentMessage();
				model.courriel().activeCourrielFolder = activeFolder ? activeFolder: $scope.presetFolders.NEW;
				//When the folder is updated the controller is reinitiated by the state change and
				// the initCtrl sets the folder listing.
				$state.go('.', {folder: model.courriel().activeCourrielFolder+""})
				// .then(function(res){
				// 	refreshFolders(model.courriel().activeCourrielFolder);
				// });
			}

			function initSearchCriteria(){
				$scope.vb = {
					criteria:{
						courrielUser: model.currentCourrielUser().personId, type:'1'
					},
					setFrom: function(user){
						this.criteria.fromPerson = user.personId;
						this.from = user;
					},
					setTo: function(user){
						this.criteria.toPerson = user.personId;
						this.to = user;
					},
					removeTo:function(){
						delete this.criteria.toPerson;
						delete this.to;
					},
					removeFrom:function(){
						delete this.criteria.fromPerson;
						delete this.from;
					}
				};
			}

			function initCtrler(){
				// model.currentCourrielUser(model.user().profil);
				// console.log(model.currentCourrielUser());
				UserAccessor.listUsersForSelection(function(res){
					$scope.sessionUser = UserAccessor.cleanAndSortUsers(res.data).find(function(e){
						return e.personId === model.user().profil.idPerson;
					});

					if(!model.currentCourrielUser()){
						if($scope.sessionUser){
							$scope.setCurrentCourrielUser($scope.sessionUser, true)
							initSearchCriteria();
						}else{
							console.error("Erreur d'initiation de l'utilisateur des courriels");
						}
					}else{
						refreshFolders(model.courriel().activeCourrielFolder)
						initSearchCriteria();
					}
				});
			}
			function initData(){
				refreshFolders(model.courriel().activeCourrielFolder)
				// .then(function(){
				// 	if($scope.presetFolders.NEW !== model.courriel().activeCourrielFolder){
				// 		refreshFolders($scope.presetFolders.NEW);
				// 	}
				// });
			}

			$scope.sessionUserCourriels = function(){
				$scope.setCurrentCourrielUser($scope.sessionUser)
			}

			$scope.courrielUserIsSessionUser = function(){
				var cUser = model.currentCourrielUser();
				if(cUser){
					return cUser.personId === $scope.sessionUserId;
				}else{
					return false;
				}
			}
			$scope.isUserAdmin = function(){
				return model.user().isUserAdmin===true;
			}

			$scope.setCurrentCourrielUser = function(user, init) {
				model.currentCourrielUser(user);
				model.courriel().clearFolders();
				if (user.personId!=$scope.sessionUserId) {
					model.courriel().activeCourrielFolder = $scope.presetFolders.NEW;
				}
				refreshFolders(model.courriel().activeCourrielFolder);
				// if(init){
				// 	initData();
				// }else{
				// }
			};

			$scope.setUser = function(user){
				// console.log(model.currentCourrielUser());
				// console.log(user);
				$scope.setCurrentCourrielUser(user);
			}

			function updateCourrielIds(folderId) {
				if(folderId != undefined && folderId != $scope.presetFolders.SEARCH){
					$scope.activeFolderIds = model.courriel().folders[folderId];
				}
				model.refreshCountsUpdated(true);
			}

			$scope.setActiveIds = function(ids){
				$scope.activeFolderIds = ids;
			}

			$scope.newCourrielCount = function() {
				if ($scope.courrielUserIsSessionUser()) {
					if (model.user().profil && model.dayData(model.user().profil.id)) {
						var c = model.dayData(model.user().profil.id).cnts;
						return (c===undefined || c.mail_new==null?0:c.mail_new);
					}
				} else {
					return $scope.activeFolderIds ? $scope.activeFolderIds.length : 0;
				}
				return 0;
			}

			$scope.forceReload = function(){
				model.courriel().clearFolders();
				model.callDashBoardCount(function(){
					refreshFolders(model.courriel().activeCourrielFolder);
				}, true);
			}

			function refreshFolders(activeFolder){
				return CourrielAccessor.findIdsByfolder({
					idPerson:model.currentCourrielUser().personId,
					folderId: activeFolder
					}, function(res){
					var resList = res.data ? res.data : {};
					model.courriel().setFolders(resList);
					updateCourrielIds(model.courriel().activeCourrielFolder);
					// $scope.updateActiveFolder(activeFolder);
				});
			}
			initCtrler();

	}]);

	courriel.directive('courrielView',
		['CourrielAccessor','TaskAccessor','model','$timeout','$q', '$log', '$filter','MessageLink',
		function (CourrielAccessor, TaskAccessor, model, $timeout, $q, $log, $filter, MessageLink){
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/courriel/courriel_view.html?v=bk',
				scope: {
					courriels:"=",
					inputCourriel:"=?",
					quickViewData:"=?",
					options:"=",
					filterapi:"=",
					folders:"=",
					folder:"=",
				},
				link: function (scope, element, attrs) {
					//VIEW MODES
					scope.vb = {};
					scope.model = model;
					scope.PEEKLIST = "PEEKLIST";
					scope.PEEKDETAILS = "PEEKDETAILS";
					scope.MAILDETAILS = "MAILDETAILS";
					scope.responding = false;
					scope.selectedList = {all: false, ids:{}};
					scope.actOptions = {mode:'n', externalise: true};
					scope.dest = {
						options: {
							setUser : function(user){
								if(scope.viewMail.vb.response.courrielDest.findIndex(function(e){return e.idPerson === user.personId}) === -1){
									scope.viewMail.vb.response.courrielDest.push(userToDest(user));
								}
							}
						}
					};

					scope.getAllLinks = function(mail){
						return mail.laboFile.length+mail.formData.length+mail.patientImage.length;
					};

					scope.formatReadDate = function(d) {
						var dd
						if (d) {
							dd = new moment(d).format("YYYY-MM-DD HH:mm");
						}
						if (dd) {
							return $filter('translate')('MessageRead') + dd;
						}
						return $filter('translate')('MessageNotRead');
					}

					scope.numberOfRead = function(mail){
						var nor = 0;
						if (mail) {
							mail.courrielDest.forEach(function(dest){
								if (dest.readDate) nor++;
							});
							mail.numberOfRead = nor;
						}
						return nor;
					};
					scope.getFromName = function(mail){
						return mail ? mail.fromNamePlus : undefined;
					};
					scope.getToName = function(mail){
						return mail ? destNames(mail.courrielDest) : undefined;
					};

					function destNames(dests){
						if(dests && dests.length > 0){
//							var nameToShow;
//							if (dests.length == 1) return dests[0].toNamePlus;
//							if (model.user() && model.user().profil){
//								var personId = model.user().profil.idPerson;
//								var idx = -1;
//								for (let i = 0; i < dests.length; i++) {
//									if (personId===dests[i].idPerson) {
//										nameToShow = dests[i].toNamePlus;
//										idx = i;
//										break;
//									}
//								}
//								if (idx!=-1) {
//									dests.slice(idx, 1);
//								}
//							}
//							if (nameToShow) {
//								return nameToShow + (" +"+(dests.length));
//							}
							return dests[0].toNamePlus + (dests.length > 1 ? (" +"+(dests.length-1)):"");
						}
					}

					function userToDest(user){
						return {idPerson: user.personId, toNamePlus: user.personName};
					}
					scope.isArchive = function(){
						return scope.folder === 3;
					}

					scope.isSentFolder = function(){
						return scope.folder === 4 || scope.folder==='SEARCH';
					}

					scope.isMailSender = function(mail){
						var personId;
						var cUser = model.currentCourrielUser();
						if(cUser){
							personId = model.currentCourrielUser().personId;
						}else if (model.user() && model.user().profil){
							personId = model.user().profil.idPerson;
						}
						if (personId && mail) {
							return mail.fromIdPerson===personId && (scope.folder===4 || scope.folder==='SEARCH');
						}
						return false;
					};

					scope.searchDest= function(){
						if(scope.vb && scope.vb.focusDestSearchInput){
							scope.vb.focusDestSearchInput();
						}
					}
					scope.clearSelection = function(){
						scope.selectedList.all = false;
						scope.selectedList.ids = {};
					}
					scope.selectCount = 0;
					scope.allToogleSelectedList = function(){
						if(scope.selectedList.all){
							scope.selectCount = 0;
							scope.displayMails.forEach(function(e){
								scope.selectedList.ids[e.currentDest.id] = true;
								scope.selectCount++;
							});
						}else{
							scope.selectedList.ids = {};
							scope.selectCount = 0;
						}
					}

					scope.patientDataSelector = {
						activeCategories: ['labo', 'doc', 'form', 'formCRDS', 'formCNESST'],
						getPatient: function(){
							return scope.viewMail.vb.response.patient;
						},
						saveSelection:function(selection){
							if(!scope.viewMail.vb.response.patientdata){
								scope.viewMail.vb.response.patientdata  = {}
							}
							$.extend(scope.viewMail.vb.response.patientdata, selection);
						},
						onOpen: function(hideFn){
							scope.patientDataSelector.hide = hideFn;
						}
					}

					scope.getType = function(act){
						if ('CLaboFile'===act.className || 'CLaboResultsProfessionnal'===act.className) {
							return "lab";
						}else if(act.className === "CBasePatientImage" || act.className === "CPatientImage"){
							return "doc"
						}else if(act.className === "CFormData"){
							return "form"
						}
					}

					var pagination = [];
					var PAGESIZE = 30;
					var activePage = 0;
					scope.nextPage = function(dir){
						if (dir===-1 || pagination.length===0) {
							return;
						}
						if (pagination.length > activePage+dir) {
							activePage += dir;
							// console.log("Get next page");
							getCourrielList({ids: pagination[activePage]}, scope.folder);
						}
					}

					scope.pageEndCount = 0;
					scope.updatePageDisabled = false;
					scope.updatePage = function (directionId) {	// 1 pour down, -1 pour up
						// console.log("Update page");
						scope.updatePageDisabled = true;
						if(scope.nextPage){
							scope.nextPage(directionId);
						}
						$timeout(function(){
							scope.updatePageDisabled = false;
						}, 1000);
					}

					scope.viewMode = scope.PEEKLIST;
					scope.displayMails = [];

					scope.isPatientMessage = function(){
						return (scope.viewMail && scope.viewMail.courrielDest &&
							scope.viewMail.courrielDest.length > 0 &&
							scope.viewMail.courrielDest[0] && scope.viewMail.courrielDest[0].toIdPat)
					}
					var SENT = 4, UNREAD = 1;
					scope.canMoveToFolder = function(){
						return scope.folders && scope.folders.length > 0 && scope.model &&
							model.courriel().activeCourrielFolder !== SENT;
					}

					scope.markAsRead = function(){
						selectedAction(markAsRead);
					};
					scope.markAsUnRead = function(){
						selectedAction(markAsUnRead);
					};
					scope.archive = function(){
						selectedAction(archive);
					};
					scope.archiveAndClose = function(){
						selectedAction(archiveAndClose);
					};
					scope.unarchive = function(){
						selectedAction(unarchive);
					};
					scope.sendToFolder = function(f){
						selectedAction(function(ids){sendToFolder(ids, (f ? f.folder : undefined));});
					}

					function markAsRead(idsToSet){
						return CourrielAccessor.setRead({ids:idsToSet}, function(res){
							updateMsg(idsToSet, function(msg){
								updateAsRead(idsToSet)
								msg.currentDest.readDate = moment().valueOf();
							});
							model.courrielViewUpdate(true);
							model.refreshCountsUpdated(true);
						});
					}
					function markAsUnRead(idsToSet){
						CourrielAccessor.setUnread({ids:idsToSet}, function(res){
							updateMsg(idsToSet, function(msg){
								delete msg.currentDest.readDate;
							});
							updateAsUnRead(idsToSet)
							model.courrielViewUpdate(true);
							model.refreshCountsUpdated(true);
						});
					}

					function archiveAndClose(idsToSet){
						if(idsToSet.length == 1 && idsToSet[0] == scope.viewMail.currentDest.id){
							scope.closeMessage();
							archive(idsToSet);
						}
					}

					function archive(idsToSet){
						CourrielAccessor.setArchive({ids:idsToSet}, function(res){
							removeIds(idsToSet);
							if(model.courriel().activeCourrielFolder === CourrielAccessor.presetFolders.NEW){ 
								updateAsRead(idsToSet);
								model.refreshCountsUpdated(true);
							}
						});
					}
					function unarchive(idsToSet){
						CourrielAccessor.setUnarchive({ids:idsToSet}, function(res){
							removeIds(idsToSet);
						});
					}
					function sendToFolder(idsToSet, folder){
						CourrielAccessor.moveTo({ids:idsToSet, folder:folder}, function(res){
							removeIds(idsToSet);
						});
					}

					function updateMsg(idsToSet, fn){
						var obj = idsToSet.reduce(function(acc, o){acc[o] = true; return acc}, {});
						var ls = scope.displayMails.filter(function(e){
							return e.currentDest ? obj[e.currentDest.id] : undefined;
						});
						ls.forEach(fn);
					}

					function removeIds(idsToSet){
						var obj = idsToSet.reduce(function(acc, o){acc[o] = true; return acc}, {});
						var mailToShow;
						var cnt=0;
						var prevMailToShow;
						var isViewDetails = scope.viewMode === scope.PEEKDETAILS;
						scope.displayMails = scope.displayMails.filter(function(e){

							var ok = (e && e.currentDest) ? !obj[e.currentDest.id]: true;
							if (isViewDetails===true) {
								if (ok===false) {
									cnt++;
								}
								if (ok===true) {
									if (cnt===0) {
										prevMailToShow=e;
									} else if (!mailToShow) {
										mailToShow = e;
									}
								}
							}
							return ok;
						});
						if(scope.selectedList != undefined && scope.selectedList.ids != undefined && Object.keys(scope.selectedList.ids).length > 0){
							for (let i = 0; i < idsToSet.length; i++) {
								delete scope.selectedList.ids[idsToSet[i]];
							}
						}
						if (isViewDetails===true) {
							if (mailToShow) {
								scope.details(mailToShow);
							} else if (prevMailToShow) {
								scope.details(prevMailToShow);
							}
						}
					}

					function selectedAction(fn){
						var idsToSet = getSelectedids();
						if (idsToSet.length==0 && scope.viewMail && scope.viewMail.currentDest) {
							idsToSet.push(scope.viewMail.currentDest.id)
						}
						if (idsToSet.length>0) {
							fn(idsToSet);
						}
					}

					function getSelectedids(){
						var idsToSet = [];
						if(scope.selectedList != undefined && scope.selectedList.ids != undefined){
							var keys = Object.keys(scope.selectedList.ids);
							keys.forEach(function(e){
								if (scope.selectedList.ids[e]===true) {
									idsToSet.push(e);
								}
							});
						}
						return idsToSet;
					}

					scope.isUserAdmin = function(){
						return model.user().isUserAdmin===true;
					}
					scope.courrielUserIsSessionUser = function(){
						var cUser = model.currentCourrielUser();
						if(cUser){
							return cUser.personId === model.user().profil.idPerson;
						}else{
							return false;
						}
					}
					scope.details = function(msg){
						scope.responding = false;
						scope.viewMode = scope.PEEKDETAILS;
						model.courriel().currMail = scope.viewMail = msg;
						if(!scope.viewMail.vb){
							scope.viewMail.vb = {
								msgList:[scope.viewMail ]};
						}

						// console.log(msg);
						if(scope.readTimer ){
							$timeout.cancel(scope.readTimer);
							scope.readTimer = null;
						}
						if(msg.currentDest && msg.currentDest.idPerson === model.user().profil.idPerson && msg.currentDest && !msg.currentDest.readDate ){
							scope.readTimer = $timeout(function(){
								markAsRead([msg.currentDest.id]).then(function(res){
									scope.readTimer = null;
									msg.currentDest.readDate = moment().valueOf();
									updateAsRead([msg.currentDest.id]);
									model.refreshCountsUpdated(true);
									model.courrielViewUpdate(true);
								});
							}, 500);
						}
//						if (model.courriel().activeCourrielFolder===UNREAD && scope.viewMail.courrielDest.length>1) {
//						if (scope.viewMail.courrielDest.length>1) {
//							scope.responses();
//							scope.previous();
//						}

					};

					function updateAsRead(idsToUpdate){
						if (model.user().profil && model.dayData(model.user().profil.id)) {
							var c = model.dayData(model.user().profil.id).cnts;
							if(c !==undefined){
								idsToUpdate.forEach(function(mailId){
									mailId = mailId *1;
									var i = c.mail_new_id.indexOf(mailId)
									if(i > -1){
										c.mail_new_id.splice(i, 1);
										c.mail_new = c.mail_new - 1;
									}
								})
							}
						}
						return 0;
					}

					function updateAsUnRead(idsToUpdate){
						if (model.user().profil && model.dayData(model.user().profil.id)) {
							var c = model.dayData(model.user().profil.id).cnts;
							if(c !==undefined){
								idsToUpdate.forEach(function(mailId){
									mailId = mailId *1;
									var i = c.mail_new_id.indexOf(mailId)
									if(i === -1){
										c.mail_new_id.unshift(mailId);
										c.mail_new = c.mail_new +1;
									}
								});
							}
						}
						return 0;
					}

					function addLinksToMail(response) {
						response.patientdata = {};
						if (scope.viewMail.laboFile && scope.viewMail.laboFile.length>0) {
							scope.viewMail.laboFile.forEach(function(l){
								response.patientdata['labo_'+l.uid] = l;
							});
						}
						if (scope.viewMail.patientImage && scope.viewMail.patientImage.length>0) {
							scope.viewMail.patientImage.forEach(function(l){
								response.patientdata['doc_'+l.uid] = l;
							});
						}
						if (scope.viewMail.formData && scope.viewMail.formData.length>0) {
							scope.viewMail.formData.forEach(function(l){
								response.patientdata['form_'+l.uid] = l;
							});
						}
					}
					scope.initReplyToSender = function (toAll){
						if(!scope.viewMail.vb.response){
							scope.viewMail.vb.response = {
								// type: ChatAccessor.msgTypes[0],
								personTypeInt:model.user().isProf? 2:3,
								fromIdPerson: model.user().sessionUser.user.idPerson,
								courrielDest:[],
								patient: scope.viewMail.patient,
								idPatient: (scope.viewMail.patient ? scope.viewMail.patient.id : undefined),
								importance:1,
								viewbag: {
									// isTaskShortCut: false,
									// messageLink: MessageLink.getMessageLink(),
									courrielDest: []
								},
								modificationStatus: "STATUS_NEW"
							};
							if (toAll===true) {
								var activeIdPerson = model.user().sessionUser.user.idPerson;
								if (activeIdPerson!==scope.viewMail.fromIdPerson) {
									scope.viewMail.vb.response.courrielDest.push({idPerson: scope.viewMail.fromIdPerson, toNamePlus: scope.viewMail.fromNamePlus});
								}
								scope.viewMail.courrielDest.forEach(function(dest){
									if (activeIdPerson!==dest.idPerson) {
										scope.viewMail.vb.response.courrielDest.push({idPerson: dest.idPerson, toNamePlus: dest.toNamePlus});
									}
								});
							} else if (scope.folder !== 4){
								scope.viewMail.vb.response.courrielDest.push({idPerson: scope.viewMail.fromIdPerson, toNamePlus: scope.viewMail.fromNamePlus});
							} else {
								// ds le dossier des envoyés. je veux donc envoyer à nouveau
								scope.viewMail.courrielDest.forEach(function(dest){
									scope.viewMail.vb.response.courrielDest.push({idPerson: dest.idPerson, toNamePlus: dest.toNamePlus});
								});
							}
							scope.viewMail.vb.response.dataTitre = "RE: " + (scope.viewMail.dataTitre ? scope.viewMail.dataTitre : '');
							if(model.user().isProf){
								scope.viewMail.vb.response.fromIdProf = model.user().profil.id;
							}else{
								scope.viewMail.vb.response.fromIdEmpl = model.user().profil.id;
							}
						}
					}

					scope.initResendMessage = function (){
						if(!scope.viewMail.vb.response){
							scope.viewMail.vb.response = {
								// type: ChatAccessor.msgTypes[0],
								personTypeInt:model.user().isProf? 2:3,
								fromIdPerson: model.user().sessionUser.user.idPerson,
								patient: scope.viewMail.patient,
								idPatient: (scope.viewMail.patient ? scope.viewMail.patient.id : undefined),
								courrielDest:[],
								viewbag: {
									// isTaskShortCut: false,
									// messageLink: MessageLink.getMessageLink(),
									courrielDest: []
								},
								modificationStatus: "STATUS_NEW"
							};
							addLinksToMail(scope.viewMail.vb.response);
							scope.viewMail.vb.response.importance = scope.viewMail.importance;
							scope.viewMail.vb.response.dataTitre = scope.viewMail.dataTitre;
							scope.viewMail.vb.response.dataText = scope.viewMail.dataText;
							scope.viewMail.courrielDest.forEach(function(dest){
								scope.viewMail.vb.response.courrielDest.push({idPerson: dest.idPerson, toNamePlus: dest.toNamePlus});
							});
							if(model.user().isProf){
								scope.viewMail.vb.response.fromIdProf = model.user().profil.id;
							}else{
								scope.viewMail.vb.response.fromIdEmpl = model.user().profil.id;
							}
						}
					}

					scope.initForward = function (){
						if(!scope.viewMail.vb.response){
							scope.viewMail.vb.response = {
								// type: ChatAccessor.msgTypes[0],
								personTypeInt:model.user().isProf? 2:3,
								fromIdPerson: model.user().sessionUser.user.idPerson,
								patient: scope.viewMail.patient,
								idPatient: (scope.viewMail.patient ? scope.viewMail.patient.id : undefined),
								courrielDest:[],
								viewbag: {
									courrielDest: []
								},
								modificationStatus: "STATUS_NEW"
							};
							addLinksToMail(scope.viewMail.vb.response);
							scope.viewMail.vb.response.importance = scope.viewMail.importance;
							var toName = [];
							scope.viewMail.courrielDest.forEach(function(k){
								toName.push(k.toNamePlus);
							});
							var payload = { senderName: scope.viewMail.fromNamePlus, receiverName: toName.join('; '), date: scope.viewMail.date };
							scope.viewMail.vb.response.dataText = $filter("translate")("forwardingMsgHeader", payload) + scope.viewMail.dataText;
							scope.viewMail.vb.response.dataTitre = "FWD: " + (scope.viewMail.dataTitre ? scope.viewMail.dataTitre : '');
							if(model.user().isProf){
								scope.viewMail.vb.response.fromIdProf = model.user().profil.id;
							}else{
								scope.viewMail.vb.response.fromIdEmpl = model.user().profil.id;
							}
						}
					}

					scope.toTask = function (){
						var v = _.pick(scope.viewMail, ['dataText','dataTitre','idPatient','patientName','importance','patient','laboFile', 'patientImage','formData']);
						var toName;
						if (scope.viewMail.patient) {
							v.linkType = MessageLink.linkTypes.patient;
							v.presetPat = scope.viewMail.patient;
							v.idPatient = scope.viewMail.patient.id;
							v.idLink = scope.viewMail.patient.id;
						}
						var toName = [];
						if (scope.viewMail.courrielDest.length==1 && scope.viewMail.courrielDest[0].toIdPat) {
							toName.push("PAT: " + scope.viewMail.courrielDest[0].toNamePlus);
						} else {
							scope.viewMail.courrielDest.forEach(function(k){
								toName.push(k.toNamePlus);
							});
						}
						var payload = { senderName: scope.viewMail.fromNamePlus, receiverName: toName.join('; '), date: scope.viewMail.date };
						var note;
						if(v.dataTitre != undefined){
							note = v.dataTitre + "\n" + v.dataText;
						} else {
							note = v.dataText;
						}
						v.note = $filter("translate")("MsgToTaskHeader", payload) + note;
						
						TaskAccessor.openNew(v);
					};

					function sending(isSending){
						if(isSending){
							scope.sending = true;
						}else{
							$timeout(function(){
								scope.sending = false;
							}, 2000);
						}
					}
					scope.hasLink = function(msg){
						return (msg.laboFile && msg.laboFile.length > 0) ||
						(msg.patientImage && msg.patientImage.length > 0) ||
						(msg.formData && msg.formData.length > 0);
					}

					scope.removeDest = function(dest){
						var i = scope.viewMail.vb.response.courrielDest.indexOf(dest);
						if(i >= 0){
							scope.viewMail.vb.response.courrielDest.splice(i, 1);
						}
					}

					scope.responseHasLink = function(){
						return scope.viewMail.vb.response && scope.viewMail.vb.response.patientdata && !angular.equals(scope.viewMail.vb.response.patientdata, {});
					}
					var categoryToArrayMap = {'labo':'laboFile', 'doc':'patientImage','form':'formData'};
					function addAttachements(forSend){
						function addArray (k, el){
							if(!forSend[k]){
								forSend[k] = [];
								scope.viewMail.vb.response[k] = [];
							}
							if(k == "laboFile"){
								forSend[k].push({id: el.idText});
							}else{
								forSend[k].push({id:el.id});
							}
							scope.viewMail.vb.response[k].push(el);
						}
						if(forSend.patient){
							forSend.patient = {id: forSend.patient.id}
						}
						if(scope.viewMail.vb.response.patientdata){
							Object.keys(scope.viewMail.vb.response.patientdata).forEach(function(k){
								var categoryId = k.split("_");
								addArray(categoryToArrayMap[categoryId[0]], scope.viewMail.vb.response.patientdata[k])
							});
						}
					}

					//var copyFromResponse = ['patient', 'laboFile', 'patientImage', 'formData'];
					// not used. seems biz with msg added above Voir réponses et transferts.
					// can easily see the sent message by clicking the button
//					function addSentMessage(sent){
//						for (let i = 0; i < copyFromResponse.length; i++) {
//							var name = copyFromResponse[i];
//							if(scope.viewMail.vb.response && scope.viewMail.vb.response[name]){
//								sent[name] = scope.viewMail.vb.response[name]
//							}
//						}
//						// sent.patient = scope.viewMail.vb.response.patient;
//						// sent.laboFile = scope.viewMail.vb.response.laboFile;
//						// sent.patientImage = scope.viewMail.vb.response.patientImage;
//						// sent.formData = scope.viewMail.vb.response.formData;
//						scope.viewMail.vb.msgList.push(sent);
//					}

					scope.removeLink = function(key){
						delete scope.viewMail.vb.response.patientdata[key];
					}

					scope.removePatient = function(){
						delete scope.viewMail.vb.response.patient;
						delete scope.viewMail.vb.response.patientdata;
					}

					scope.responses = function(){
						var data = {id:scope.viewMail.id};
						CourrielAccessor.responses(data, function(res){
							//request successful
							scope.viewMail.vb.responses = res.data;
						}, function(){
							model.notice().fail($filter('translate')('MessageSentError'));
							//Unlock sending on error
						});
					}
					scope.previous = function(){
						var data = {id:scope.viewMail.id};
						CourrielAccessor.previous(data, function(res){
							//request successful
							scope.viewMail.vb.previous = res.data;
						}, function(){
							model.notice().fail($filter('translate')('MessageSentError'));
							//Unlock sending on error
						});
					};

					scope.reply = function(){
						var forSend = angular.copy(_.omit(scope.viewMail.vb.response, ['viewbag', 'patientdata']));

						//_uniqBy non dispo dans toutes les versions de undescore et ça chie
//						forSend.courrielDest = _.uniqBy(forSend.courrielDest, 'idPerson');
						forSend.courrielDest = _.uniq(forSend.courrielDest, false, 'idPerson');

//						if(forSend.courrielDest && forSend.courrielDest.length === 1
//							&& forSend.courrielDest[0].idPerson === scope.viewMail.fromIdPerson){
//						}
						// si on reply, on veut conserver le lien avec le message précédent indépendamment des destinataires mis ici
						forSend.idPrevCourrielTexte = scope.viewMail.id;
						addAttachements(forSend);
						if(!scope.sending && forSend.courrielDest[0].idPerson){
							sending(true);
							CourrielAccessor.save(forSend, function(res){
								//Message was sent successfully
								model.notice().success($filter('translate')('MessageSentSuccessfully'));
								// addSentMessage(forSend);
								delete scope.viewMail.vb.response;
								if(scope.closeQe){
									scope.closeQe(scope.activeEditor);
								}
								//Prevent double sending when clicking too fast;
								sending();
							}, function(){
								model.notice().fail($filter('translate')('MessageSentError'));
								//Unlock sending on error
								sending();
							});
						}else if(!forSend.courrielDest || !forSend.courrielDest[0].idPerson){
							model.notice().fail($filter('translate')('MessageSentNoDest'));
						}
					}

					scope.patientLinkSearch = {
						patientSearch: {
							onSelect:function(pat){
								scope.viewMail.vb.response.patient = pat;

								if(scope.patientLinkSearch.hide){
									scope.patientLinkSearch.hide();
								}
							},
							options:{
							}
						},
						onOpen: function(hideFn){
							scope.patientLinkSearch.hide = hideFn;
							$timeout(function(){
								if(scope.patientLinkSearch.patientSearch.focus){
									scope.patientLinkSearch.patientSearch.focus();
								}
							}, 100)
						}
					}

					scope.closeMessage = function(){
						scope.viewMode = scope.PEEKLIST;
						clearCurrMail();
					}

					function clearCurrMail(){
						delete scope.viewMail;
						delete model.courriel().currMail;
					}
					scope.sendAgain = function(){
						scope.responding = true;
						if (scope.viewMail.vb.response) delete scope.viewMail.vb.response;
						scope.initResendMessage();
						if(scope.vb.focusReplyField){
							scope.vb.focusReplyField();
						}
					}
					scope.respond = function(toAll){
						scope.responding = true;
						if (scope.viewMail.vb.response) delete scope.viewMail.vb.response;
						scope.initReplyToSender(toAll);
						if(scope.vb.focusReplyField){
							scope.vb.focusReplyField();
						}
					}
					scope.forward = function(){
						scope.responding = true;
						if (scope.viewMail.vb.response) delete scope.viewMail.vb.response;
						scope.initForward();
						if(scope.vb.focusReplyField){
							scope.vb.focusReplyField();
						}
					}

					function update(){
						scope.clearSelection();
						if(scope.courriels){
							updateDataSourceByIds(scope.courriels);
						}
					}

					function updateViewer(){
						if (scope.inputCourriel) {
							scope.displayMails = [];
							scope.viewMail = scope.inputCourriel;
							scope.displayMails.push(scope.inputCourriel);
							if(!scope.viewMail.vb){
								scope.viewMail.vb = {
										msgList:[scope.viewMail ]};
							}
							scope.viewMode = scope.MAILDETAILS;
							scope.linkManager = MessageLink.linkManager(CourrielAccessor, scope.quickViewData.pat, scope.viewMail.uid, scope)
						}
					}

					function updateDataSourceByIds(ids) {
						// scope.viewMode = scope.PEEKLIST;
						if (ids === undefined) {
							return;
						}

						if (ids.length === 0) {
							scope.displayMails.length = 0;
							return;
						}

						scope.displayMails = [];
						pagination.length=0;
						if(ids.length > PAGESIZE){
							var chuncks = Math.ceil(ids.length/ PAGESIZE);
							for(var i = 0; i < chuncks; i++){
								var indexStart = i*PAGESIZE;
								pagination.push(ids.slice(indexStart, indexStart+PAGESIZE));
							}
							activePage = 0;
							getCourrielList({ids: pagination[activePage]}, scope.folder);
						}else{
							getCourrielList({ ids: ids }, scope.folder);
						}
					}

					function addToDisplayMails(lst){
						$.merge(scope.displayMails, lst);
						model.courrielViewUpdate(true);
					}

					function initCourriels(courriels){
						// console.log(model.currentCourrielUser());
						var cUserIdPerson = model.currentCourrielUser().personId;
						courriels.forEach(function(e){
							e.currentDest = e.courrielDest.find(function(dest){
								return cUserIdPerson === dest.idPerson;
							});
						})
						// console.log(courriels);
						return courriels;
					}

					function getCourrielList(criteria, folder){
						scope.loading = true;
						var str;
						var canCacheCriteria = criteria.ids && criteria.ids.length > 0 && Object.keys(criteria).length === 1;
						if(canCacheCriteria){
							str = criteria.ids.toString();
							var lstCache = model.mailCached(str);
							if (lstCache!==undefined) {
								return $q(function(resolve, reject){
									addToDisplayMails(lstCache)
									scope.loading = false;
									resolve();
								});
							}
						}
						return CourrielAccessor.find(criteria, function success(response) {
							var validResponse = response && response.data && Array.isArray(response.data);
							if(validResponse){
								var resp = initCourriels(response.data);
								if(canCacheCriteria){
									model.mailCached(str, resp);
								}
								if(folder === scope.folder){

									if (response.data.length > 0) {
										addToDisplayMails(resp);
										// $.merge(scope.displayMails, initCourriels(response.data));
										// model.courrielViewUpdate(true);
									}
								}
							}
							scope.loading = false;
						}, function fail(res) {
							scope.loading = false;
						});
					}

					scope.isOkToSend = function (){
						var rep = scope.viewMail.vb.response;
						return rep && rep.courrielDest && rep.courrielDest.length > 0 && rep.dataText;
					};

					scope.$watch(function(){ return scope.courriels;}, update);
					scope.$watch(function(){ return scope.inputCourriel;}, updateViewer);

					//Methodes exposé pour les scopes parents.
					var api = {
						closeCurrentMessage: scope.closeMessage,
						setAsCurrent: scope.details,
					};

					if(scope.options && scope.options.onOpen){
						scope.options.onOpen(api)
					}
				}
			};
		}
	]);


	courriel.directive('courrielFolderListItem', ['CourrielAccessor','model','$timeout',
		function (CourrielAccessor, model, $timeout) {
			return {
				restrict: 'A',
				link: function (scope, element, attrs) {
					scope.model = model;
					scope.hovered = false;
					scope.viewbag = {selectedSendToFolder: 3};

					scope.deleteItem = function(){
						// console.log("delete : "+ scope.f.folder);
						scope.f.idUser = model.user().sessionUser.user.id;
						scope.f.name = "";
						scope.f.sendContentTo = scope.viewbag.selectedSendToFolder;
						doRemove();
					}
					function doRemove(){
						CourrielAccessor.nameFolder(scope.f, function(response){
							// console.log(response);
							if(response && response.data && !response.data.success){
								model.notice().fail("La suppression de la boîte a échoué.");
							}else{
								var ids = {}; ids[scope.f.folder+''] = [];
								model.courriel().setFolders(ids);
								scope.removeFolder(scope.f);
								scope.updateActiveFolder(1);
							}
						});
					}

					function focusIfEdit(){
						if(scope.f.editMode){
							$timeout(function(){
								scope.f.folderNameFocus && scope.f.folderNameFocus()
							}, 100)
						}
					}
					scope.$watch(scope.f.editMode, focusIfEdit)
				}
			};
		}
	]);

	courriel.directive('courrielPeekListItem', [
		function () {
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/courriel/courriel_peek_list_item.html?v=bk',
				link: function (scope, element, attrs) {
				}
			};
		}
	]);


	courriel.directive('courrielPeekListCard', [
		function () {
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/courriel/courriel_peek_list_card.html?v=bk',
				link: function (scope, element, attrs) {
				}
			};
		}
	]);


	courriel.directive('courrielCreate', ['model','CourrielAccessor', '$filter', 'UserAccessor','ProfAccessor', '$q','MessageLink','$timeout','utils','$rootScope','hotkeys','PatientUtils', 'PatientAccessor','AppointmentAccessor',
	                           function(model, CourrielAccessor, $filter, UserAccessor,ProfAccessor, $q, MessageLink, $timeout,utils,$rootScope, hotkeys, PatientUtils, PatientAccessor, AppointmentAccessor){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/courriel/courriel_create.html?v=bk',
			scope: true,
			link: function(scope, element, attrs){
				var ALLPROFTYPES = [];
				UserAccessor.getAllProfTypes(function(res){
					ALLPROFTYPES = res;
				});

				var ALLEMPLOYEETYPES = [];
				UserAccessor.getAllEmployeeTypes(function(res){
					ALLEMPLOYEETYPES = res;
				});

				scope.vb = {};
				var linkName = {"lab":"laboFile",'labo':'laboFile', "doc":"patientImage", "form":"formData", "formCNESST":"formData", "formCRDS":"formData"}
				hotkeys.add({
					combo: 'ctrl+enter',
					description: 'Envoyer le message',
					callback: function() {
						if(scope.isOkToSend()){
							scope.send();
						}
					}
				});

				scope.patientDestSearch = {
					patientSearch: {
						onSelect:function(pat){
							// scope.qe.message.patient = pat;
							scope.removePatient();
							setPatient(pat);
							if(scope.patientDestSearch.hide){
								scope.patientDestSearch.hide();
							}
						},
						options:{
						}
					},
					onOpen: function(hideFn){
						scope.patientDestSearch.hide = hideFn
						$timeout(function(){
							if(scope.patientDestSearch.patientSearch.focus){
								scope.patientDestSearch.patientSearch.focus();
							}
						}, 100);
					}
				}

				function linkPatient(pat){
					scope.qe.message.patient = pat;
					scope.patient = pat;	// besoin d'être setté pour liste
				}

				scope.patientLinkSearch = {
					patientSearch: {
						onSelect:function(pat){
							linkPatient(pat)
							if(scope.patientLinkSearch.hide){
								scope.patientLinkSearch.hide();
							}
						},
						options:{
						}
					},onOpen: function(hideFn){
						scope.patientLinkSearch.hide = hideFn
						$timeout(function(){
							if(scope.patientLinkSearch.patientSearch.focus){
								scope.patientLinkSearch.patientSearch.focus();
							}
						}, 100)
					}
				}

				function getSofypatientContact(patient){
					if(patient){
						if(patient.lstContactInformation){
							for (var i = 0; i < patient.lstContactInformation.length; i++) {
								var contact = patient.lstContactInformation[i];
								if(contact.typeContact === 1 ){
									patient.email = contact;
								} else if(contact.typeContact === 4){
									patient.emailAutre = contact;
								}
							}
							patient.hasAnEmail = hasEmail(patient);
							patient.useContact = getContact(patient);
						}else{
							patient.hasAnEmail = false;
						}
					}
				}
				function hasEmail(t){
					return !!(t.email || t.emailAutre);
				}
				function hasContact(t){
					if (t.email) return t.email;
					if (t.emailAutre) return t.emailAutre;
					return;
				}
				function getContact(t){
					if(hasContact(t)){
						if(t.email ) return t.email;
						if(t.emailAutre) return t.emailAutre;
					}
				}
				scope.getUserName = function(usr){
					return PatientUtils.getPatientIdString(usr);
				}

				scope.setMsgType = function(type){
					if(scope.qe.type === "TO_PATIENT" &&
						type == "TO_COLLEAGUE"){
						initToCollegue();
					}else if(scope.qe.type === "TO_COLLEAGUE" &&
						type === "TO_PATIENT"){
						initToPatient();
					}
					scope.qe.type = type;
				}

				function initToCollegue(){
					scope.removeAllRecipient();
					//if patient as recipient set patient as attachement.
					if(scope.qe.message.currentPatient){
						linkPatient(scope.qe.message.currentPatient);
						delete scope.qe.message.currentPatient;
					}
				}

				function initToPatient(){
					//Clear recipient list.
					//if patient as attachement set patient as recipient.
					if(scope.qe.message.patient){
						setPatient(scope.qe.message.patient);
						delete scope.qe.message.patient;
					}else{
						scope.removeAllRecipient();
					}

				}

				scope.focusMessageFn = function(){
					$timeout(function(){
						scope.focusWriteMessage();
					},0);
				};

				scope.focusRecipientMessage = function(){
					$timeout(function(){
						if(scope.vb.focusMessageRecipientInput){
							scope.vb.focusMessageRecipientInput();
						}else if(scope.focusMessageRecipientPatientInput){
							scope.focusMessageRecipientPatientInput();
						}
					},600);
				};

				function init(){
					if(scope.qe && !scope.qe.init){
						scope.qe.init = true;
						if(!scope.qe.type){
							scope.qe.type = "TO_COLLEAGUE";
						}
						var def = {
								// type: ChatAccessor.msgTypes[0],
								personTypeInt:model.user().isProf? 2:3,
								fromIdPerson: model.user().sessionUser.user.idPerson,
								importance:1,
								viewbag: {
									isTaskShortCut: false,
									messageLink: MessageLink.getMessageLink(),
									courrielDest: []
								},
								idLink: [],
								idLinkType: [],
								courrielDest: [],
								modificationStatus: "STATUS_NEW"
						};

						if(model.user().isProf){
							def.fromIdProf = model.user().profil.id;
						}else{
							def.fromIdEmpl = model.user().profil.id;
						}

						if(!scope.qe.message || scope.qe.parseMessage===false){
							scope.qe.message = def ;
							addLink();
						}else if(scope.qe.parseMessage){
							delete scope.qe.parseMessage;
							scope.qe.message = $.extend(def, scope.qe.message);
							scope.qe.message.idLinkType = scope.qe.message.linkType;
							if(scope.qe.message.idLinkType !== undefined){
								delete scope.qe.message.viewbag.messageLink;
								scope.qe.message.viewbag.messageLink = {
									id: scope.qe.message.idLink,
									linkType: scope.qe.message.idLinkType,
									patient: scope.qe.message.idPatient,
									pat: scope.qe.message.patient,
									doc: scope.qe.message.patientImage,
									lab: scope.qe.message.laboFile,
									form: scope.qe.message.formData,
								}
							}
							if(scope.qe.message.presetPat){
								setPatient(scope.qe.message.presetPat);
								delete scope.qe.message.presetPat;
							}
						}
						scope.focusRecipientMessage();
					}
				}

				scope.setMessageLink = function(){
					addLink();
				};

				scope.isOkToSend = function (){
					if(scope && scope.qe && scope.qe.message && scope.qe.message.viewbag){
						scope.qe.message.viewbag.okToSend = !!(
							(
								(scope.qe.message.viewbag && scope.qe.message.viewbag.courrielDest && scope.qe.message.viewbag.courrielDest.length > 0) ||
								scope.qe.message.toEmployeeType ||
								scope.qe.message.toProfessionnalType ||
								scope.qe.message.toAllUser
							)&& scope.qe.message.dataText
						);
					}
				};

				scope.actOptions = {verbose: true};

				function addLink(){
					scope.qe.message.viewbag.messageLink = MessageLink.getMessageLink();
					if(scope.qe.message.viewbag.messageLink ){
						if(scope.qe.message.viewbag.messageLink.linkType === MessageLink.linkTypes.patient){
							scope.qe.message.patient = scope.qe.message.viewbag.messageLink.pat;
						}else{
							if (scope.qe.message.viewbag.messageLink.linkType === MessageLink.linkTypes.doc){
								scope.qe.message.patient = scope.qe.message.viewbag.messageLink.doc.patient;
							} else if (scope.qe.message.viewbag.messageLink.linkType === MessageLink.linkTypes.labo){
								scope.qe.message.patient = scope.qe.message.viewbag.messageLink.lab.patient;
							} else if (scope.qe.message.viewbag.messageLink.linkType === MessageLink.linkTypes.form){
								scope.qe.message.patient = scope.qe.message.viewbag.messageLink.form.patient;
							} else if (model.patient() && model.patient().currPatient) {
								scope.qe.message.patient = model.patient().currPatient;
							}
							Object.keys(linkName).forEach(function(link){
								if(scope.qe.message.viewbag.messageLink[link]){
									if(!scope.qe.message.patientdata){
										scope.qe.message.patientdata = {};
									}
									scope.qe.message.patientdata[link+"_"+scope.qe.message.viewbag.messageLink[link].id] = scope.qe.message.viewbag.messageLink[link];
								}
							})
						}
							// scope.qe.message.idLinkType = MessageLink.linkTypesArray.indexOf(scope.qe.message.viewbag.messageLink.linkType);
							// scope.qe.message.idLink = scope.qe.message.viewbag.messageLink.id;
							// scope.qe.message.idPatient = scope.qe.message.viewbag.messageLink.patient;
							// scope.focusMessageFn();

					}
				}

				scope.responseHasLink = function(){
					return scope.qe.message && scope.qe.message.patientdata && !angular.equals(scope.qe.message.patientdata, {});
				}

				scope.getType = function(act){
					if ('CLaboFile'===act.className || 'CLaboResultsProfessionnal'===act.className) {
						return "lab";
					}else if(act.className === "CBasePatientImage" || act.className === "CPatientImage"){
						return "doc"
					}else if(act.className === "CFormData"){
						return "form"
					}
				}

				scope.removeLink = function(key){
					delete scope.qe.message.patientdata[key];
				}

				scope.removePatient = function(){
					delete scope.qe.message.patient;
					delete scope.qe.message.patientdata;
				}

				scope.toAllUserToggle = function(){
					// setToAllUserState(!scope.qe.message.toAllUser);
					scope.userSearchable.forEach(function(user){
						setUser(user);
					})
					scope.isOkToSend();
				};

				scope.removeAllRecipient = function(){
					scope.qe.message.viewbag.courrielDest = [];
					scope.qe.message.viewbag.cc = [];
					scope.isOkToSend();
				};

				function setToAllUserState(state){
					scope.qe.message.toAllUser = state;
					if(state){
						clearToUser();
						scope.setEmployeeGroup();
						scope.setProfGroup();
						scope.qe.message.viewbag.isTaskShortCut && setIsTaskState(false);
						scope.focusMessageFn();
					}
				}

				scope.removeToUser = function (user){
					clearToUser(user);
					if(user.className == 'CPatient'){
						scope.qe.message.viewbag.cc = [];
					}
					scope.qe.message.viewbag.isTaskShortCut && setIsTaskState(false);
					scope.isOkToSend();
				};

				function clearToUser(user){
					if(user){
						var viewIndex = scope.qe.message.viewbag.courrielDest.indexOf(user);
						if(viewIndex > -1){
							scope.qe.message.viewbag.courrielDest.splice(viewIndex,1);
						}
					}
				}
				scope.setEmployeeGroup = function(groupEmployee){
					if(groupEmployee){
						var groupEmployeeInt = ALLEMPLOYEETYPES[groupEmployee].value;

						scope.userSearchable.filter(function(user){
							return user.employeeTypeInt === groupEmployeeInt;
						}).forEach(function(user){
							setUser(user);
						});
					}
					scope.isOkToSend();
				};

				scope.setProfGroup = function(profGroup){
					if(profGroup){
						var profGroupInt = ALLPROFTYPES[profGroup].value;
						scope.userSearchable.filter(function(user){
							return user.professionnalTypeInt === profGroupInt;
						}).forEach(function(user){
							setUser(user);
						});
						// scope.qe.message.toProfessionnalType = profGroup;
						// scope.qe.message.toAllUser && setToAllUserState(false);
						// scope.qe.message.viewbag.isTaskShortCut && setIsTaskState(false);
					}
					scope.isOkToSend();
				};

				var initialList;	// une liste réinitialisée quand on select
				function searchUsers(query){
					var res;
					if (initialList==undefined) {
						initialList = filterUserSearchableByWorkSite()
					}
					if(query){
						var q = query.toLowerCase().removeAccentsLc();
						res = [];
						for (var i = 0; i < initialList.length; i++) {
							elem = initialList[i];
							if ((elem.personNameLc && elem.personNameLc.indexOf(q) > -1) ||
									(elem.nameLc && elem.nameLc.indexOf(q) > -1)) {
								res.push(elem);
							}
						}
					}else{
						res = initialList;
					}
					return res;
				}

				function getCurrentUser(){
					var query = {userId:model.user().sessionUser.id};
					var res = $filter('filter')(scope.userSearchable, query );
					return res[0];
				}

				function filterUserSearchableByWorkSite(){
					var res = scope.recepientSearchable;
					if(model.prefSettings('user_settings_SiteMessages')){
						var workSiteId = model.user().session.workSite.id;
						res = res.filter(function(e){
							if(e && e.sessionSite && e.sessionSite.id){
								if(e.sessionSite.id === workSiteId){
									return true;
								}
								return false;
							}else{
								// if the user does not have a session site.. always display
								return true;
							}
						});
					}
					return res;
				}
				var recipientSearchItemHtml;
				utils.getTemplate('/dashboard/resources/ofys/user/user_dataItem.html', function(html){
					recipientSearchItemHtml = html;
				});

				scope.recipientSearchAssist = {
					assistId: "autocomplete_msgRecipients",
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					minChar: 0,
					trigger: 'focus',
					// updateDataSourceWithValues: function(assistObject){
					// 	if(scope.userSearchable){
					// 		assistObject.setData(filterUserSearchableByWorkSite());
					// 	}
					// },
					getAsyncData: function(query, assist){
						return $q(function(resolve, reject) {
							resolve(searchUsers(query));
						});
					},
					getKey: function(recipient) {
						var newScope = $rootScope.$new();
						newScope.item = recipient;
						var res =  utils.compile(newScope, recipientSearchItemHtml);
						$timeout(function(){
							if(!newScope.$$phase) {
								newScope.$digest();
							}
						}, 0);
						return res;
					},
					selection: function(recipient, assistObject) {
						scope.qe.message.viewbag.isTaskShortCut && setIsTaskState(false);
						scope.$apply(setOrGroupUser(recipient));
						initialList = undefined;
						return "";
					},
				};

				scope.patientDataSelector = {
					activeCategories: ['labo', 'doc', 'form', 'formCRDS', 'formCNESST'],
					getPatient: function(){
						if(scope.qe.message.patient){
							return scope.qe.message.patient;
						}else if(scope.qe.message.currentPatient){
							return scope.qe.message.currentPatient;
						}
					},
					saveSelection:function(selection){
						if(!scope.qe.message.patientdata){
							scope.qe.message.patientdata  = {}
						}
						$.extend(scope.qe.message.patientdata, selection);
					},
					onOpen: function(hideFn){
						scope.patientDataSelector.hide = hideFn;
					}
				}

				function setOrGroupUser(recipient){
					if(recipient.className == "CUserForSelection"){
						setUser(recipient)
					}else if(recipient.className == "CPersonGroup"){
						recipient.persons.forEach(function(baseUser){
							baseUser.personId = baseUser.idPerson;
							setUser(baseUser);
						});
					}
				}

				function setUser(recipient){
					if(scope.qe.message.viewbag.courrielDest.indexOf(recipient)>-1){
						return;
					}
					AppointmentAccessor.utils.isAbsentToday(recipient);
					scope.qe.message.toAllUser && setToAllUserState(false);
					scope.qe.message.viewbag.courrielDest.push(recipient);
					scope.isOkToSend();
					scope.focusMessageFn();
				}

				function setPatient(recipient){
					if(scope.qe.message.viewbag.courrielDest.indexOf(recipient)>-1){
						return;
					}
					scope.removeAllRecipient();// juste un patient à la fois.
					getSofypatientContact(recipient);
					scope.qe.message.toAllUser && setToAllUserState(false);
					scope.qe.message.viewbag.courrielDest.push(recipient);
					if(scope.qe.message.viewbag.courrielDest.length == 1){
						scope.qe.message.currentPatient = recipient;
						recipient.toIdPat = recipient.id;	// le id_patient_anchor
					}else if(scope.qe.message.currentPatient){
						delete scope.qe.message.currentPatient;
						delete scope.qe.message.patientdata;
					}
					PatientAccessor.getPatientsWithSofyAccess(recipient).then(function(cclist){
						cclist.forEach(function(cc){
							getSofypatientContact(cc);
						})
						scope.qe.message.viewbag.cc = cclist;
					});
					scope.isOkToSend();
					scope.focusMessageFn();
				}

				ProfAccessor.profTypesInUse(function(res){
					scope.profsInUse = res.data;
					// console.log(scope.profsInUse);
				});

				UserAccessor.employeeTypesInUse(function(res){
					scope.groupEmployees = res.data;
					// console.log(scope.groupEmployees);
				});

				if(!scope.recepientSearchable){
					UserAccessor.listUsersForSelection(function(res){
						scope.userSearchable = UserAccessor.cleanAndSortUsers(res.data);
						var grps = $filter('orderBy')(OfysUtils.ObjectValuesAsArray(model.user().groups), 'name');
						scope.recepientSearchable = grps.concat(scope.userSearchable);

						// console.log(scope.recepientSearchable);
					});
				}

				// scope.msgTypes = ChatAccessor.msgTypes;

				function sending(isSending){
					if(isSending){
						scope.sending = true;
					}else{
						$timeout(function(){
							scope.sending = false;
						}, 2000);
					}
				}

				function addAttachements(forSend){
					function addArray (k, el){
						if(!forSend[k]){
							forSend[k] = [];
						}
						if(k == "laboFile"){
							forSend[k].push({id: el.idText});
						}else{
							forSend[k].push({id:el.id});
						}
					}
					if(forSend.patient){
						forSend.patient = {id: forSend.patient.id}
					}
					if(scope.qe.message.patientdata){
						Object.keys(scope.qe.message.patientdata).forEach(function(k){
							var categoryId = k.split("_");
							addArray(linkName[categoryId[0]], scope.qe.message.patientdata[k])
						});
					}
				}

				scope.send = function(){
					var forSend = angular.copy(_.omit(scope.qe.message, ['viewbag', 'patientdata','currentPatient']));

					//_uniqBy non dispo dans toutes les versions de undescore et ça chie
//					forSend.courrielDest = _.uniqBy(scope.qe.message.viewbag.courrielDest.map(function(e){
//						if(e.personId){
//							return {idPerson: e.personId};
//						}else if(e.idPerson){
//							return {idPerson: e.idPerson};
//						}
//					}), 'idPerson');
					forSend.courrielDest = _.uniq(scope.qe.message.viewbag.courrielDest.map(function(e){
						var data = {};
						if(e.personId){
							data.idPerson = e.personId;
						}else if(e.idPerson){
							data.idPerson = e.idPerson;
						}
						if (e.toIdPat) {
							data.toIdPat = e.toIdPat;
						} else if (e.idPatient) {
							// on a un destinataire avec un idPatient.. on a donc perdu le toIdPat qq part. Je le remets
							data.toIdPat = e.id;	// le anchor
						}
						return data;
					}), false, 'idPerson');

					addAttachements(forSend);
					// $log.log(forSend);
					// return;
					if(!scope.sending){
						sending(true);
						CourrielAccessor.save(forSend, function(res){
							//Message was sent successfully
							model.notice().success($filter('translate')('MessageSentSuccessfully'));
							if(scope.closeQe){
								scope.closeQe(scope.activeEditor);
							}

							//Prevent double sending when clicking too fast;
							sending();
						}, function(){
							model.notice().fail($filter('translate')('MessageSentError'));
							//Unlock sending on error
							sending();
						});
					}
				}
				//Correctif temporaire, je ne suis pas certain que c'est la bonne façon de procéder, c'est fonctionnel toutefois...
				scope.$watch(function(){
					return scope.qe.message.currentPatient? scope.qe.message.currentPatient.hasAnEmail : false;
				}, function(){
					if(scope.qe.message.currentPatient && scope.qe.message.currentPatient.hasAnEmail === undefined){
						getSofypatientContact(scope.qe.message.currentPatient);
					}
				})

				scope.$watch(function(){
					return scope.qe;
				}, init);
			}
		}
	}]);
})();