/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.rxdrugref.impl;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;

public class TimingOutCallback
implements AsyncCallback {
    private static final Logger logger = Logger.getLogger(TimeoutException.class.getName());
    private final long timeout;
    public Object result;
    private Throwable error;
    private boolean responseSeen;

    public TimingOutCallback(long pTimeout) {
        this.timeout = pTimeout;
    }

    public synchronized Object waitForResponse() throws Throwable {
        if (!this.responseSeen) {
            this.wait(this.timeout);
            if (!this.responseSeen) {
                throw new TimeoutException(0, "No response after waiting for " + this.timeout + " milliseconds.");
            }
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.result;
    }

    public synchronized void handleError(XmlRpcRequest pRequest, Throwable pError) {
        this.responseSeen = true;
        this.error = pError;
        this.notify();
    }

    public synchronized void handleResult(XmlRpcRequest pRequest, Object pResult) {
        this.responseSeen = true;
        this.result = pResult;
        this.notify();
    }

    public synchronized void handleResult(Object arg0, URL arg1, String arg2) {
        this.responseSeen = true;
        logger.fine("arg2" + arg2);
        this.result = arg0;
        this.notify();
    }

    public synchronized void handleError(Exception e, URL url, String method) {
        this.responseSeen = true;
        logger.log(Level.WARNING, "Error in url=" + url + ", method=" + method, e);
        this.error = e;
        this.notify();
    }

    public static class TimeoutException
    extends XmlRpcException {
        private static final long serialVersionUID = 4875266372372105081L;

        public TimeoutException(int pCode, String message) {
            super(pCode, message);
        }
    }
}

