/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.LightweightReport;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecallListIdContainer;
import ca.infodata.ofys.data.middle.dataobjects.properties.BooleanProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.IReportProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.IntegerProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.LocalDateProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.StringProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.TimeProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.Orientation;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.WithBarCodeProperty;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledRessource;
import ca.infodata.ofys.ui.dashboard.models.CBilledRessource;
import ca.infodata.ofys.ui.dashboard.models.CReportProperty;
import ca.infodata.ofys.ui.dashboard.models.CReportQuery;
import ca.infodata.util1.Pair;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

public class CFinishedReportQuery {
    public CReportQuery report;
    public Integer id;
    public String type;
    public Long date;
    public List<Integer> ids;
    public CBilledRessource[] billed;

    public CFinishedReportQuery(CReportQuery report, Integer id) {
        this.report = report;
        this.id = id;
    }

    public CFinishedReportQuery() {
    }

    public Serializable getDataObject() {
        if (this.type.equals("patient")) {
            return new IDDataObject(this.id, XPatient.class, "print");
        }
        if (this.type.equalsIgnoreCase("appointment")) {
            return new IDDataObject(this.id, XAppointment.class, "print");
        }
        if (this.type.equalsIgnoreCase("appointmentdate")) {
            return Pair.newPair((Object)this.id, (Object)LocalDate.fromTimeInMillisUTC((Long)this.date));
        }
        if (this.type.equalsIgnoreCase("patientrecall")) {
            return new XPatientRecallListIdContainer(this.ids, XPatientRecallListIdContainer.class, "print");
        }
        if (this.type.equalsIgnoreCase("billedRessource")) {
            HashSet<XBilledRessource> xbilledList = new HashSet<XBilledRessource>(this.billed.length);
            for (CBilledRessource billed : this.billed) {
                xbilledList.add(billed.convertx());
            }
            return xbilledList;
        }
        return null;
    }

    public LightweightReport getIReport() {
        LightweightReport lightweightReport = new LightweightReport(this.report.getId(), this.report.getName(), this.report.getPrintMode());
        for (Map.Entry<String, CReportProperty> entry : this.report.getProperties().entrySet()) {
            if (entry.getValue().getType().equalsIgnoreCase("orientation")) {
                lightweightReport.getProperties().put(entry.getKey(), (Serializable)Orientation.valueOf((String)entry.getValue().getValue()));
                continue;
            }
            if (entry.getValue().getType().equalsIgnoreCase("LocalDateProperty")) {
                lightweightReport.getProperties().put((IReportProperty)new LocalDateProperty("date", "Pr\u00e9ciser/Enter Date", LocalDate.fromTimeInMillisUTC((Long)NumberUtils.toLong((String)entry.getValue().getValue()))));
                continue;
            }
            if (entry.getValue().getType().equalsIgnoreCase("TimeProperty")) {
                lightweightReport.getProperties().put((IReportProperty)new TimeProperty("hour", "Pr\u00e9ciser Heure/Enter time", NumberUtils.createInteger((String)entry.getValue().getValue())));
                continue;
            }
            if (entry.getValue().getType().equalsIgnoreCase("BooleanProperty")) {
                lightweightReport.getProperties().put((IReportProperty)new BooleanProperty(entry.getKey(), Boolean.valueOf(entry.getValue().getValue())));
                continue;
            }
            if (entry.getValue().getType().equalsIgnoreCase("WithBarCodeProperty")) {
                lightweightReport.getProperties().put((IReportProperty)new WithBarCodeProperty(Boolean.valueOf(entry.getValue().getValue())));
                continue;
            }
            if (entry.getValue().getType().equalsIgnoreCase("IntegerProperty")) {
                lightweightReport.getProperties().put((IReportProperty)new IntegerProperty(entry.getKey(), NumberUtils.createInteger((String)entry.getValue().getValue())));
                continue;
            }
            lightweightReport.getProperties().put((IReportProperty)new StringProperty(entry.getKey(), entry.getValue().getValue()));
        }
        return lightweightReport;
    }
}

