/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import ca.infodata.ofys.data.dataaccess.IConnectionInfoProvider;
import ca.infodata.ofys.data.dataaccess.IPatientAccessor;
import ca.infodata.ofys.data.dataaccess.ISessionProvider;
import ca.infodata.ofys.data.dataaccess.XFindPatientSummaryCriteria;
import ca.infodata.ofys.data.dataaccess.impl.BaseAccessor;
import ca.infodata.ofys.data.dataaccess.impl.RestfulClient;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilder;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilderWithSession;
import ca.infodata.ofys.data.middle.dataobjects.PatientFlag;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.search.Group;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class PatientAccessor
extends BaseAccessor
implements IPatientAccessor {
    private static final Logger logger = Logger.getLogger(PatientAccessor.class.getName());

    private static String getPath() {
        return "/" + contextRoot + "/jaxrs/PatientAccessor";
    }

    public PatientAccessor(RestfulClient restfulClient, IConnectionInfoProvider connectionInfoProvider, ISessionProvider sessionProvider) {
        super(restfulClient, connectionInfoProvider, sessionProvider);
    }

    @Override
    public ReturnObject delete(IDataObject dataObject, boolean askQuestion) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/delete"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("dataObject", this.serialize((Serializable)dataObject));
        post.put("askQuestion", askQuestion);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findLastUsed() {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/findLastUsed"), "application/octet-stream", "application/json");
        HashMap post = new HashMap();
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getPatientFlag(Integer idPatient) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/getPatientFlags"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idPatient);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findPatientIdentifiers(Integer idPatient) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/findPatientIdentifiers"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idPatient);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getPatientFlagDetail(Integer idPatient, PatientFlag flag) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/getPatientFlagDetail"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idPatient);
        post.put("flagValue", this.value(flag));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findMostUsed() {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/findMostUsed"), "application/octet-stream", "application/json");
        HashMap post = new HashMap();
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findPatientDependents(Integer idPatient) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/findPatientDependents"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idPatient);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findPatient(boolean no_limit, String nameDossier, String noDossierHopital, String nam, String[] dateDernActivite, String noTelephone, String[] dateRapp, String note, boolean inObjectUsage, Integer idProfessionnal, Integer idIntervenant, boolean rdvsToMove, List<XSite> sites, boolean returnOneOrNull, Boolean deleted) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/findPatient"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("no_limit", no_limit);
        post.put("nameDossier", nameDossier);
        post.put("noDossierHopital", noDossierHopital);
        post.put("nam", nam);
        post.put("dateDernActivite", dateDernActivite);
        post.put("noTelephone", noTelephone);
        post.put("dateRapp", dateRapp);
        post.put("note", note);
        post.put("inObjectUsage", inObjectUsage);
        Integer idProfessionnal2 = idProfessionnal;
        if (idProfessionnal2 == null) {
            idProfessionnal2 = new Integer(-1);
        }
        post.put("idProfessionnal", idProfessionnal);
        post.put("idIntervenant", idIntervenant);
        post.put("rdvsToMove", rdvsToMove);
        IntArrayList idSites = null;
        if (sites != null && sites.size() > 0) {
            idSites = new IntArrayList(sites.size());
            for (XSite site : sites) {
                idSites.add(site.getId().intValue());
            }
        }
        post.put("idSites", idSites == null ? null : idSites.toIntArray());
        post.put("returnOneOrNull", returnOneOrNull);
        post.put("deleted", deleted);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findPatientExactNoDossier(String noDossier) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/findPatientExactNoDossier"), "application/octet-stream", "application/json");
        HashMap<String, String> post = new HashMap<String, String>();
        post.put("noDossier", noDossier);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getPatientsByIds(String ids) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/getPatientsByIds"), "application/octet-stream", "application/json");
        HashMap<String, String> post = new HashMap<String, String>();
        post.put("ids", ids);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findPatientSummary(int patientId, XFindPatientSummaryCriteria criteria) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/findPatientSummary"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("patientId", patientId);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (criteria != null) {
            map.put("prof", criteria.idProf);
            map.put("dateRange", (Integer)criteria.dateRange);
        }
        post.put("parameters", this.serialize(map));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject find(Group params) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/find"), "application/octet-stream", "application/json");
        HashMap<String, byte[]> post = new HashMap<String, byte[]>();
        post.put("dataObject", this.serialize((Serializable)params));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getBasePatient(int patientId) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/getBasePatient"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", patientId);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getSimplePatients(List<Integer> ids) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/getSimplePatients"), "application/octet-stream", "application/json");
        HashMap<String, List<Integer>> post = new HashMap<String, List<Integer>>();
        post.put("ids", ids);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getFusionPatient(int patientId) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/getFusionPatient"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", patientId);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getLastUsed() {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/getLastUsed"), "application/octet-stream", "application/json");
        HashMap post = new HashMap();
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ReturnObject getPatient(int patientId) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/getPatient"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", patientId);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        if (response == null || response.getObj() == null || response.getObj() instanceof XPatient) return response;
        if (response.getObj() instanceof XPatient[]) {
            XPatient[] xpts = (XPatient[])response.getObj();
            if (xpts == null || xpts.length != 1) throw new RuntimeException((xpts == null ? "Patient on trouv\u00e9" : "ai trouv\u00e9 > 1 XPatient") + " pour idPatient:" + patientId);
            response.setObj((Object)xpts[0]);
            return response;
        } else {
            logger.severe("getPatient response.obj is not of a supported type " + response.getObj().getClass().getName().toString());
            throw new RuntimeException("getPatient response.obj is not of a supported type " + response.getObj().getClass().getName().toString());
        }
    }

    @Override
    public ReturnObject setAsUsed(int patientId) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/setAsUsed"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", patientId);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findFamilly(int patientId, Integer filter) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/findFamilly"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", patientId);
        post.put("filter", filter);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getSimplePatient(int patientId) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/getSimplePatient"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", patientId);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject save(IDataObject dataObject, boolean askQuestion) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/save"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("dataObject", this.serialize((Serializable)dataObject));
        post.put("askQuestion", askQuestion);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject sendEmails(HashMap<String, Serializable> map) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/sendEmails"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, byte[]> post = new HashMap<String, byte[]>();
        post.put("dataObject", this.serialize(map));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject sendTexto(HashMap<String, Serializable> map) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(PatientAccessor.getPath() + "/sendTexto"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, byte[]> post = new HashMap<String, byte[]>();
        post.put("dataObject", this.serialize(map));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }
}

