/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.client;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.template.ITemplateAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TemplateAccessorClient {
    private static final Logger logger = Logger.getLogger(TemplateAccessorClient.class.getName());
    private final ITemplateAccessor accessor = Application.get().getDataAccessors().getTemplateAccessor();

    public List<XTemplate> getAll(XCompletionProposalType type) {
        return this.getAll(type == null ? null : Integer.valueOf(type.getValue()));
    }

    public List<XTemplate> getAll(Integer type) {
        List<XTemplate> list;
        try {
            list = this.accessor.getAll(type);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find template with type=" + type, e);
            XTemplate template = new XTemplate();
            template.setName(TemplateAccessorClient.getMessage(e));
            template.setText("");
            list = new ArrayList<XTemplate>(1);
            list.add(template);
        }
        return list;
    }

    public List<XTemplate> find(XCompletionProposalType type, String text) {
        return this.find(type == null ? null : Integer.valueOf(type.getValue()), text);
    }

    public List<XTemplate> find(int type, String text) {
        List<XTemplate> list;
        text = StringUtils.NormalizeToLowercase((String)text);
        Integer user = Application.get().getGlobalInstances().getSession().getUser().getId();
        try {
            list = this.accessor.list(user, type, text);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find template with type=" + type + ",text=" + text, e);
            XTemplate template = new XTemplate();
            template.setName(TemplateAccessorClient.getMessage(e));
            template.setText("");
            list = new ArrayList<XTemplate>(1);
            list.add(template);
        }
        return list;
    }

    public List<XTemplate> findLastUsed(XCompletionProposalType type, String text) {
        return this.findLastUsed(type == null ? null : Integer.valueOf(type.getValue()), text);
    }

    public List<XTemplate> findLastUsed(Integer type, String text) {
        List<XTemplate> list;
        text = StringUtils.NormalizeToLowercase((String)text);
        try {
            list = this.accessor.listLastUsed(type, text, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find template with type=" + type + ",text=" + text, e);
            XTemplate template = new XTemplate();
            template.setName(TemplateAccessorClient.getMessage(e));
            template.setText("");
            list = new ArrayList<XTemplate>(1);
            list.add(template);
        }
        return list;
    }

    public List<XTemplate> findOneListGrouping(Integer type, String text) {
        text = StringUtils.NormalizeToLowercase((String)text);
        List<XTemplate> list = null;
        try {
            list = this.accessor.listForEform(type, text, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find template with type=" + type + ",text=" + text, e);
            XTemplate template = new XTemplate();
            template.setName(TemplateAccessorClient.getMessage(e));
            template.setText("");
            list = new ArrayList<XTemplate>(1);
            list.add(template);
        }
        return list;
    }

    public List<XTemplate> findMostUsed(XCompletionProposalType type, String text) {
        return this.findMostUsed(type == null ? null : Integer.valueOf(type.getValue()), text, null, null);
    }

    public List<XTemplate> findMostUsed(Integer type, String text, Integer limit, Integer offset) {
        List<XTemplate> list;
        text = StringUtils.NormalizeToLowercase((String)text);
        try {
            list = this.accessor.listMostUsed(type, text, limit, offset);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find template with type=" + type + ",text=" + text, e);
            XTemplate template = new XTemplate();
            template.setName(TemplateAccessorClient.getMessage(e));
            template.setText("");
            list = new ArrayList<XTemplate>(1);
            list.add(template);
        }
        return list;
    }

    public List<XTemplate> findMostUsedClient(XCompletionProposalType type, String text) {
        return this.findMostUsedClient(type == null ? null : Integer.valueOf(type.getValue()), text, null, null);
    }

    public List<XTemplate> findMostUsedClient(Integer type, String text, Integer limit, Integer offset) {
        List<XTemplate> list;
        text = StringUtils.NormalizeToLowercase((String)text);
        try {
            list = this.accessor.listMostUsedClient(type, text, limit, offset);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find template with type=" + type + ",text=" + text, e);
            XTemplate template = new XTemplate();
            template.setName(TemplateAccessorClient.getMessage(e));
            template.setText("");
            list = new ArrayList<XTemplate>(1);
            list.add(template);
        }
        return list;
    }

    public List<XTemplate> findMostUsedGlobal(XCompletionProposalType type, String text) {
        return this.findMostUsedGlobal(type == null ? null : Integer.valueOf(type.getValue()), text, null, null);
    }

    public List<XTemplate> findMostUsedGlobal(Integer type, String text, Integer limit, Integer offset) {
        List<XTemplate> list;
        text = StringUtils.NormalizeToLowercase((String)text);
        try {
            list = this.accessor.listMostUsedGlobal(type, text, limit, offset);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find template with type=" + type + ",text=" + text, e);
            XTemplate template = new XTemplate();
            template.setName(TemplateAccessorClient.getMessage(e));
            template.setText("");
            list = new ArrayList<XTemplate>(1);
            list.add(template);
        }
        return list;
    }

    public String getText(Integer id) {
        if (id != null && id != -1) {
            List<XTemplate> list = this.accessor.list(id, null, null);
            return list.size() == 0 ? null : list.get(0).getText();
        }
        return "";
    }

    public void use(Integer id) {
        if (id != null && id != -1) {
            this.accessor.use(id);
        }
    }

    public void delete(Integer id) {
        if (id != null && id != -1) {
            this.accessor.delete(id);
        }
    }

    public XTemplate save(XTemplate template) {
        ReturnObject response = this.accessor.save(template);
        return (XTemplate)response.getObj();
    }

    private static String getMessage(Throwable e) {
        while (e != null && e.getLocalizedMessage() == null) {
            e = e.getCause();
        }
        return e == null ? "Erreur" : e.getLocalizedMessage();
    }
}

