/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.core.routes;

import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.IWebSocketRequest;
import java.util.HashMap;
import java.util.Map;

public class ServerRequestContext
implements IServerRequest {
    private final IServerRequest request;
    private final Map<String, Object> evaluationContext;
    private final Map<String, byte[]> parts;

    public ServerRequestContext(IServerRequest request) {
        String contentType;
        this.request = request;
        this.evaluationContext = new HashMap<String, Object>();
        this.parts = new HashMap<String, byte[]>();
        if (request.getMethod().equals("POST") && (contentType = request.getQueryParam("Content-Type", String.class)) != null && contentType.toLowerCase().startsWith("multipart/form-data")) {
            this.processMultipartFormData(request);
        }
    }

    public Map<String, Object> evaluationContext() {
        return this.evaluationContext;
    }

    public Map<String, Object> state() {
        return this.evaluationContext;
    }

    public void resetState() {
        this.evaluationContext.clear();
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getPath() {
        return this.request.getPath();
    }

    @Override
    public String getQuery() {
        return this.request.getQuery();
    }

    @Override
    public Map<String, String> getQueryParams() {
        return this.request.getQueryParams();
    }

    @Override
    public boolean hasQueryParam(String key) {
        return this.request.hasQueryParam(key);
    }

    @Override
    public String getQueryParam(String key) {
        return this.request.getQueryParam(key);
    }

    @Override
    public <T> T getQueryParam(String key, Class<T> c) {
        return this.request.getQueryParam(key, c);
    }

    @Override
    public <T> T getQueryParam(String key, T defaultValue, Class<T> c) {
        return this.request.getQueryParam(key, defaultValue, c);
    }

    @Override
    public String getRequiredQueryParam(String key) {
        return this.request.getRequiredQueryParam(key);
    }

    @Override
    public <T> T getRequiredQueryParam(String key, Class<T> c) {
        return this.request.getRequiredQueryParam(key, c);
    }

    @Override
    public boolean hasPostBody() {
        return this.request.hasPostBody();
    }

    @Override
    public Object getPostBody() {
        return this.request.getPostBody();
    }

    @Override
    public <T> T getPostBody(Class<T> c) {
        return this.request.getPostBody(c);
    }

    @Override
    public IWebSocketRequest getWebSocketRequest() {
        return this.request.getWebSocketRequest();
    }

    @Override
    public String getHostAddr() {
        return this.request.getHostAddr();
    }

    @Override
    public String printDebugInfo() {
        return this.request.printDebugInfo();
    }

    @Override
    public String getHttpSessionId() {
        return this.request.getHttpSessionId();
    }

    @Override
    public IServerRequest.Browser getBrowser() {
        return null;
    }

    private void processMultipartFormData(IServerRequest request) {
        if (request.getPostBody() instanceof Map) {
            Map partMap = (Map)request.getPostBody();
            this.parts.putAll(partMap);
        }
    }

    @Override
    public Map<String, byte[]> getParts() {
        return this.parts;
    }

    @Override
    public byte[] getPart(String name) {
        return this.parts.get(name);
    }
}

