/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.util;

import ca.infodata.ofys.client.util.DownloadSupplier;
import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;

public class DownloadSupplierWithRetry
extends DownloadSupplier {
    private TimeUnit retryWaitTimeUnit = TimeUnit.MILLISECONDS;
    private long retryWaitTimeValue = 200L;
    private short maxTry = (short)2;
    private short tryCount;

    public DownloadSupplierWithRetry(String url) throws MalformedURLException {
        this(url, 2);
    }

    public DownloadSupplierWithRetry(String url, short maxTry) throws MalformedURLException {
        super(url);
        this.maxTry = maxTry < 1 ? (short)1 : maxTry;
    }

    @Override
    protected void downloadInternal() throws Exception {
        while (true) {
            try {
                this.tryCount = (short)(this.tryCount + 1);
                super.downloadInternal();
                return;
            }
            catch (Exception e) {
                if (this.tryCount >= this.maxTry) {
                    throw new Exception("Download failed. max try count of " + this.maxTry + " reached. url=" + this.url);
                }
                this.retryWaitTimeUnit.sleep(this.retryWaitTimeValue);
                if (this.tryCount < this.maxTry) continue;
                throw new Exception("Download failed. max try count of " + this.maxTry + " reached. url=" + this.url);
            }
            break;
        }
    }

    public void setRetryWaitTime(long value, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("retryWaitTime unit");
        }
        this.retryWaitTimeValue = value;
        this.retryWaitTimeUnit = unit;
    }
}

