/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.eform.metadata;

import ca.infodata.ofys.client.modules.eform.metadata.IMetaDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class MetaDataType {
    private static final Logger logger = Logger.getLogger("ca.infodata.eform.client.metadata.MetaDataType");
    private static MetaDataType instance;
    private List<IMetaDataType<?>> dataTypes = new ArrayList();
    private static final String METADATATYPE_EXTENSION_ID = "ca.infodata.ofys.data.client.dataaccess.metadatatypes";

    private MetaDataType() {
    }

    private static MetaDataType getInstance() {
        if (instance == null) {
            instance = new MetaDataType();
            MetaDataType.setExtensionMetaDataType();
        }
        return instance;
    }

    public static void add(IMetaDataType<?> imdt) {
        MetaDataType.getInstance().dataTypes.add(imdt);
    }

    public static IMetaDataType<?> fromValue(int value) {
        for (IMetaDataType<?> imdt : MetaDataType.getInstance().dataTypes) {
            if (imdt.getValue() != value) continue;
            return imdt.getNewInstance();
        }
        return null;
    }

    private static void setExtensionMetaDataType() {
        IConfigurationElement[] config;
        for (IConfigurationElement e : config = Platform.getExtensionRegistry().getConfigurationElementsFor(METADATATYPE_EXTENSION_ID)) {
            try {
                Object factory;
                String factoryClass = e.getAttribute("class");
                String dataClass = e.getAttribute("dataClass");
                if (factoryClass == null || dataClass == null || !((factory = e.createExecutableExtension("class")) instanceof IMetaDataType)) continue;
                IMetaDataType factory2 = (IMetaDataType)factory;
                System.out.println(factory2);
                MetaDataType.add(factory2);
            }
            catch (CoreException ex) {
                logger.log(Level.WARNING, "Failed to load prSubComposite " + e, ex);
            }
        }
    }
}

