/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.eform;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.cache.IApplicationCaches;
import ca.infodata.ofys.client.cache.IEformCache;
import ca.infodata.ofys.client.cache.IEformFavoriteCache;
import ca.infodata.ofys.client.modules.eform.metadata.MetaDataContainer;
import ca.infodata.ofys.client.modules.eform.metadata.MetaDataFactory;
import ca.infodata.ofys.data.dataaccess.NoSessionException;
import ca.infodata.ofys.data.dataaccess.client.EFormAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformDataCriteria;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformType;
import ca.infodata.ofys.data.middle.dataobjects.signatures.CUserSignatures;
import ca.infodata.ofys.data.middle.dataobjects.signatures.CUserSignaturesForEformData;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EformController {
    private static final Logger logger = Logger.getLogger(EformController.class.getName());
    private final EFormAccessorClient eFormAccessorClient = new EFormAccessorClient();
    private final IEformCache eformCache;
    private final IEformFavoriteCache eformFavoriteCache;

    public EformController() {
        IApplicationCaches cache = Application.get().getCache();
        this.eformCache = cache.getEformCache();
        this.eformFavoriteCache = cache.getEformFavoriteCache();
    }

    public XEformData save(XEformData data) throws Exception {
        return this.eFormAccessorClient.saveData(data);
    }

    public List<XBaseEformData> listPersonFormData(int idPerson, Boolean withRevision) {
        try {
            return this.eFormAccessorClient.listByPerson(idPerson, withRevision);
        }
        catch (NoSessionException e) {
            return new ArrayList<XBaseEformData>(0);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading person eformdata, person=" + StringUtils.safeToString((Logger)logger, (Object)idPerson), e);
            return new ArrayList<XBaseEformData>(0);
        }
    }

    public List<XBaseEformData> listFormData(int idPatient, Boolean withRevision) {
        try {
            return this.eFormAccessorClient.listByPatient(idPatient, Boolean.FALSE, withRevision);
        }
        catch (NoSessionException e) {
            return new ArrayList<XBaseEformData>(0);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading patient eformdata, patient=" + StringUtils.safeToString((Logger)logger, (Object)idPatient), e);
            return new ArrayList<XBaseEformData>(0);
        }
    }

    public List<XBaseEformData> dataByIdAnchors(Integer[] ids, Boolean fillPatient, Boolean withRevision) {
        try {
            return this.eFormAccessorClient.dataByIdAnchors(ids, fillPatient, withRevision);
        }
        catch (NoSessionException e) {
            return new ArrayList<XBaseEformData>(0);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading dataGetByIds=" + StringUtils.safeToString((Logger)logger, (Object)ids), e);
            return new ArrayList<XBaseEformData>(0);
        }
    }

    public XEformData getFormData(Integer idEformData, boolean loadFullEform) throws Exception {
        XEformData data = this.eFormAccessorClient.getData(idEformData);
        if (loadFullEform) {
            data.setEform((XBaseEform)this.getFullEForm(data.getForm().getId(), idEformData).clone());
        }
        return data;
    }

    public XEformData modifyFormData(int idEformData, int idPatient) throws Exception {
        XEformData data2 = this.eFormAccessorClient.getData(idEformData);
        data2.setId(null);
        data2.setDatetime(DateUtil.newCalendar());
        data2.setIdPatient(Integer.valueOf(idPatient));
        data2.setEform((XBaseEform)this.getFullEForm(data2.getForm().getId()).clone());
        return data2;
    }

    public XEformData modifyFormData(XBaseEformData data) throws Exception {
        XEformData data2;
        if (data instanceof XEformData) {
            data2 = ((XEformData)data).clone();
        } else {
            data = this.eFormAccessorClient.getData(data.getId());
            data2 = (XEformData)data;
        }
        data2.setId(null);
        data2.setDatetime(DateUtil.newCalendar());
        data2.setEform((XBaseEform)this.getFullEForm(data2.getForm().getId()).clone());
        return data2;
    }

    public XEformData newFormDataCopy(int idEformData, int idPatient) throws Exception {
        XEformData data2 = this.eFormAccessorClient.getData(idEformData);
        if (data2.getForm() != null && XEformType.CNESST.equals((Object)data2.getForm().getType())) {
            data2.setCnesstRefNo(null);
            Properties properties = new Properties();
            properties.load(new StringReader(data2.getData()));
            properties.remove("no_ref");
            properties.remove("date_ref");
            properties.remove("bloc4_tel1");
            StringWriter writer = new StringWriter(5000);
            properties.store(writer, null);
            data2.setData(writer.toString());
        }
        data2.setId(null);
        data2.setIdAnchor(null);
        data2.setDatetime(DateUtil.newCalendar());
        data2.setIdPatient(Integer.valueOf(idPatient));
        data2.setEform((XBaseEform)this.getFullEForm(data2.getForm().getId()).clone());
        data2.setIdAuthor(Application.get().getGlobalInstances().getSessionPerson());
        return data2;
    }

    public XEformData newFormDataCopy(XEformData data) throws Exception {
        XEformData data2 = data.clone();
        data2.setId(null);
        data2.setIdAnchor(null);
        data2.setDatetime(DateUtil.newCalendar());
        data2.setEform((XBaseEform)this.getFullEForm(data2.getForm().getId()).clone());
        data2.setIdAuthor(Application.get().getGlobalInstances().getSessionPerson());
        return data2;
    }

    public XEformData getLastDataWithCode(Integer idPatient, String eformCode) throws Exception {
        XEformDataCriteria c = new XEformDataCriteria();
        c.idPatient = idPatient;
        c.eformCode = eformCode;
        c.limit = 1;
        c.allVersions = false;
        List<XEformData> list = this.eFormAccessorClient.listData(c);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    public final XEformData newFormData(int idEform, Integer idPatient) throws Exception {
        XEform eform = this.getFullEForm(idEform);
        XEformData data = new XEformData();
        data.setDatetime(DateUtil.newCalendar());
        data.setEform((XBaseEform)eform.clone());
        if (idPatient != null) {
            data.setIdPatient(idPatient);
        }
        data.setIdAuthor(Application.get().getGlobalInstances().getSessionPerson());
        return data;
    }

    public final XEformData newFormData(String eformCode, int idPatient) throws Exception {
        XEform eform = this.eFormAccessorClient.getByCode(eformCode);
        XEformData data = new XEformData();
        data.setDatetime(DateUtil.newCalendar());
        data.setEform((XBaseEform)eform.clone());
        data.setIdPatient(Integer.valueOf(idPatient));
        data.setIdAuthor(Application.get().getGlobalInstances().getSessionPerson());
        return data;
    }

    public final boolean removeFromFavorites(int[] idEform) {
        logger.info("EformController.removeFromFavorites()");
        try {
            for (int i : idEform) {
                if (!this.eformFavoriteCache.contains(i)) continue;
                this.eformFavoriteCache.remove(i);
            }
            return true;
        }
        catch (NoSessionException e) {
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to remove eform from favorite. form=" + StringUtils.safeToString((Logger)logger, (Object)idEform), e);
            return false;
        }
    }

    public final boolean removeFromFavorites(int idEform) {
        logger.info("EformController.removeFromFavorites()");
        try {
            this.eFormAccessorClient.removeFromFavorites(idEform);
            this.eformFavoriteCache.remove(idEform);
            return true;
        }
        catch (NoSessionException e) {
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to remove eform from favorite. form=" + StringUtils.safeToString((Logger)logger, (Object)idEform), e);
            return false;
        }
    }

    public final boolean setInactiveList(int[] idEforms) {
        logger.info("EformController.setInactiveList()");
        try {
            this.eFormAccessorClient.setInactiveList(idEforms);
            this.removeFromFavorites(idEforms);
            return true;
        }
        catch (NoSessionException e) {
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to set inactive list. idEforms=" + StringUtils.safeToString((Logger)logger, (Object)idEforms), e);
            return false;
        }
    }

    public final boolean setActiveList(int[] idEforms) {
        logger.info("EformController.setActiveList()");
        try {
            this.eFormAccessorClient.setActiveList(idEforms);
            return true;
        }
        catch (NoSessionException e) {
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to set active list. idEforms=" + StringUtils.safeToString((Logger)logger, (Object)idEforms), e);
            return false;
        }
    }

    public final boolean addToFavorites(int idEform) {
        logger.info("EformController.addToFavorites()");
        try {
            this.eFormAccessorClient.addToFavorites(idEform);
            XBaseEform eform = this.eformCache.get(idEform);
            this.eformFavoriteCache.put(idEform, eform);
            return true;
        }
        catch (NoSessionException e) {
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add eform to favorite. form=" + StringUtils.safeToString((Logger)logger, (Object)idEform), e);
            return false;
        }
    }

    public final List<XBaseEform> getForms() {
        return this.eformCache.getAll();
    }

    public final List<XBaseEform> getAllForms() {
        try {
            return this.eFormAccessorClient.list(true);
        }
        catch (NoSessionException e) {
            return new ArrayList<XBaseEform>(0);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed get all non-filtered eforms", e);
            return new ArrayList<XBaseEform>(0);
        }
    }

    public final List<XBaseEform> getAllFormsForAdmin() {
        try {
            return this.eFormAccessorClient.list(false);
        }
        catch (NoSessionException e) {
            return new ArrayList<XBaseEform>(0);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed get all non-filtered eforms", e);
            return new ArrayList<XBaseEform>(0);
        }
    }

    public final List<XBaseEform> getFavorites() {
        return this.eformFavoriteCache.getAll();
    }

    public final XEform getFullEForm(Integer idForm, Integer idEformData) throws Exception {
        XEform eform = this.eFormAccessorClient.get(idForm, idEformData);
        return eform;
    }

    public final XEform getFullEForm(Integer idForm) throws Exception {
        return this.getFullEForm(idForm, null);
    }

    public final XEform getFullEForm(XBaseEform eform) throws Exception {
        if (eform instanceof XEform && ((XEform)eform).getHtml() != null) {
            return (XEform)eform;
        }
        return this.getFullEForm(eform.getId());
    }

    public final boolean deleteFormData(int id) {
        logger.info("EformController.deleteFormData()");
        try {
            this.eFormAccessorClient.deleteFormData(id);
            return true;
        }
        catch (NoSessionException e) {
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add deleteFormData. id=" + StringUtils.safeToString((Logger)logger, (Object)id), e);
            return false;
        }
    }

    public final boolean delAttenteResultats(int id) {
        logger.info("EformController.delAttenteResultats()");
        try {
            this.eFormAccessorClient.delAttenteResultats(id);
            return true;
        }
        catch (NoSessionException e) {
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add deleteFormData. id=" + StringUtils.safeToString((Logger)logger, (Object)id), e);
            return false;
        }
    }

    public final boolean unDeleteFormData(int id) {
        logger.info("EformController.unDeleteFormData()");
        try {
            this.eFormAccessorClient.unDeleteFormData(id);
            return true;
        }
        catch (NoSessionException e) {
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add unDeleteFormData. id=" + StringUtils.safeToString((Logger)logger, (Object)id), e);
            return false;
        }
    }

    public final Map<String, Object> mapFormInputs(Object[] inputs, String errorMessage) throws RuntimeException {
        if (inputs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = null;
        try {
            map = new HashMap<String, Object>(inputs.length / 2);
            for (int i = 0; i < inputs.length; ++i) {
                String key;
                if ((key = (String)inputs[i++]) == null || inputs[i] == null && "".equals(inputs[i])) continue;
                Object value = inputs[i];
                String valueMod = value == null ? "" : ((String)value).replaceAll("=", "~~~");
                map.put(key, valueMod);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get values from inputs. " + errorMessage, e);
            throw new RuntimeException(e);
        }
        return map;
    }

    public final XEformData saveInputsToEFormData(XEformData edata, Map<String, Object> inputs, Object[] metas, boolean mustCheckMetaData, String value) {
        if (mustCheckMetaData) {
            List<MetaDataContainer> metaData = MetaDataFactory.extractMetaDataFrom(metas);
            for (MetaDataContainer mdc : metaData) {
                if (mdc.exception == null) continue;
                logger.log(Level.SEVERE, "Unexpected erreur on eform " + edata.getForm().getId() + " with " + mdc, mdc.exception);
                break;
            }
            String mdS = MetaDataContainer.toJsonString(metaData, edata.getMetaData());
            edata.setMetaData(mdS);
        }
        Properties properties = new Properties();
        for (Map.Entry<String, Object> entry : inputs.entrySet()) {
            if (entry.getValue() == null || entry.getValue().equals("")) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        XBaseProfessionnal sessionProfessionnal = Application.get().getPersonPluginController().getSessionProfessionnal();
        CUserSignatures signatures = Application.get().getGlobalInstances().getSession().getSignatures();
        CUserSignaturesForEformData.signEformData((XBaseProfessionnal)sessionProfessionnal, (CUserSignatures)signatures, (XEformData)edata, (Properties)properties);
        String data = MiscUtil.propertiesToData((Properties)properties);
        edata.setData(data);
        edata.setResumeValue(value);
        return edata;
    }
}

