/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.labo.getreport.pdf.LaboReportHeaderFlat;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.GetLaboListController;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.data.middle.dataobjects.CDsqDmeObjectList;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.dashboard.models.CDSQResult;
import ca.infodata.ofys.ui.dashboard.models.CDsqRequest;
import ca.infodata.ofys.ui.dashboard.models.CLaboReportHeaderFlat;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetLaboListControllerWeb {
    private static final Logger logger = Logger.getLogger(GetLaboListController.class.getName());
    private static final String channelName = "dsq.lab.search";
    private final GetLaboListController controller;
    private final Integer idPatient;
    private CDsqRequest dsqRequest;
    private IWebSocketChannel wsChannel;

    public GetLaboListControllerWeb(Integer idPatient, IWebSocketChannel channel, GetCandidateController findCandidateController) {
        this.idPatient = idPatient;
        this.wsChannel = channel;
        this.controller = new GetLaboListController(idPatient, findCandidateController){

            @Override
            public void callback(DsqCallback<QueryContinuationResult> dsqCallback) {
                GetLaboListControllerWeb.this.callback(dsqCallback);
            }
        };
    }

    public void list(CDsqRequest dsqRequest) {
        if (dsqRequest == null) {
            throw new NullPointerException("dsqRequest");
        }
        if (dsqRequest.patientId == null) {
            throw new NullPointerException("dsqRequest.patientId");
        }
        if (!dsqRequest.patientId.equals(this.idPatient)) {
            throw new IllegalArgumentException("dsqRequest.patientId != controller.patient.id");
        }
        try {
            this.dsqRequest = dsqRequest;
            this.controller.setStart(CDsqRequest.parseLocalDateSafe(dsqRequest.start));
            this.controller.setEnd(CDsqRequest.parseLocalDateSafe(dsqRequest.end));
            MultiStatus status = this.controller.valid();
            if (status.isOK()) {
                this.controller.list();
            } else {
                ServerResponses.sendJsonToClient(this.wsChannel, channelName, new ReturnObject(status));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while getting labo list", e);
            Status status = new Status(IStatus.Severity.ERROR, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]));
            ServerResponses.sendJsonToClient(this.wsChannel, channelName, new ReturnObject((Serializable)status));
        }
    }

    protected void callback(DsqCallback<QueryContinuationResult> callback) {
        CDsqDmeObjectList ol = new CDsqDmeObjectList.Builder().setIdPatient(this.dsqRequest.patientId.intValue()).setStartdate(Integer.valueOf(CDsqRequest.parseLocalDateSafe((String)this.dsqRequest.start).dayFrom1970)).setEnddate(Integer.valueOf(CDsqRequest.parseLocalDateSafe((String)this.dsqRequest.end).dayFrom1970)).setMethod(CDsqDmeObjectList.METHODS.getLaboList).setResult((QueryContinuationResult)callback.result).build();
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        CDSQResult<CLaboReportHeaderFlat> r = new CDSQResult<CLaboReportHeaderFlat>();
        r.setCriteria(ol);
        if (ol.result != null) {
            for (String warning : ol.result.laboResultsWarnings) {
                ms.add((IStatus)new Status(IStatus.Severity.WARNING, warning));
            }
            List<LaboReportHeaderFlat> list = this.orderLaboReportSearchResults(ol.result);
            String timeOfRequest = null;
            if (ol.timeOfDsqRequest > 0L) {
                timeOfRequest = Utils.longTodateStr(ol.timeOfDsqRequest, "yyyy-MM-dd HH:mm:ss");
            }
            r.setList(this.toCLaboReportHeaderFlat(list, timeOfRequest));
        }
        ro.setObj(r);
        String message = callback.message;
        if (callback.exception != null) {
            if (StringUtils.isBlank((CharSequence)message)) {
                message = StringUtils.isNotBlank((String)callback.exception.getMessage()) ? callback.exception.getMessage() : callback.exception.getClass().getSimpleName();
            }
            if (callback.exception instanceof StatusException) {
                StatusException statusException = (StatusException)((Object)callback.exception);
                ms.setSeverity(statusException.getStatus().getSeverity());
            } else {
                ms.setSeverity(IStatus.Severity.ERROR);
            }
        } else {
            ms.setSeverity(IStatus.Severity.OK);
        }
        if (StringUtils.isNotBlank((String)message)) {
            ms.setMessage(message);
        }
        ro.setStatus(ms);
        ServerResponses.sendJsonToClient(this.wsChannel, channelName, ro);
    }

    public void sendDsqListLabo(IWebSocketChannel wsChannel, CDsqDmeObjectList ol) {
        if (ol != null && ol.result != null) {
            ReturnObject ro = new ReturnObject();
            MultiStatus ms = new MultiStatus();
            for (String warning : ol.result.laboResultsWarnings) {
                ms.add((IStatus)new Status(IStatus.Severity.WARNING, warning));
            }
            List<LaboReportHeaderFlat> list = this.orderLaboReportSearchResults(ol.result);
            String timeOfRequest = null;
            if (ol.timeOfDsqRequest > 0L) {
                timeOfRequest = Utils.longTodateStr(ol.timeOfDsqRequest, "yyyy-MM-dd HH:mm:ss");
            }
            CDSQResult<CLaboReportHeaderFlat> r = new CDSQResult<CLaboReportHeaderFlat>();
            r.setCriteria(ol);
            r.setList(this.toCLaboReportHeaderFlat(list, timeOfRequest));
            ro.setObj(r);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
            ServerResponses.sendJsonToClient(wsChannel, channelName, ro);
        }
    }

    private List<CLaboReportHeaderFlat> toCLaboReportHeaderFlat(List<LaboReportHeaderFlat> l, String timeOfRequest) {
        ArrayList<CLaboReportHeaderFlat> cl = new ArrayList<CLaboReportHeaderFlat>();
        for (LaboReportHeaderFlat i : l) {
            CLaboReportHeaderFlat res = new CLaboReportHeaderFlat(i);
            if (timeOfRequest != null) {
                res.timeOfDsqRequest = timeOfRequest;
            }
            cl.add(res);
        }
        return cl;
    }

    private List<LaboReportHeaderFlat> orderLaboReportSearchResults(QueryContinuationResult result) {
        ArrayList<LaboReportHeaderFlat> list = result == null || result.laboResults == null ? new ArrayList<LaboReportHeaderFlat>() : LaboReportHeaderFlat.from((List)result.laboResults);
        Collections.sort(list, new Comparator<LaboReportHeaderFlat>(){

            @Override
            public int compare(LaboReportHeaderFlat o1, LaboReportHeaderFlat o2) {
                return -o1.laboReportHeader.specimenCollectionStartDatetime.compareTo(o2.laboReportHeader.specimenCollectionStartDatetime);
            }
        });
        return list;
    }
}

