/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.NIU_SH;
import ca.infodata.dsq.domain.VIEW_MODE;
import ca.infodata.dsq.service.sommhosp.get.PatientDischargeCareDetail;
import ca.infodata.dsq.service.sommhosp.get.PatientDischargeCareDetails;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.GetDischargeCareDetailController;
import ca.infodata.ofys.client.modules.dsq.internal.PatientDischargeReportPdf2;
import ca.infodata.ofys.client.web.controller.DocumentsController;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.dashboard.models.CDsqRequest;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.CPatientDischargeCareDetail;
import ca.infodata.ofys.ui.dashboard.models.CPatientImage;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.Triple;
import ca.infodata.util1.date.DateUtil;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetDischargeCareDetailControllerWeb {
    private static final Logger logger = Logger.getLogger(GetDischargeCareDetailControllerWeb.class.getName());
    private static final String channelName = "dsq.sommhosp.get";
    private GetDischargeCareDetailController controller;
    private DocumentsController documentsController;
    private Integer idPatient;
    private IWebSocketChannel wsChannel;

    public GetDischargeCareDetailControllerWeb(Integer idPatient, IWebSocketChannel channel, GetCandidateController findCandidateController, DocumentsController documentsController) {
        this.idPatient = idPatient;
        this.wsChannel = channel;
        this.documentsController = documentsController;
        this.controller = new GetDischargeCareDetailController(idPatient, findCandidateController){

            @Override
            public void callback(DsqCallback<Triple<Integer, Candidate, PatientDischargeCareDetails>> dsqCallback) {
                GetDischargeCareDetailControllerWeb.this.callback(dsqCallback);
            }
        };
    }

    public void get(CDsqRequest dsqRequest) {
        if (dsqRequest == null) {
            throw new NullPointerException("dsqRequest");
        }
        if (dsqRequest.patientId == null) {
            throw new NullPointerException("dsqRequest.patientId");
        }
        if (!dsqRequest.patientId.equals(this.idPatient)) {
            throw new IllegalArgumentException("dsqRequest.patientId != controller.patient.id");
        }
        try {
            this.controller.get(new NIU_SH(dsqRequest.value), dsqRequest.includeHistory);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while getting discharge care detail", e);
            Status status = new Status(IStatus.Severity.ERROR, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]));
            ServerResponses.sendJsonToClient(this.wsChannel, channelName, new ReturnObject((Serializable)status));
        }
    }

    protected void callback(DsqCallback<Triple<Integer, Candidate, PatientDischargeCareDetails>> dsqCallback) {
        if (!this.processExceptionOrMessage(dsqCallback) && dsqCallback.result != null) {
            try {
                ReturnObject ro = new ReturnObject();
                ArrayList<CPatientImage> cimages = new ArrayList<CPatientImage>();
                PatientDischargeCareDetails details = (PatientDischargeCareDetails)((Triple)dsqCallback.result).third;
                for (int i = 0; i < details.list.size(); ++i) {
                    boolean canBePrinted = i == 0;
                    cimages.add(this.getDischargeCareDetailReportPdf((Candidate)((Triple)dsqCallback.result).second, (PatientDischargeCareDetail)details.list.get(i), canBePrinted));
                }
                ro.setObj(cimages);
                for (String warning : details.warnings) {
                    ro.getStatus().add((IStatus)new Status(IStatus.Severity.WARNING, warning));
                }
                ServerResponses.sendJsonToClient(this.wsChannel, channelName, ro);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to render patient discharge care detail as pdf ", e);
                ServerResponses.sendJsonToClient(this.wsChannel, channelName, new ReturnObject((Serializable)new Status(IStatus.Severity.ERROR, "Erreur lors de la g\u00e9n\u00e9ration du pdf pour le sommaire d'hospitalisation")));
            }
        } else {
            ReturnObject ro = new ReturnObject();
            MultiStatus ms = new MultiStatus();
            String message = dsqCallback.message;
            if (dsqCallback.exception != null) {
                message = StringUtils.isNotBlank((String)dsqCallback.exception.getMessage()) ? dsqCallback.exception.getMessage() : dsqCallback.exception.getClass().getSimpleName();
            }
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(message);
            ro.setStatus(ms);
            ServerResponses.sendJsonToClient(this.wsChannel, channelName, ro);
        }
    }

    private CPatientImage getDischargeCareDetailReportPdf(Candidate candidate, PatientDischargeCareDetail detail, boolean canBePrinted) throws Exception {
        byte[] picture = null;
        byte[] pictureToPrint = null;
        CPatientImage cimage = new CPatientImage();
        cimage.name = detail.title;
        cimage.patient = CPatient.c(this.getPatient());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PatientDischargeReportPdf2 pdf = new PatientDischargeReportPdf2(candidate, detail);
        try {
            pdf.setViewMode(VIEW_MODE.VIEW);
            pdf.getPicture(bos);
            picture = bos.toByteArray();
            bos.reset();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to render view mode picture for discharge care detail", e);
            bos.reset();
            try {
                pdf.getErrorPicture(bos);
                picture = bos.toByteArray();
                bos.reset();
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Failed to render view mode ERROR picture for discharge care detail", e2);
            }
        }
        cimage.picture = picture;
        if (canBePrinted) {
            try {
                pdf.setViewMode(VIEW_MODE.PRINT);
                pdf.setPrintedBy(this.computePrintedBy());
                pdf.getPicture(bos);
                pictureToPrint = bos.toByteArray();
                bos.reset();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to render print mode picture for discharge care detail", e);
                bos.reset();
                try {
                    pdf.getErrorPicture(bos);
                    pictureToPrint = bos.toByteArray();
                    bos.reset();
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, "Failed to render print mode ERROR picture for discharge care detail", e2);
                }
            }
            cimage.pictureToPrint = pictureToPrint;
        }
        cimage.dsqDischargeCare = new CPatientDischargeCareDetail(detail, Utils.longTodateStr(DateUtil.now(), "yyyy-MM-dd HH:mm:ss"));
        String docId = "DSQDischargeCare" + detail.id.value() + "_version" + detail.version;
        cimage = this.documentsController.getCPatientImage(docId, cimage);
        return cimage;
    }

    private XPatient getPatient() {
        return Application.get().getCache().getPatientCache().get(this.idPatient);
    }

    private String computePrintedBy() {
        try {
            return Application.get().getApplicationUiPlugin().getPrintedByNotice();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to compute printed by", e);
            return null;
        }
    }

    private boolean processExceptionOrMessage(DsqCallback<?> dsqCallback) {
        return dsqCallback.exception != null || StringUtils.isNotBlank((String)dsqCallback.message);
    }
}

