/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.internal.ExportPrescriptionToDsqController;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.OERetractControllerWeb;
import ca.infodata.ofys.client.modules.encounter.XPrescriptionFormatter;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterModificationRequest;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExportPrescriptionToDsqControllerWeb {
    private static final Logger logger = Logger.getLogger(ExportPrescriptionToDsqControllerWeb.class.getName());
    private final ExportPrescriptionToDsqController controller;
    private final Integer idPatient;
    private final IWebSocketChannel wsChannel;

    public ExportPrescriptionToDsqControllerWeb(Integer idPatient, IWebSocketChannel channel, GetCandidateController findCandidateController, OERetractControllerWeb retractController) {
        this.idPatient = idPatient;
        this.wsChannel = channel;
        this.controller = new ExportPrescriptionToDsqController(idPatient, findCandidateController, retractController.getWrappedController());
    }

    public void export(XEncounterModificationRequest req) throws AbortException, CancelException, InterruptedException {
        ArrayList<XPrescription> lstRxToSend = new ArrayList<XPrescription>();
        if (req.getPrescriptions() != null) {
            for (XPrescription p : req.getPrescriptions()) {
                if (p.getDsqPrescriptionId() != null || p.getDsqDMPrescriptionId() != null || p.getDsqPrescriptionDispenseId() != null || p.getId() == null || !Boolean.FALSE.equals(p.getFromProfExterne())) continue;
                lstRxToSend.add(p);
            }
        }
        if (lstRxToSend.size() > 0) {
            ServerResponses.sendInfoMessageToClient(this.wsChannel, Messages.getString((String)"ExportPrescriptionToDsqAction.EXPORTATION_AU_DSQ", (String[])new String[0]));
            ExportPrescriptionToDsqController.ExportResult result = this.controller.export(lstRxToSend);
            if (result.failed != null) {
                String message = result.failed.getMessage();
                if (StringUtils.isBlank((CharSequence)message) && result.failed.getException() != null && StringUtils.isBlank((CharSequence)(message = result.failed.getException().getMessage()))) {
                    message = Messages.getString((String)"ERREUR", (String[])new String[0]);
                }
                ServerResponses.sendWarningMessageToClient(this.wsChannel, new JoinList(" - ", new Object[]{Messages.getString((String)"ExportPrescriptionToDsqAction.EXPORTATION_AU_DSQ", (String[])new String[0]), message}).toString());
            } else {
                for (ExportPrescriptionToDsqController.ExportData data : result.exported) {
                    if (data.status1 == null || data.status1.isOK()) continue;
                    String message = null;
                    try {
                        message = String.format("%s - %s", XPrescriptionFormatter.format(data.prescription, CPrescriptionFormatter.ShowMedFileDetail.MINIMAL), data.status1.getMessage());
                        ServerResponses.sendWarningMessageToClient(this.wsChannel, message);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error sending warning message for patient " + this.idPatient + ". message=" + message, e);
                    }
                }
            }
        }
    }
}

