/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.NIU_OTHER_MEDICATION_DM;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION_DM;
import ca.infodata.dsq.domain.OtherMedicationDetail;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.ofys.client.modules.dsq.DSQcallType;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.SqimHtmlFormatter;
import ca.infodata.ofys.client.modules.dsq.internal.CallBackResume;
import ca.infodata.ofys.client.modules.dsq.internal.CallBackSimpleResume;
import ca.infodata.ofys.client.modules.dsq.internal.DMMedicationController;
import ca.infodata.ofys.client.modules.dsq.internal.DMMedicationControllerCallback;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.LegacyDsqControllerWeb;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.util1.date.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DMMedicationControllerWeb
extends LegacyDsqControllerWeb {
    private static final Logger logger = Logger.getLogger(DMMedicationController.class.getName());
    private DMMedicationController controller;

    public DMMedicationControllerWeb(Integer idPatient, IWebSocketChannel channel, GetCandidateController findCandidateController) {
        super(idPatient, channel);
        this.controller = new DMMedicationController(idPatient, new DMMedicationControllerCallback(){

            @Override
            public String listSummary(DsqCallback<QueryContinuationResult> callback) {
                return DMMedicationControllerWeb.this.browserCallback("listMedicationsDM", new CallBackResume(callback, DSQcallType.DMMedication), SqimHtmlFormatter.getDMMedicationSummary((QueryContinuationResult)callback.result));
            }

            @Override
            public String getMedicationDetail(NIU_OTHER_MEDICATION_DM id, DsqCallback<OtherMedicationDetail> callback) {
                return DMMedicationControllerWeb.this.browserCallback("getMedicationDMDetail", new CallBackSimpleResume(callback), SqimHtmlFormatter.formatOtherMedicationDetails((OtherMedicationDetail)callback.result));
            }

            @Override
            public String getPrescriptionDetail(NIU_PRESCRIPTION_DM id, String context, DsqCallback<PrescriptionDrugDetails> callback) {
                return DMMedicationControllerWeb.this.browserCallback("getMedicationPrescriptionDMDetail", new CallBackSimpleResume(callback), SqimHtmlFormatter.formatPrescriptionDrugDetails((PrescriptionDrugDetails)callback.result), context);
            }
        }, findCandidateController);
    }

    public void getPrescriptionDetail(NIU_PRESCRIPTION_DM niu_PRESCRIPTION_DM, String context) {
        try {
            this.controller.getPrescriptionDetail(niu_PRESCRIPTION_DM, context);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            DsqCallback<Object> callback = new DsqCallback<Object>(null, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]), e);
            this.controller.getCallback().getPrescriptionDetail(niu_PRESCRIPTION_DM, context, callback);
        }
    }

    public void getMedicationDetail(NIU_OTHER_MEDICATION_DM niu_OTHER_MEDICATION_DM) {
        try {
            this.controller.getMedicationDetail(niu_OTHER_MEDICATION_DM);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            DsqCallback<Object> callback = new DsqCallback<Object>(null, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]), e);
            this.controller.getCallback().getMedicationDetail(niu_OTHER_MEDICATION_DM, callback);
        }
    }

    public void listSummaryCallback(QueryContinuationResult result) {
        this.controller.getCallback().listSummary(new DsqCallback<QueryContinuationResult>(result));
    }

    public void listSummary() {
        try {
            this.controller.listSummary();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            DsqCallback<Object> callback = new DsqCallback<Object>(null, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]), e);
            this.controller.getCallback().listSummary(callback);
        }
    }

    public void setAdministrationEffectiveStart(LocalDate date) {
        this.controller.setAdministrationEffectiveStart(date);
    }

    public void setAdministrationEffectiveEnd(LocalDate date) {
        this.controller.setAdministrationEffectiveEnd(date);
    }

    public void setAmendedInTimeStart(LocalDate date) {
        this.controller.setAmendedInTimeStart(date);
    }

    public void setAmendedInTimeEnd(LocalDate date) {
        this.controller.setAmendedInTimeEnd(date);
    }

    public void setOnlyThoseWithIssue(Boolean actif) {
        this.controller.setOnlyThoseWithIssue(Boolean.TRUE.equals(actif));
    }

    public LocalDate getAdministrationEffectiveStart() {
        return this.controller.getAdministrationEffectiveStart();
    }

    public LocalDate getAdministrationEffectiveEnd() {
        return this.controller.getAdministrationEffectiveEnd();
    }

    public LocalDate getAmendedInTimeStart() {
        return this.controller.getAmendedInTimeStart();
    }

    public LocalDate getAmendedInTimeEnd() {
        return this.controller.getAmendedInTimeEnd();
    }

    public boolean isOnlyThoseWithIssue() {
        return this.controller.isOnlyThoseWithIssue();
    }
}

