/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.gson.impl;

import ca.infodata.dsq.domain.College;
import ca.infodata.dsq.domain.NAM;
import ca.infodata.dsq.domain.NAS;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_COLLEGE;
import ca.infodata.dsq.domain.NIU_I;
import ca.infodata.dsq.domain.NIU_IPC;
import ca.infodata.dsq.domain.NIU_LDS;
import ca.infodata.dsq.domain.NIU_LDS_MSSS;
import ca.infodata.dsq.domain.NIU_LDS_RAMQ;
import ca.infodata.dsq.domain.NIU_LDS_RAMQ_FACTURATION;
import ca.infodata.dsq.domain.NIU_ODS;
import ca.infodata.dsq.domain.NIU_RAMQ;
import ca.infodata.dsq.domain.NIU_U;
import ca.infodata.dsq.domain.OtherNIU;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class NiuJsonTypeAdapter
extends TypeAdapter<NIU> {
    public void write(JsonWriter out, NIU value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.beginObject();
            out.name("oid");
            out.value(value.oid());
            out.name("value");
            out.value(value.value());
            out.endObject();
        }
    }

    public NIU read(JsonReader in) throws IOException {
        String oid = null;
        String value = null;
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if ("oid".equals(name)) {
                oid = in.nextString();
                continue;
            }
            if (!"value".equals(name)) continue;
            value = in.nextString();
        }
        in.endObject();
        return NiuJsonTypeAdapter.getNIU(oid, value, null);
    }

    public static NIU getNIU(String oid, String value, Class<? extends NIU> returnThisClassTypeOrNull) {
        if (oid == null || value == null) {
            return null;
        }
        if (oid.equals("2.16.124.10.101.1.60.100") && (returnThisClassTypeOrNull == null || NAM.class.equals(returnThisClassTypeOrNull))) {
            return new NAM(value);
        }
        if (oid.equals("2.16.840.1.113883.4.272") && (returnThisClassTypeOrNull == null || NAS.class.equals(returnThisClassTypeOrNull))) {
            return new NAS(value);
        }
        if ((oid.equals("2.16.840.1.113883.3.40.2.3") || oid.equals("2.16.840.1.113883.3.40.6.2") || oid.equals("2.16.840.1.113883.4.277")) && (returnThisClassTypeOrNull == null || NIU_I.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_I(value);
        }
        if (oid.equals("2.16.840.1.113883.4.273") && (returnThisClassTypeOrNull == null || NIU_LDS.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_LDS(value);
        }
        if ((oid.equals("2.16.840.1.113883.4.56") || oid.equals("2.16.124.10.101.1.60.4.1.10.5.5")) && (returnThisClassTypeOrNull == null || NIU_U.class.equals(returnThisClassTypeOrNull))) {
            return new OtherNIU(value, oid);
        }
        if (oid.equals("2.16.124.10.101.1.60.105") && (returnThisClassTypeOrNull == null || NIU_RAMQ.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_RAMQ(value);
        }
        if (oid.equals("2.16.840.1.113883.3.40.2.8") && (returnThisClassTypeOrNull == null || NIU_IPC.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_IPC(value);
        }
        if (oid.equals("2.16.840.1.113883.4.274") && (returnThisClassTypeOrNull == null || NIU_ODS.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_ODS(value);
        }
        if (oid.equals("2.16.124.10.101.1.60.101") && (returnThisClassTypeOrNull == null || NIU_LDS_MSSS.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_LDS_MSSS(value);
        }
        if (oid.equals("2.16.124.10.101.1.60.104") && (returnThisClassTypeOrNull == null || NIU_LDS_RAMQ.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_LDS_RAMQ(value);
        }
        if (oid.equals("2.16.124.10.101.1.60.103") && (returnThisClassTypeOrNull == null || NIU_LDS_RAMQ_FACTURATION.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_LDS_RAMQ_FACTURATION(value);
        }
        for (College college : College.values()) {
            if (!oid.equals(college.codeOID) || returnThisClassTypeOrNull != null && !NIU_COLLEGE.class.equals(returnThisClassTypeOrNull)) continue;
            return new NIU_COLLEGE(college, value);
        }
        if (returnThisClassTypeOrNull == null || OtherNIU.class.equals(returnThisClassTypeOrNull)) {
            return new OtherNIU(value, oid);
        }
        return null;
    }
}

