/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.gson.impl;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.apache.commons.lang3.math.NumberUtils;

public class EmptyStringToNumberTypeAdapter
extends TypeAdapter<Number> {
    public void write(JsonWriter jsonWriter, Number number) throws IOException {
        if (number == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.value(number);
    }

    public Number read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        try {
            String value = jsonReader.nextString();
            if ("".equals(value)) {
                return null;
            }
            return NumberUtils.createNumber((String)value);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }
}

