/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.unsubscribe.mqtt3;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImplBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.mqtt.message.unsubscribe.mqtt3.Mqtt3UnsubscribeView;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttTopicFilter;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3UnsubscribeBuilder;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class Mqtt3UnsubscribeViewBuilder<B extends Mqtt3UnsubscribeViewBuilder<B>> {
    private final @NotNull ImmutableList.Builder<MqttTopicFilterImpl> topicFiltersBuilder;

    Mqtt3UnsubscribeViewBuilder() {
        this.topicFiltersBuilder = ImmutableList.builder();
    }

    Mqtt3UnsubscribeViewBuilder(@NotNull Mqtt3UnsubscribeView unsubscribe) {
        List topicFilters = unsubscribe.getDelegate().getTopicFilters();
        this.topicFiltersBuilder = ImmutableList.builder(topicFilters.size() + 1);
        this.topicFiltersBuilder.addAll(topicFilters);
    }

    @NotNull
    abstract B self();

    @NotNull
    public B addTopicFilter(@Nullable String topicFilter) {
        this.topicFiltersBuilder.add(MqttTopicFilterImpl.of(topicFilter));
        return this.self();
    }

    @NotNull
    public B addTopicFilter(@Nullable MqttTopicFilter topicFilter) {
        this.topicFiltersBuilder.add(MqttChecks.topicFilter(topicFilter));
        return this.self();
    }

    public @NotNull MqttTopicFilterImplBuilder.Nested<B> addTopicFilter() {
        return new MqttTopicFilterImplBuilder.Nested<Mqtt3UnsubscribeViewBuilder>(this::addTopicFilter);
    }

    @NotNull
    public B addTopicFilters(MqttTopicFilter ... topicFilters) {
        Checks.notNull(topicFilters, "Topic Filters");
        this.topicFiltersBuilder.ensureFree(topicFilters.length);
        for (MqttTopicFilter topicFilter : topicFilters) {
            this.addTopicFilter(topicFilter);
        }
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    @NotNull
    public B addTopicFilters(@Nullable @Nullable Collection<@Nullable ? extends MqttTopicFilter> topicFilters) {
        Checks.notNull(topicFilters, "Topic Filters");
        this.topicFiltersBuilder.ensureFree(topicFilters.size());
        topicFilters.forEach(this::addTopicFilter);
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    @NotNull
    public B addTopicFilters(@Nullable @Nullable Stream<@Nullable ? extends MqttTopicFilter> topicFilters) {
        Checks.notNull(topicFilters, "Topic Filters");
        topicFilters.forEach(this::addTopicFilter);
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    @NotNull
    public B reverse(@Nullable Mqtt3Subscribe subscribe) {
        List subscriptions = MqttChecks.subscribe(subscribe).getSubscriptions();
        for (MqttSubscription subscription : subscriptions) {
            this.topicFiltersBuilder.add(subscription.getTopicFilter());
        }
        return this.self();
    }

    @NotNull
    public B topicFilter(@Nullable String topicFilter) {
        return this.addTopicFilter(topicFilter);
    }

    @NotNull
    public B topicFilter(@Nullable MqttTopicFilter topicFilter) {
        return this.addTopicFilter(topicFilter);
    }

    public @NotNull MqttTopicFilterImplBuilder.Nested<B> topicFilter() {
        return new MqttTopicFilterImplBuilder.Nested<Mqtt3UnsubscribeViewBuilder>(this::topicFilter);
    }

    private void ensureAtLeastOneSubscription() {
        Checks.state(this.topicFiltersBuilder.getSize() > 0, "At least one topic filter must be added.");
    }

    @NotNull
    public Mqtt3UnsubscribeView build() {
        this.ensureAtLeastOneSubscription();
        return Mqtt3UnsubscribeView.of(this.topicFiltersBuilder.build());
    }

    public static class SendVoid
    extends Mqtt3UnsubscribeViewBuilder<SendVoid>
    implements Mqtt3UnsubscribeBuilder.SendVoid.Complete,
    Mqtt3UnsubscribeBuilder.SendVoid.Start {
        @NotNull
        private final Consumer<? super Mqtt3UnsubscribeView> parentConsumer;

        public SendVoid(@NotNull Consumer<? super Mqtt3UnsubscribeView> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        SendVoid self() {
            return this;
        }

        @Override
        public void send() {
            this.parentConsumer.accept(this.build());
        }
    }

    public static class Send<P>
    extends Mqtt3UnsubscribeViewBuilder<Send<P>>
    implements Mqtt3UnsubscribeBuilder.Send.Complete<P>,
    Mqtt3UnsubscribeBuilder.Send.Start<P> {
        @NotNull
        private final Function<? super Mqtt3UnsubscribeView, P> parentConsumer;

        public Send(@NotNull Function<? super Mqtt3UnsubscribeView, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Send<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P send() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Nested<P>
    extends Mqtt3UnsubscribeViewBuilder<Nested<P>>
    implements Mqtt3UnsubscribeBuilder.Nested.Complete<P>,
    Mqtt3UnsubscribeBuilder.Nested.Start<P> {
        @NotNull
        private final Function<? super Mqtt3UnsubscribeView, P> parentConsumer;

        public Nested(@NotNull Function<? super Mqtt3UnsubscribeView, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyUnsubscribe() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends Mqtt3UnsubscribeViewBuilder<Default>
    implements Mqtt3UnsubscribeBuilder.Complete,
    Mqtt3UnsubscribeBuilder.Start {
        public Default() {
        }

        Default(@NotNull Mqtt3UnsubscribeView unsubscribe) {
            super(unsubscribe);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

