/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.subscribe.mqtt3;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscriptionViewBuilder;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.datatypes.MqttTopicFilter;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscription;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5RetainHandling;

public class Mqtt3SubscriptionView
implements Mqtt3Subscription {
    @NotNull
    private final MqttSubscription delegate;

    @NotNull
    private static MqttSubscription delegate(@NotNull MqttTopicFilterImpl topicFilter, @NotNull MqttQos qos) {
        return new MqttSubscription(topicFilter, qos, false, Mqtt5RetainHandling.SEND, false);
    }

    @NotNull
    static Mqtt3SubscriptionView of(@NotNull MqttTopicFilterImpl topicFilter, @NotNull MqttQos qos) {
        return new Mqtt3SubscriptionView(Mqtt3SubscriptionView.delegate(topicFilter, qos));
    }

    @NotNull
    static Mqtt3SubscriptionView of(@NotNull MqttSubscription delegate) {
        return new Mqtt3SubscriptionView(delegate);
    }

    private Mqtt3SubscriptionView(@NotNull MqttSubscription delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public MqttTopicFilter getTopicFilter() {
        return this.delegate.getTopicFilter();
    }

    @Override
    @NotNull
    public MqttQos getQos() {
        return this.delegate.getQos();
    }

    @NotNull
    public MqttSubscription getDelegate() {
        return this.delegate;
    }

    @Override
    public  @NotNull Mqtt3SubscriptionViewBuilder.Default extend() {
        return new Mqtt3SubscriptionViewBuilder.Default(this);
    }

    @NotNull
    private String toAttributeString() {
        return "topicFilter=" + this.getTopicFilter() + ", qos=" + (Object)((Object)this.getQos());
    }

    @NotNull
    public String toString() {
        return "MqttSubscription{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mqtt3SubscriptionView)) {
            return false;
        }
        Mqtt3SubscriptionView that = (Mqtt3SubscriptionView)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

