/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.log;

public class LogUtil {
    public static String getPrintedStackTrace(Exception e) {
        return LogUtil.getPrintedStackTrace(e, null, 1, Integer.MAX_VALUE);
    }

    public static String getPrintedStackTrace(Exception e, int offsetLevel, int deepLevel) {
        return LogUtil.getPrintedStackTrace(e, null, 1 + offsetLevel, deepLevel);
    }

    public static String getPrintedStackTrace() {
        return LogUtil.getPrintedStackTrace(new Exception(), null, 1, Integer.MAX_VALUE);
    }

    public static String getPrintedStackTrace(int offsetLevel, int deepLevel) {
        return LogUtil.getPrintedStackTrace(new Exception(), null, 1 + offsetLevel, deepLevel);
    }

    private static String getPrintedStackTrace(Exception e, String title, int offsetLevel, int deepLevel) {
        StackTraceElement[] elements = e.getStackTrace();
        StringBuilder b = new StringBuilder(1000);
        if (title != null) {
            b.append(title);
            b.append("\n");
        }
        b.append(e.getMessage());
        b.append("\n");
        double deepLevel2 = (double)deepLevel + 2.0 + (double)offsetLevel;
        deepLevel = (int)Math.min(2.147483647E9, deepLevel2);
        for (int i = 1 + offsetLevel; i < elements.length && i < deepLevel; ++i) {
            b.append("\tat " + elements[i]);
            b.append("\n");
        }
        return b.toString();
    }

    public static void printStackTrace() {
        System.out.println(LogUtil.getPrintedStackTrace(new Exception(), null, 1, Integer.MAX_VALUE));
    }

    public static void printStackTrace(String title, int deepLevel) {
        System.out.println(LogUtil.getPrintedStackTrace(new Exception(), title, 1, deepLevel));
    }

    public static void printStackTrace(String title, int offsetLevel, int deepLevel) {
        System.out.println(LogUtil.getPrintedStackTrace(new Exception(), title, 1 + offsetLevel, deepLevel));
    }
}

