/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import java.util.ArrayList;
import java.util.List;

public class IntArrayList {
    private static final int DEFAULT_CAPACITY = 16;
    private int[] array;
    private int size = 0;

    public IntArrayList() {
        this(16);
    }

    public IntArrayList(int capacity) {
        this.array = new int[capacity];
    }

    public int set(int index, int value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index : " + index);
        }
        int old = this.array[index];
        this.array[index] = value;
        return old;
    }

    public void add(int value) {
        this.ensureCapacity(this.size + 1);
        this.array[this.size] = value;
        ++this.size;
    }

    public int get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index : " + index);
        }
        return this.array[index];
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.array.length) {
            int newCap = Math.max(this.array.length << 1, capacity);
            int[] tmp = new int[newCap];
            System.arraycopy(this.array, 0, tmp, 0, this.array.length);
            this.array = tmp;
        }
    }

    public boolean contains(int i) {
        return this.indexOf(i) != -1;
    }

    public int indexOf(int i) {
        for (int j = 0; j < this.array.length; ++j) {
            if (this.array[j] != i) continue;
            return j;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        int iMax = this.size - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.array[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public int[] toArray() {
        int[] result = new int[this.size];
        System.arraycopy(this.array, 0, result, 0, this.size);
        return result;
    }

    public List<Integer> toList() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.size);
        for (int i = 0; i < this.size; ++i) {
            list.add(this.array[i]);
        }
        return list;
    }

    public void addAll(int[] array) {
        this.ensureCapacity(this.size + array.length);
        for (int i = 0; i < array.length; ++i) {
            this.array[this.size] = array[i];
            ++this.size;
        }
    }
}

