/*
 * Decompiled with CFR 0.152.
 */
package parser;

import ca.infodata.readhl7.MessageHandler;
import ca.infodata.readhl7.UtilDateUtilities;
import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v24.datatype.XCN;
import ca.uhn.hl7v2.model.v24.message.ORU_R01;
import ca.uhn.hl7v2.parser.CanonicalModelClassFactory;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class ORU_R01v24Handler
implements MessageHandler {
    private final boolean isTest = false;
    ORU_R01 msg = null;
    Logger logger = Logger.getLogger(ORU_R01v24Handler.class.getName());

    @Override
    public void init(String hl7Body) throws HL7Exception {
        DefaultHapiContext context = new DefaultHapiContext();
        CanonicalModelClassFactory mcf = new CanonicalModelClassFactory("2.4");
        context.setModelClassFactory(mcf);
        PipeParser p = context.getPipeParser();
        p.getParserConfiguration().setValidating(false);
        this.msg = (ORU_R01)p.parse(hl7Body);
        try {
            context.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getMsgType() {
        return "ORU_R01";
    }

    @Override
    public String getMsgDate() {
        try {
            return this.formatDateTime(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getObservationDateTime().getTimeOfAnEvent().getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not retrieve message date", e);
            return "";
        }
    }

    @Override
    public String getMsgPriority() {
        return "";
    }

    @Override
    public int getOBRCount() {
        return this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
    }

    @Override
    public int getOBXCount(int i) {
        try {
            return this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATIONReps();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getOBRName(int i) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getUniversalServiceIdentifier().getText().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getTimeStamp(int i, int j) {
        try {
            String status = "";
            try {
                status = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationResultStatus().getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (status.equalsIgnoreCase("I")) {
                return "";
            }
            return this.formatDateTime(this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getObr7_ObservationDateTime().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean isOBXAbnormal(int i, int j) {
        try {
            return this.getOBXAbnormalFlag(i, j).equals("A");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getOBXAbnormalFlag(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getAbnormalFlags().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getObservationHeader(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getDiagnosticServSectID().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXIdentifier(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXValueType(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getValueType().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXName(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getText().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResult(int i, int j) {
        String result = "";
        try {
            StringBuilder sb = new StringBuilder();
            int m = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationValue().length;
            for (int k = 0; k < m; ++k) {
                String s = Terser.get(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, k, 1, 1);
                String ss = Terser.get(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, k, 2, 1);
                if (ss != null) {
                    s = ss;
                }
                if (s == null) continue;
                sb.append(sb.length() == 0 ? s : "\n" + s);
            }
            result = sb.toString();
        }
        catch (Exception e) {
            return "";
        }
        return result;
    }

    @Override
    public String getOBXReferenceRange(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getReferencesRange().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXUnits(int i, int j) {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getUnits().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResultStatus(int i, int j) {
        String status = "";
        try {
            status = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationResultStatus().getValue());
            if (status.equalsIgnoreCase("I")) {
                status = "Attente";
            } else if (status.equalsIgnoreCase("F")) {
                status = "Final";
            } else if (status.equalsIgnoreCase("C")) {
                status = "Comm.";
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx result status", e);
            return status;
        }
        return status;
    }

    @Override
    public int getOBXFinalResultCount() {
        int obrCount = this.getOBRCount();
        int count = 0;
        for (int i = 0; i < obrCount; ++i) {
            int obxCount = this.getOBXCount(i);
            for (int j = 0; j < obxCount; ++j) {
                if (!this.getOBXResultStatus(i, j).equals("Final")) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        try {
            for (int i = 0; i < this.msg.getPATIENT_RESULT().getORDER_OBSERVATIONReps(); ++i) {
                String currentHeader = this.getObservationHeader(i, 0);
                int arraySize = headers.size();
                if (arraySize != 0 && currentHeader.equals(headers.get(arraySize - 1))) continue;
                headers.add(currentHeader);
            }
            return headers;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not create header list", e);
            return null;
        }
    }

    @Override
    public int getOBRCommentCount(int i) {
        try {
            return this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getNTEReps();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getOBRComment(int i, int j) {
        try {
            int m = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getNTE(j).getComment().length;
            StringBuilder sb = new StringBuilder();
            for (int l = 0; l < m; ++l) {
                String s = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getNTE(j).getComment(l).getValue());
                sb.append(sb.length() == 0 ? s : "\n" + s);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public int getOBXCommentCount(int i, int j) {
        int count = 0;
        try {
            String comment;
            count = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTEReps();
            if (count == 1 && (comment = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE().getComment(0).getValue()) == null) {
                count = 0;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx comment count", e);
        }
        return count;
    }

    @Override
    public String getOBXComment(int i, int j, int k) {
        try {
            int m = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE(k).getComment().length;
            StringBuilder sb = new StringBuilder();
            for (int l = 0; l < m; ++l) {
                String s = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE(k).getComment(l).getValue());
                sb.append(sb.length() == 0 ? s : "\n" + s);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getPatientName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    @Override
    public String getFirstName() {
        this.getClass();
        return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientName(0).getGivenName().getValue());
    }

    @Override
    public String getLastName() {
        this.getClass();
        return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPatientName(0).getFamilyName().getSurname().getValue());
    }

    @Override
    public String getDOB() {
        try {
            return this.formatDateTime(this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getDateTimeOfBirth().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getAge() {
        String age = "N/A";
        String dob = this.getDOB();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date date = formatter.parse(dob);
            String serviceD = this.getServiceDate();
            Date serviceDate = null;
            if (serviceD != null && (serviceDate = UtilDateUtilities.StringToDate(serviceD)) == null) {
                serviceDate = UtilDateUtilities.getDateFromString(serviceD, "yyyy-MM-dd");
            }
            age = UtilDateUtilities.calcAgeAtDate(date, serviceDate);
        }
        catch (ParseException e) {
            this.logger.log(Level.SEVERE, "Could not get age", e);
        }
        return age;
    }

    @Override
    public String getSex() {
        return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getAdministrativeSex().getValue());
    }

    @Override
    public String getHealthNum() {
        return this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPid4_AlternatePatientIDPID(0).getID().getValue());
    }

    @Override
    public String getFileNum() {
        return "";
    }

    @Override
    public String getHomePhone() {
        String phone = "";
        try {
            for (int i = 0; i < 5 && !this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue()).equals(""); ++i) {
                phone = i == 0 ? this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue()) : phone + ", " + this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue());
            }
            return phone;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return phone number", e);
            return "";
        }
    }

    @Override
    public String getWorkPhone() {
        String phone = "";
        try {
            for (int i = 0; i < 5 && !this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue()).equals(""); ++i) {
                phone = i == 0 ? this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue()) : phone + ", " + this.getString(this.msg.getPATIENT_RESULT().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue());
            }
            return phone;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return phone number", e);
            return "";
        }
    }

    @Override
    public String getPatientLocation() {
        return this.getString(this.msg.getMSH().getSendingFacility().getNamespaceID().getValue()) + " " + this.getString(this.msg.getMSH().getSendingFacility().getUniversalID().getValue());
    }

    @Override
    public String getServiceDate() {
        try {
            return this.formatDateTime(this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getDateTimeOfTransaction().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOrderStatus() {
        try {
            return this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrderStatus().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getClientRef() {
        String docNum = "";
        try {
            for (int i = 0; i < 5 && !this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i).getIDNumber().getValue()).equals(""); ++i) {
                docNum = i == 0 ? this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i).getIDNumber().getValue()) : docNum + ", " + this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i).getIDNumber().getValue());
            }
            return docNum;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor id numbers", e);
            return "";
        }
    }

    @Override
    public String getAccessionNum() {
        String accessionNum = "";
        try {
            accessionNum = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getPlacerOrderNumber().getEntityIdentifier().getValue());
            String fillOrder = this.getString(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getFillerOrderNumber().getEntityIdentifier().getValue());
            if (StringUtils.isNotEmpty(fillOrder) && !accessionNum.equals(fillOrder)) {
                accessionNum = accessionNum + ", " + fillOrder;
            }
            return accessionNum;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return accession number", e);
            return "";
        }
    }

    @Override
    public String getDocName() {
        String docName = "";
        int i = 0;
        try {
            if (this.msg != null && this.msg.getPATIENT_RESULT() != null && this.msg.getPATIENT_RESULT().getORDER_OBSERVATION() != null && this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR() != null) {
                while (this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i) != null && !this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(i)).equals("")) {
                    String temp = this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(i).getOBR().getOrderingProvider(0));
                    if (i == 0) {
                        docName = temp;
                    } else if (docName.indexOf(temp) == -1) {
                        docName = docName + ", " + temp;
                    }
                    ++i;
                }
            }
            return docName;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor names", e);
            return docName;
        }
    }

    @Override
    public String getCCDocs() {
        String docName = "";
        try {
            for (int i = 0; i < 10 && !this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i)).equals(""); ++i) {
                String temp = this.getFullDocName(this.msg.getPATIENT_RESULT().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i));
                if (i == 0) {
                    docName = temp;
                    continue;
                }
                if (docName.indexOf(temp) != -1) continue;
                docName = docName + ", " + temp;
            }
            return docName;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return cc'ed doctors", e);
            return docName;
        }
    }

    @Override
    public ArrayList<String> getDocNums() {
        ArrayList<String> docNums = new ArrayList<String>();
        try {
            String id;
            String providerId = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getOrderingProvider(0).getIDNumber().getValue();
            docNums.add(providerId);
            for (int i = 0; i < 10 && (id = this.msg.getPATIENT_RESULT().getORDER_OBSERVATION().getOBR().getResultCopiesTo(i).getIDNumber().getValue()) != null; ++i) {
                if (docNums.contains(id)) continue;
                docNums.add(id);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor nums", e);
        }
        return docNums;
    }

    @Override
    public String audit() {
        return "";
    }

    private String getFullDocName(XCN docSeg) {
        String docName = "";
        if (docSeg.getGivenName().getValue() != null) {
            docName = docName.equals("") ? docSeg.getGivenName().getValue() : docName + " " + docSeg.getGivenName().getValue();
        }
        if (docSeg.getSecondAndFurtherGivenNamesOrInitialsThereof().getValue() != null) {
            docName = docName.equals("") ? docSeg.getSecondAndFurtherGivenNamesOrInitialsThereof().getValue() : docName + " " + docSeg.getSecondAndFurtherGivenNamesOrInitialsThereof().getValue();
        }
        if (docSeg.getFamilyName().getSurname() != null) {
            docName = docName.equals("") ? docSeg.getFamilyName().getSurname().getValue() : docName + " " + docSeg.getFamilyName().getSurname().getValue();
        }
        if (docSeg.getSuffixEgJRorIII().getValue() != null) {
            docName = docName.equals("") ? docSeg.getSuffixEgJRorIII().getValue() : docName + " " + docSeg.getSuffixEgJRorIII().getValue();
        }
        if (docSeg.getDegreeEgMD().getValue() != null) {
            docName = docName.equals("") ? docSeg.getDegreeEgMD().getValue() : docName + " " + docSeg.getDegreeEgMD().getValue();
        }
        return docName;
    }

    private String formatDateTime(String plain) {
        String dateFormat = "yyyyMMddHHmmss";
        dateFormat = dateFormat.substring(0, plain.length());
        String stringFormat = "yyyy-MM-dd HH:mm:ss";
        stringFormat = stringFormat.substring(0, stringFormat.lastIndexOf(dateFormat.charAt(dateFormat.length() - 1)) + 1);
        Date date = UtilDateUtilities.StringToDate(plain, dateFormat);
        return UtilDateUtilities.DateToString(date, stringFormat);
    }

    private String getString(String retrieve) {
        if (retrieve != null) {
            retrieve.replaceAll("^", " ");
            return retrieve.trim();
        }
        return "";
    }

    @Override
    public String getPrelDate() {
        return null;
    }

    @Override
    public String getOBRSpecimen(int i) {
        return null;
    }

    @Override
    public String getOBXEquipment(int i, int j) {
        return null;
    }

    @Override
    public String getOBXUserCheck(int i, int j) {
        return null;
    }

    @Override
    public String getSpecimenName(int j) {
        return null;
    }

    @Override
    public String[] getDspLines() {
        return null;
    }

    @Override
    public String getPdfFromObx55(int j) {
        return null;
    }

    @Override
    public String getPerformingOrganisation(int i, int j) {
        return null;
    }

    @Override
    public String getOBXLoincIdentifier(int i, int j) {
        return null;
    }
}

