/*
 * Decompiled with CFR 0.152.
 */
package parser;

import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.util.Terser;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import parser.DefaultGenericHandler;

public class IHAHandler
extends DefaultGenericHandler {
    Logger logger = Logger.getLogger(IHAHandler.class.getName());
    List<String> headerList = null;

    @Override
    public String getMsgType() {
        return "IHA";
    }

    @Override
    public List<String> getHeaders() {
        this.headerList = new ArrayList<String>();
        for (int i = 0; i < this.getOBRCount(); ++i) {
            this.headerList.add(this.getOBRName(i));
            this.logger.log(Level.FINE, "ADDING to header " + this.getOBRName(i));
        }
        return this.headerList;
    }

    @Override
    public String getObservationHeader(int i, int j) {
        return this.headerList.get(i);
    }

    @Override
    public String getOBRName(int i) {
        ++i;
        try {
            String obrName;
            if (i == 1) {
                obrName = this.getString(this.terser.get("/.OBR-4-1"));
                if (obrName.equals("")) {
                    obrName = this.getString(this.terser.get("/.OBR-4-2"));
                }
            } else {
                Segment obrSeg = (Segment)this.terser.getFinder().getRoot().get("OBR" + i);
                obrName = this.getString(Terser.get(obrSeg, 4, 0, 1, 1));
                if (obrName.equals("")) {
                    obrName = this.getString(Terser.get(obrSeg, 4, 0, 2, 1));
                }
            }
            return obrName;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXReferenceRange(int i, int j) {
        return this.getOBXField(i, j, 7, 0, 3);
    }

    @Override
    public String getOrderStatus() {
        String ret = "";
        try {
            String stat = this.getString(this.terser.get("/.ORC-6-1"));
            if (stat == null) {
                return "";
            }
            if (stat.equals("A")) {
                ret = "partial";
            } else if (stat.equals("CA")) {
                ret = "cancelled";
            } else if (stat.equals("CM")) {
                ret = "final";
            }
        }
        catch (Exception e) {
            return "";
        }
        return ret;
    }
}

