/*
 * Decompiled with CFR 0.152.
 */
package org.ga.log.ro;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ga.log.ro.RolloverStrategy;

class TimeOfDayRolloverStrategy
implements RolloverStrategy {
    private static final String KEY_ROLLOVER_TIME = "simplelog.rollover.timeOfDay.time";
    private static final String ROLLOVER_TIME_DEFAULT = "0:00";
    private static final String KEY_TIMEZONE = "simplelog.rollover.timeOfDay.timezone";
    private TimeZone timeZone;
    private int hour;
    private int minute;
    private boolean timeSetProgramatically = false;

    TimeOfDayRolloverStrategy() {
        this.timeZone = null;
        this.hour = -1;
        this.minute = -1;
    }

    public TimeOfDayRolloverStrategy(TimeZone timeZone, int hour, int minute) {
        this.setRolloverTime(timeZone, hour, minute);
    }

    @Override
    public void configure(Map<?, ?> properties) throws IOException {
        TimeZone timeZone;
        Pattern pattern;
        Matcher matcher;
        if (this.timeSetProgramatically) {
            return;
        }
        String rolloverTime = (String)properties.get(KEY_ROLLOVER_TIME);
        if (rolloverTime == null) {
            rolloverTime = ROLLOVER_TIME_DEFAULT;
        }
        if ((rolloverTime = rolloverTime.trim()).length() == 0) {
            rolloverTime = ROLLOVER_TIME_DEFAULT;
        }
        if (!(matcher = (pattern = Pattern.compile("([01]?\\d|2[0123]):([0-5]\\d)")).matcher(rolloverTime)).matches()) {
            throw new IOException("The specified rollover time does not conform to the required pattern: " + rolloverTime);
        }
        String hourString = matcher.group(1);
        String minuteString = matcher.group(2);
        int hour = Integer.parseInt(hourString);
        int minute = Integer.parseInt(minuteString);
        String timezoneString = (String)properties.get(KEY_TIMEZONE);
        if (timezoneString != null) {
            timeZone = TimeZone.getTimeZone(timezoneString);
            if (timeZone.getID().equals("GMT") && !timezoneString.equals("GMT")) {
                throw new IOException("A TimeZone with the specified ID could not be created.");
            }
        } else {
            timeZone = TimeZone.getDefault();
        }
        this.setRolloverTimeInternal(timeZone, hour, minute);
    }

    public void setRolloverTime(TimeZone timeZone, int hour, int minute) {
        this.setRolloverTimeInternal(timeZone, hour, minute);
        this.timeSetProgramatically = true;
    }

    private void setRolloverTimeInternal(TimeZone timeZone, int hour, int minute) {
        if (timeZone == null) {
            throw new IllegalArgumentException("timeZone cannot be null.");
        }
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("hour must be between 0 and 23, inclusive.");
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("minute must be between 0 and 59, inclusive.");
        }
        this.timeZone = timeZone;
        this.hour = hour;
        this.minute = minute;
    }

    @Override
    public boolean rolloverNow(Date fileCreated, long fileLength) {
        if (this.timeZone == null) {
            throw new IllegalStateException("TimeOfDayRolloverStrategy has not been configured.");
        }
        Calendar rolloverCalendar = Calendar.getInstance(this.timeZone);
        rolloverCalendar.setTime(fileCreated);
        rolloverCalendar.set(11, this.hour);
        rolloverCalendar.set(12, this.minute);
        rolloverCalendar.set(13, 0);
        rolloverCalendar.set(14, 0);
        long nextRolloverTime = rolloverCalendar.getTime().getTime();
        while (nextRolloverTime <= fileCreated.getTime()) {
            int day = rolloverCalendar.get(5);
            rolloverCalendar.set(5, day + 1);
            nextRolloverTime = rolloverCalendar.getTime().getTime();
        }
        long now = System.currentTimeMillis();
        return now >= nextRolloverTime;
    }
}

