/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.parser.IStructureDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class StructureDefinition
implements IStructureDefinition {
    private HashSet<String> myAllChildrenNames;
    private HashSet<String> myAllFirstLeafNames;
    private ArrayList<StructureDefinition> myChildren = new ArrayList();
    private IStructureDefinition myFirstSibling;
    private boolean myFirstSiblingIsSet;
    private Boolean myIsFinalChildOfParent;
    private boolean myIsRepeating;
    private boolean myIsRequired;
    private boolean myIsSegment;
    private String myName;
    private String myNameAsItAppearsInParent;
    private Set<String> myNamesOfAllPossibleFollowingLeaves;
    private IStructureDefinition myNextLeaf;
    private IStructureDefinition myNextSibling;
    private IStructureDefinition myParent;
    private int myPosition;
    private boolean myChoiceElement;

    void addChild(StructureDefinition theChild) {
        this.myChildren.add(theChild);
    }

    public boolean equals(Object theObj) {
        if (theObj == null || !(theObj instanceof StructureDefinition)) {
            return false;
        }
        StructureDefinition o = (StructureDefinition)theObj;
        return o.myName.equals(this.myName) && o.myPosition == this.myPosition;
    }

    public HashSet<String> getAllChildNames() {
        if (this.myAllChildrenNames == null) {
            this.myAllChildrenNames = new HashSet();
            for (IStructureDefinition iStructureDefinition : this.myChildren) {
                this.myAllChildrenNames.add(iStructureDefinition.getName());
                this.myAllChildrenNames.addAll(iStructureDefinition.getAllChildNames());
            }
        }
        return this.myAllChildrenNames;
    }

    public HashSet<String> getAllPossibleFirstChildren() {
        if (this.myAllFirstLeafNames == null) {
            this.myAllFirstLeafNames = new HashSet();
            boolean hasChoice = false;
            for (IStructureDefinition iStructureDefinition : this.myChildren) {
                this.myAllFirstLeafNames.addAll(iStructureDefinition.getAllPossibleFirstChildren());
                if (iStructureDefinition.isChoiceElement()) {
                    hasChoice = true;
                    continue;
                }
                if (!hasChoice && !iStructureDefinition.isRequired()) continue;
                break;
            }
            this.myAllFirstLeafNames.add(this.getName());
        }
        return this.myAllFirstLeafNames;
    }

    public ArrayList<StructureDefinition> getChildren() {
        return this.myChildren;
    }

    @Override
    public IStructureDefinition getFirstChild() {
        return this.myChildren.get(0);
    }

    @Override
    public IStructureDefinition getFirstSibling() {
        if (!this.myFirstSiblingIsSet) {
            this.myFirstSibling = this.myParent == null ? null : (this.myParent.getChildren().get(0) == this ? null : (IStructureDefinition)this.myParent.getChildren().get(0));
            this.myFirstSiblingIsSet = true;
        }
        return this.myFirstSibling;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getNameAsItAppearsInParent() {
        return this.myNameAsItAppearsInParent;
    }

    @Override
    public Set<String> getNamesOfAllPossibleFollowingLeaves() {
        if (this.myNamesOfAllPossibleFollowingLeaves != null) {
            return this.myNamesOfAllPossibleFollowingLeaves;
        }
        this.myNamesOfAllPossibleFollowingLeaves = new HashSet<String>();
        IStructureDefinition nextLeaf = this.getNextLeaf();
        if (nextLeaf != null) {
            this.myNamesOfAllPossibleFollowingLeaves.add(nextLeaf.getName());
            this.myNamesOfAllPossibleFollowingLeaves.addAll(nextLeaf.getNamesOfAllPossibleFollowingLeaves());
        }
        for (IStructureDefinition parent = this.myParent; parent != null; parent = parent.getParent()) {
            if (!parent.isRepeating()) continue;
            this.myNamesOfAllPossibleFollowingLeaves.addAll(parent.getAllPossibleFirstChildren());
        }
        return this.myNamesOfAllPossibleFollowingLeaves;
    }

    @Override
    public IStructureDefinition getNextLeaf() {
        return this.myNextLeaf;
    }

    @Override
    public IStructureDefinition getNextSibling() {
        if (this.myNextSibling != null) {
            return this.myNextSibling;
        }
        if (this.isFinalChildOfParent()) {
            throw new IllegalStateException("Final child");
        }
        this.myNextSibling = this.myParent.getChildren().get(this.myPosition + 1);
        return this.myNextSibling;
    }

    @Override
    public IStructureDefinition getParent() {
        return this.myParent;
    }

    @Override
    public int getPosition() {
        return this.myPosition;
    }

    @Override
    public boolean hasChildren() {
        return !this.myChildren.isEmpty();
    }

    public int hashCode() {
        return 17 * this.myName.hashCode() * this.myPosition;
    }

    @Override
    public boolean isFinalChildOfParent() {
        if (this.myIsFinalChildOfParent != null) {
            return this.myIsFinalChildOfParent;
        }
        this.myIsFinalChildOfParent = this.myParent == null || this.myPosition == this.myParent.getChildren().size() - 1;
        return this.myIsFinalChildOfParent;
    }

    @Override
    public boolean isRepeating() {
        return this.myIsRepeating;
    }

    @Override
    public boolean isRequired() {
        return this.myIsRequired;
    }

    @Override
    public boolean isSegment() {
        return this.myIsSegment;
    }

    void setName(String theName) {
        this.myName = theName;
    }

    void setNameAsItAppearsInParent(String theName) {
        this.myNameAsItAppearsInParent = theName;
    }

    void setNextLeaf(IStructureDefinition theNextLeaf) {
        this.myNextLeaf = theNextLeaf;
    }

    void setParent(IStructureDefinition theParent) {
        this.myParent = theParent;
    }

    void setPosition(int thePosition) {
        this.myPosition = thePosition;
    }

    void setRepeating(boolean theIsRepeating) {
        this.myIsRepeating = theIsRepeating;
    }

    void setRequired(boolean theIsRequired) {
        this.myIsRequired = theIsRequired;
    }

    void setSegment(boolean theIsSegment) {
        this.myIsSegment = theIsSegment;
    }

    public String toString() {
        return "StructureDefinition[" + this.getName() + "]";
    }

    public void setChoiceElement(boolean theChoiceElement) {
        this.myChoiceElement = theChoiceElement;
    }

    @Override
    public boolean isChoiceElement() {
        return this.myChoiceElement;
    }
}

