/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RFI
extends AbstractSegment {
    public RFI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Request Date");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Response Due Date");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Patient Consent");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Date Additional Information Was Submitted");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RFI - this is probably a bug in the source code generator.", e);
        }
    }

    public DTM getRequestDate() {
        DTM retVal = (DTM)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getRfi1_RequestDate() {
        DTM retVal = (DTM)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getResponseDueDate() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getRfi2_ResponseDueDate() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getPatientConsent() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getRfi3_PatientConsent() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getDateAdditionalInformationWasSubmitted() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getRfi4_DateAdditionalInformationWasSubmitted() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new DTM(this.getMessage());
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 3: {
                return new DTM(this.getMessage());
            }
        }
        return null;
    }
}

