/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.MOP;
import ca.uhn.hl7v2.model.v28.datatype.ST;

public class RMC
extends AbstractComposite {
    private Type[] data;

    public RMC(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[4];
        this.data[0] = new CWE(this.getMessage());
        this.data[1] = new CWE(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new MOP(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CWE getRoomType() {
        return this.getTyped(0, CWE.class);
    }

    public CWE getRmc1_RoomType() {
        return this.getTyped(0, CWE.class);
    }

    public CWE getAmountType() {
        return this.getTyped(1, CWE.class);
    }

    public CWE getRmc2_AmountType() {
        return this.getTyped(1, CWE.class);
    }

    public ST getCoverageAmount() {
        return this.getTyped(2, ST.class);
    }

    public ST getRmc3_CoverageAmount() {
        return this.getTyped(2, ST.class);
    }

    public MOP getMoneyOrPercentage() {
        return this.getTyped(3, MOP.class);
    }

    public MOP getRmc4_MoneyOrPercentage() {
        return this.getTyped(3, MOP.class);
    }
}

