/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v27.group.CCU_I20_APPOINTMENT_HISTORY;
import ca.uhn.hl7v2.model.v27.group.CCU_I20_CLINICAL_HISTORY;
import ca.uhn.hl7v2.model.v27.group.CCU_I20_GOAL;
import ca.uhn.hl7v2.model.v27.group.CCU_I20_INSURANCE;
import ca.uhn.hl7v2.model.v27.group.CCU_I20_MEDICATION_HISTORY;
import ca.uhn.hl7v2.model.v27.group.CCU_I20_PATHWAY;
import ca.uhn.hl7v2.model.v27.group.CCU_I20_PATIENT;
import ca.uhn.hl7v2.model.v27.group.CCU_I20_PATIENT_VISITS;
import ca.uhn.hl7v2.model.v27.group.CCU_I20_PROBLEM;
import ca.uhn.hl7v2.model.v27.group.CCU_I20_PROVIDER_CONTACT;
import ca.uhn.hl7v2.model.v27.segment.MSH;
import ca.uhn.hl7v2.model.v27.segment.NK1;
import ca.uhn.hl7v2.model.v27.segment.REL;
import ca.uhn.hl7v2.model.v27.segment.RF1;
import ca.uhn.hl7v2.model.v27.segment.SFT;
import ca.uhn.hl7v2.model.v27.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCU_I20
extends AbstractMessage {
    public CCU_I20() {
        this(new DefaultModelClassFactory());
    }

    public CCU_I20(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(RF1.class, true, false);
            this.add(CCU_I20_PROVIDER_CONTACT.class, false, true);
            this.add(CCU_I20_PATIENT.class, false, true);
            this.add(NK1.class, false, true);
            this.add(CCU_I20_INSURANCE.class, false, true);
            this.add(CCU_I20_APPOINTMENT_HISTORY.class, false, true);
            this.add(CCU_I20_CLINICAL_HISTORY.class, false, true);
            this.add(CCU_I20_PATIENT_VISITS.class, true, true);
            this.add(CCU_I20_MEDICATION_HISTORY.class, false, true);
            this.add(CCU_I20_PROBLEM.class, false, true);
            this.add(CCU_I20_GOAL.class, false, true);
            this.add(CCU_I20_PATHWAY.class, false, true);
            this.add(REL.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCU_I20 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.7";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public RF1 getRF1() {
        return this.getTyped("RF1", RF1.class);
    }

    public CCU_I20_PROVIDER_CONTACT getPROVIDER_CONTACT() {
        return this.getTyped("PROVIDER_CONTACT", CCU_I20_PROVIDER_CONTACT.class);
    }

    public CCU_I20_PROVIDER_CONTACT getPROVIDER_CONTACT(int rep) {
        return this.getTyped("PROVIDER_CONTACT", rep, CCU_I20_PROVIDER_CONTACT.class);
    }

    public int getPROVIDER_CONTACTReps() {
        return this.getReps("PROVIDER_CONTACT");
    }

    public List<CCU_I20_PROVIDER_CONTACT> getPROVIDER_CONTACTAll() throws HL7Exception {
        return this.getAllAsList("PROVIDER_CONTACT", CCU_I20_PROVIDER_CONTACT.class);
    }

    public void insertPROVIDER_CONTACT(CCU_I20_PROVIDER_CONTACT structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER_CONTACT", structure, rep);
    }

    public CCU_I20_PROVIDER_CONTACT insertPROVIDER_CONTACT(int rep) throws HL7Exception {
        return (CCU_I20_PROVIDER_CONTACT)super.insertRepetition("PROVIDER_CONTACT", rep);
    }

    public CCU_I20_PROVIDER_CONTACT removePROVIDER_CONTACT(int rep) throws HL7Exception {
        return (CCU_I20_PROVIDER_CONTACT)super.removeRepetition("PROVIDER_CONTACT", rep);
    }

    public CCU_I20_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", CCU_I20_PATIENT.class);
    }

    public CCU_I20_PATIENT getPATIENT(int rep) {
        return this.getTyped("PATIENT", rep, CCU_I20_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<CCU_I20_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", CCU_I20_PATIENT.class);
    }

    public void insertPATIENT(CCU_I20_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", structure, rep);
    }

    public CCU_I20_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (CCU_I20_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public CCU_I20_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (CCU_I20_PATIENT)super.removeRepetition("PATIENT", rep);
    }

    public NK1 getNK1() {
        return this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public CCU_I20_INSURANCE getINSURANCE() {
        return this.getTyped("INSURANCE", CCU_I20_INSURANCE.class);
    }

    public CCU_I20_INSURANCE getINSURANCE(int rep) {
        return this.getTyped("INSURANCE", rep, CCU_I20_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<CCU_I20_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", CCU_I20_INSURANCE.class);
    }

    public void insertINSURANCE(CCU_I20_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public CCU_I20_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (CCU_I20_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public CCU_I20_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (CCU_I20_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public CCU_I20_APPOINTMENT_HISTORY getAPPOINTMENT_HISTORY() {
        return this.getTyped("APPOINTMENT_HISTORY", CCU_I20_APPOINTMENT_HISTORY.class);
    }

    public CCU_I20_APPOINTMENT_HISTORY getAPPOINTMENT_HISTORY(int rep) {
        return this.getTyped("APPOINTMENT_HISTORY", rep, CCU_I20_APPOINTMENT_HISTORY.class);
    }

    public int getAPPOINTMENT_HISTORYReps() {
        return this.getReps("APPOINTMENT_HISTORY");
    }

    public List<CCU_I20_APPOINTMENT_HISTORY> getAPPOINTMENT_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("APPOINTMENT_HISTORY", CCU_I20_APPOINTMENT_HISTORY.class);
    }

    public void insertAPPOINTMENT_HISTORY(CCU_I20_APPOINTMENT_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("APPOINTMENT_HISTORY", structure, rep);
    }

    public CCU_I20_APPOINTMENT_HISTORY insertAPPOINTMENT_HISTORY(int rep) throws HL7Exception {
        return (CCU_I20_APPOINTMENT_HISTORY)super.insertRepetition("APPOINTMENT_HISTORY", rep);
    }

    public CCU_I20_APPOINTMENT_HISTORY removeAPPOINTMENT_HISTORY(int rep) throws HL7Exception {
        return (CCU_I20_APPOINTMENT_HISTORY)super.removeRepetition("APPOINTMENT_HISTORY", rep);
    }

    public CCU_I20_CLINICAL_HISTORY getCLINICAL_HISTORY() {
        return this.getTyped("CLINICAL_HISTORY", CCU_I20_CLINICAL_HISTORY.class);
    }

    public CCU_I20_CLINICAL_HISTORY getCLINICAL_HISTORY(int rep) {
        return this.getTyped("CLINICAL_HISTORY", rep, CCU_I20_CLINICAL_HISTORY.class);
    }

    public int getCLINICAL_HISTORYReps() {
        return this.getReps("CLINICAL_HISTORY");
    }

    public List<CCU_I20_CLINICAL_HISTORY> getCLINICAL_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("CLINICAL_HISTORY", CCU_I20_CLINICAL_HISTORY.class);
    }

    public void insertCLINICAL_HISTORY(CCU_I20_CLINICAL_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("CLINICAL_HISTORY", structure, rep);
    }

    public CCU_I20_CLINICAL_HISTORY insertCLINICAL_HISTORY(int rep) throws HL7Exception {
        return (CCU_I20_CLINICAL_HISTORY)super.insertRepetition("CLINICAL_HISTORY", rep);
    }

    public CCU_I20_CLINICAL_HISTORY removeCLINICAL_HISTORY(int rep) throws HL7Exception {
        return (CCU_I20_CLINICAL_HISTORY)super.removeRepetition("CLINICAL_HISTORY", rep);
    }

    public CCU_I20_PATIENT_VISITS getPATIENT_VISITS() {
        return this.getTyped("PATIENT_VISITS", CCU_I20_PATIENT_VISITS.class);
    }

    public CCU_I20_PATIENT_VISITS getPATIENT_VISITS(int rep) {
        return this.getTyped("PATIENT_VISITS", rep, CCU_I20_PATIENT_VISITS.class);
    }

    public int getPATIENT_VISITSReps() {
        return this.getReps("PATIENT_VISITS");
    }

    public List<CCU_I20_PATIENT_VISITS> getPATIENT_VISITSAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_VISITS", CCU_I20_PATIENT_VISITS.class);
    }

    public void insertPATIENT_VISITS(CCU_I20_PATIENT_VISITS structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_VISITS", structure, rep);
    }

    public CCU_I20_PATIENT_VISITS insertPATIENT_VISITS(int rep) throws HL7Exception {
        return (CCU_I20_PATIENT_VISITS)super.insertRepetition("PATIENT_VISITS", rep);
    }

    public CCU_I20_PATIENT_VISITS removePATIENT_VISITS(int rep) throws HL7Exception {
        return (CCU_I20_PATIENT_VISITS)super.removeRepetition("PATIENT_VISITS", rep);
    }

    public CCU_I20_MEDICATION_HISTORY getMEDICATION_HISTORY() {
        return this.getTyped("MEDICATION_HISTORY", CCU_I20_MEDICATION_HISTORY.class);
    }

    public CCU_I20_MEDICATION_HISTORY getMEDICATION_HISTORY(int rep) {
        return this.getTyped("MEDICATION_HISTORY", rep, CCU_I20_MEDICATION_HISTORY.class);
    }

    public int getMEDICATION_HISTORYReps() {
        return this.getReps("MEDICATION_HISTORY");
    }

    public List<CCU_I20_MEDICATION_HISTORY> getMEDICATION_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("MEDICATION_HISTORY", CCU_I20_MEDICATION_HISTORY.class);
    }

    public void insertMEDICATION_HISTORY(CCU_I20_MEDICATION_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("MEDICATION_HISTORY", structure, rep);
    }

    public CCU_I20_MEDICATION_HISTORY insertMEDICATION_HISTORY(int rep) throws HL7Exception {
        return (CCU_I20_MEDICATION_HISTORY)super.insertRepetition("MEDICATION_HISTORY", rep);
    }

    public CCU_I20_MEDICATION_HISTORY removeMEDICATION_HISTORY(int rep) throws HL7Exception {
        return (CCU_I20_MEDICATION_HISTORY)super.removeRepetition("MEDICATION_HISTORY", rep);
    }

    public CCU_I20_PROBLEM getPROBLEM() {
        return this.getTyped("PROBLEM", CCU_I20_PROBLEM.class);
    }

    public CCU_I20_PROBLEM getPROBLEM(int rep) {
        return this.getTyped("PROBLEM", rep, CCU_I20_PROBLEM.class);
    }

    public int getPROBLEMReps() {
        return this.getReps("PROBLEM");
    }

    public List<CCU_I20_PROBLEM> getPROBLEMAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM", CCU_I20_PROBLEM.class);
    }

    public void insertPROBLEM(CCU_I20_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", structure, rep);
    }

    public CCU_I20_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (CCU_I20_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public CCU_I20_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (CCU_I20_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }

    public CCU_I20_GOAL getGOAL() {
        return this.getTyped("GOAL", CCU_I20_GOAL.class);
    }

    public CCU_I20_GOAL getGOAL(int rep) {
        return this.getTyped("GOAL", rep, CCU_I20_GOAL.class);
    }

    public int getGOALReps() {
        return this.getReps("GOAL");
    }

    public List<CCU_I20_GOAL> getGOALAll() throws HL7Exception {
        return this.getAllAsList("GOAL", CCU_I20_GOAL.class);
    }

    public void insertGOAL(CCU_I20_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL", structure, rep);
    }

    public CCU_I20_GOAL insertGOAL(int rep) throws HL7Exception {
        return (CCU_I20_GOAL)super.insertRepetition("GOAL", rep);
    }

    public CCU_I20_GOAL removeGOAL(int rep) throws HL7Exception {
        return (CCU_I20_GOAL)super.removeRepetition("GOAL", rep);
    }

    public CCU_I20_PATHWAY getPATHWAY() {
        return this.getTyped("PATHWAY", CCU_I20_PATHWAY.class);
    }

    public CCU_I20_PATHWAY getPATHWAY(int rep) {
        return this.getTyped("PATHWAY", rep, CCU_I20_PATHWAY.class);
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<CCU_I20_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", CCU_I20_PATHWAY.class);
    }

    public void insertPATHWAY(CCU_I20_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", structure, rep);
    }

    public CCU_I20_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (CCU_I20_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public CCU_I20_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (CCU_I20_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }

    public REL getREL() {
        return this.getTyped("REL", REL.class);
    }

    public REL getREL(int rep) {
        return this.getTyped("REL", rep, REL.class);
    }

    public int getRELReps() {
        return this.getReps("REL");
    }

    public List<REL> getRELAll() throws HL7Exception {
        return this.getAllAsList("REL", REL.class);
    }

    public void insertREL(REL structure, int rep) throws HL7Exception {
        super.insertRepetition("REL", structure, rep);
    }

    public REL insertREL(int rep) throws HL7Exception {
        return (REL)super.insertRepetition("REL", rep);
    }

    public REL removeREL(int rep) throws HL7Exception {
        return (REL)super.removeRepetition("REL", rep);
    }
}

