/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.group.OML_O35_SPECIMEN_CONTAINER;
import ca.uhn.hl7v2.model.v27.group.OML_O35_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v27.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OML_O35_SPECIMEN
extends AbstractGroup {
    public OML_O35_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(OML_O35_SPECIMEN_OBSERVATION.class, false, true, false);
            this.add(OML_O35_SPECIMEN_CONTAINER.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OML_O35_SPECIMEN - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public SPM getSPM() {
        SPM retVal = this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public OML_O35_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        OML_O35_SPECIMEN_OBSERVATION retVal = this.getTyped("SPECIMEN_OBSERVATION", OML_O35_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public OML_O35_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        OML_O35_SPECIMEN_OBSERVATION retVal = this.getTyped("SPECIMEN_OBSERVATION", rep, OML_O35_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        return this.getReps("SPECIMEN_OBSERVATION");
    }

    public List<OML_O35_SPECIMEN_OBSERVATION> getSPECIMEN_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_OBSERVATION", OML_O35_SPECIMEN_OBSERVATION.class);
    }

    public void insertSPECIMEN_OBSERVATION(OML_O35_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", structure, rep);
    }

    public OML_O35_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OML_O35_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OML_O35_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OML_O35_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OML_O35_SPECIMEN_CONTAINER getSPECIMEN_CONTAINER() {
        OML_O35_SPECIMEN_CONTAINER retVal = this.getTyped("SPECIMEN_CONTAINER", OML_O35_SPECIMEN_CONTAINER.class);
        return retVal;
    }

    public OML_O35_SPECIMEN_CONTAINER getSPECIMEN_CONTAINER(int rep) {
        OML_O35_SPECIMEN_CONTAINER retVal = this.getTyped("SPECIMEN_CONTAINER", rep, OML_O35_SPECIMEN_CONTAINER.class);
        return retVal;
    }

    public int getSPECIMEN_CONTAINERReps() {
        return this.getReps("SPECIMEN_CONTAINER");
    }

    public List<OML_O35_SPECIMEN_CONTAINER> getSPECIMEN_CONTAINERAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_CONTAINER", OML_O35_SPECIMEN_CONTAINER.class);
    }

    public void insertSPECIMEN_CONTAINER(OML_O35_SPECIMEN_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_CONTAINER", structure, rep);
    }

    public OML_O35_SPECIMEN_CONTAINER insertSPECIMEN_CONTAINER(int rep) throws HL7Exception {
        return (OML_O35_SPECIMEN_CONTAINER)super.insertRepetition("SPECIMEN_CONTAINER", rep);
    }

    public OML_O35_SPECIMEN_CONTAINER removeSPECIMEN_CONTAINER(int rep) throws HL7Exception {
        return (OML_O35_SPECIMEN_CONTAINER)super.removeRepetition("SPECIMEN_CONTAINER", rep);
    }
}

