/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.group.MFN_M16_MATERIAL_LOCATION;
import ca.uhn.hl7v2.model.v27.group.MFN_M16_PURCHASING_VENDOR;
import ca.uhn.hl7v2.model.v27.group.MFN_M16_STERILIZATION;
import ca.uhn.hl7v2.model.v27.segment.ITM;
import ca.uhn.hl7v2.model.v27.segment.MFE;
import ca.uhn.hl7v2.model.v27.segment.NTE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M16_MATERIAL_ITEM_RECORD
extends AbstractGroup {
    public MFN_M16_MATERIAL_ITEM_RECORD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false, false);
            this.add(ITM.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(MFN_M16_STERILIZATION.class, false, true, false);
            this.add(MFN_M16_PURCHASING_VENDOR.class, false, true, false);
            this.add(MFN_M16_MATERIAL_LOCATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M16_MATERIAL_ITEM_RECORD - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public MFE getMFE() {
        MFE retVal = this.getTyped("MFE", MFE.class);
        return retVal;
    }

    public ITM getITM() {
        ITM retVal = this.getTyped("ITM", ITM.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public MFN_M16_STERILIZATION getSTERILIZATION() {
        MFN_M16_STERILIZATION retVal = this.getTyped("STERILIZATION", MFN_M16_STERILIZATION.class);
        return retVal;
    }

    public MFN_M16_STERILIZATION getSTERILIZATION(int rep) {
        MFN_M16_STERILIZATION retVal = this.getTyped("STERILIZATION", rep, MFN_M16_STERILIZATION.class);
        return retVal;
    }

    public int getSTERILIZATIONReps() {
        return this.getReps("STERILIZATION");
    }

    public List<MFN_M16_STERILIZATION> getSTERILIZATIONAll() throws HL7Exception {
        return this.getAllAsList("STERILIZATION", MFN_M16_STERILIZATION.class);
    }

    public void insertSTERILIZATION(MFN_M16_STERILIZATION structure, int rep) throws HL7Exception {
        super.insertRepetition("STERILIZATION", structure, rep);
    }

    public MFN_M16_STERILIZATION insertSTERILIZATION(int rep) throws HL7Exception {
        return (MFN_M16_STERILIZATION)super.insertRepetition("STERILIZATION", rep);
    }

    public MFN_M16_STERILIZATION removeSTERILIZATION(int rep) throws HL7Exception {
        return (MFN_M16_STERILIZATION)super.removeRepetition("STERILIZATION", rep);
    }

    public MFN_M16_PURCHASING_VENDOR getPURCHASING_VENDOR() {
        MFN_M16_PURCHASING_VENDOR retVal = this.getTyped("PURCHASING_VENDOR", MFN_M16_PURCHASING_VENDOR.class);
        return retVal;
    }

    public MFN_M16_PURCHASING_VENDOR getPURCHASING_VENDOR(int rep) {
        MFN_M16_PURCHASING_VENDOR retVal = this.getTyped("PURCHASING_VENDOR", rep, MFN_M16_PURCHASING_VENDOR.class);
        return retVal;
    }

    public int getPURCHASING_VENDORReps() {
        return this.getReps("PURCHASING_VENDOR");
    }

    public List<MFN_M16_PURCHASING_VENDOR> getPURCHASING_VENDORAll() throws HL7Exception {
        return this.getAllAsList("PURCHASING_VENDOR", MFN_M16_PURCHASING_VENDOR.class);
    }

    public void insertPURCHASING_VENDOR(MFN_M16_PURCHASING_VENDOR structure, int rep) throws HL7Exception {
        super.insertRepetition("PURCHASING_VENDOR", structure, rep);
    }

    public MFN_M16_PURCHASING_VENDOR insertPURCHASING_VENDOR(int rep) throws HL7Exception {
        return (MFN_M16_PURCHASING_VENDOR)super.insertRepetition("PURCHASING_VENDOR", rep);
    }

    public MFN_M16_PURCHASING_VENDOR removePURCHASING_VENDOR(int rep) throws HL7Exception {
        return (MFN_M16_PURCHASING_VENDOR)super.removeRepetition("PURCHASING_VENDOR", rep);
    }

    public MFN_M16_MATERIAL_LOCATION getMATERIAL_LOCATION() {
        MFN_M16_MATERIAL_LOCATION retVal = this.getTyped("MATERIAL_LOCATION", MFN_M16_MATERIAL_LOCATION.class);
        return retVal;
    }

    public MFN_M16_MATERIAL_LOCATION getMATERIAL_LOCATION(int rep) {
        MFN_M16_MATERIAL_LOCATION retVal = this.getTyped("MATERIAL_LOCATION", rep, MFN_M16_MATERIAL_LOCATION.class);
        return retVal;
    }

    public int getMATERIAL_LOCATIONReps() {
        return this.getReps("MATERIAL_LOCATION");
    }

    public List<MFN_M16_MATERIAL_LOCATION> getMATERIAL_LOCATIONAll() throws HL7Exception {
        return this.getAllAsList("MATERIAL_LOCATION", MFN_M16_MATERIAL_LOCATION.class);
    }

    public void insertMATERIAL_LOCATION(MFN_M16_MATERIAL_LOCATION structure, int rep) throws HL7Exception {
        super.insertRepetition("MATERIAL_LOCATION", structure, rep);
    }

    public MFN_M16_MATERIAL_LOCATION insertMATERIAL_LOCATION(int rep) throws HL7Exception {
        return (MFN_M16_MATERIAL_LOCATION)super.insertRepetition("MATERIAL_LOCATION", rep);
    }

    public MFN_M16_MATERIAL_LOCATION removeMATERIAL_LOCATION(int rep) throws HL7Exception {
        return (MFN_M16_MATERIAL_LOCATION)super.removeRepetition("MATERIAL_LOCATION", rep);
    }
}

