/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class STZ
extends AbstractSegment {
    public STZ(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Sterilization Type");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Sterilization Cycle");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Maintenance Cycle");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Maintenance Type");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating STZ - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getSterilizationType() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getStz1_SterilizationType() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getSterilizationCycle() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getStz2_SterilizationCycle() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getMaintenanceCycle() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getStz3_MaintenanceCycle() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getMaintenanceType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getStz4_MaintenanceType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

