/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.LA2;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.PL;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXA
extends AbstractSegment {
    public RXA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 4, new Object[]{this.getMessage()}, "Give Sub-ID Counter");
            this.add(NM.class, true, 1, 4, new Object[]{this.getMessage()}, "Administration Sub-ID Counter");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Date/Time Start of Administration");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Date/Time End of Administration");
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "Administered Code");
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Administered Amount");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Administered Units");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Administered Dosage Form");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Administration Notes");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Administering Provider");
            this.add(LA2.class, false, 1, 0, new Object[]{this.getMessage()}, "Administered-at Location");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Administered Per (Time Unit)");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Administered Strength");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Administered Strength Units");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "Substance Lot Number");
            this.add(DTM.class, false, 0, 24, new Object[]{this.getMessage()}, "Substance Expiration Date");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Substance Manufacturer Name");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Substance/Treatment Refusal Reason");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Indication");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(322)}, "Completion Status");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(206)}, "Action Code - RXA");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "System Entry Date/Time");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Administered Drug Strength Volume");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Administered Drug Strength Volume Units");
            this.add(CWE.class, false, 1, 60, new Object[]{this.getMessage()}, "Administered Barcode Identifier");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(480)}, "Pharmacy Order Type");
            this.add(PL.class, false, 1, 180, new Object[]{this.getMessage()}, "Administer-at");
            this.add(XAD.class, false, 1, 106, new Object[]{this.getMessage()}, "Administered-at Address");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXA - this is probably a bug in the source code generator.", e);
        }
    }

    public NM getGiveSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getRxa1_GiveSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getAdministrationSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getRxa2_AdministrationSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getDateTimeStartOfAdministration() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getRxa3_DateTimeStartOfAdministration() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getDateTimeEndOfAdministration() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getRxa4_DateTimeEndOfAdministration() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getAdministeredCode() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getRxa5_AdministeredCode() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getAdministeredAmount() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getRxa6_AdministeredAmount() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getAdministeredUnits() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getRxa7_AdministeredUnits() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getAdministeredDosageForm() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getRxa8_AdministeredDosageForm() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE[] getAdministrationNotes() {
        CWE[] retVal = (CWE[])this.getTypedField(9, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxa9_AdministrationNotes() {
        CWE[] retVal = (CWE[])this.getTypedField(9, new CWE[0]);
        return retVal;
    }

    public int getAdministrationNotesReps() {
        return this.getReps(9);
    }

    public CWE getAdministrationNotes(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public CWE getRxa9_AdministrationNotes(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getRxa9_AdministrationNotesReps() {
        return this.getReps(9);
    }

    public CWE insertAdministrationNotes(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE insertRxa9_AdministrationNotes(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE removeAdministrationNotes(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE removeRxa9_AdministrationNotes(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public XCN[] getAdministeringProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public XCN[] getRxa10_AdministeringProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public int getAdministeringProviderReps() {
        return this.getReps(10);
    }

    public XCN getAdministeringProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public XCN getRxa10_AdministeringProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getRxa10_AdministeringProviderReps() {
        return this.getReps(10);
    }

    public XCN insertAdministeringProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN insertRxa10_AdministeringProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN removeAdministeringProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public XCN removeRxa10_AdministeringProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public LA2 getAdministeredAtLocation() {
        LA2 retVal = (LA2)this.getTypedField(11, 0);
        return retVal;
    }

    public LA2 getRxa11_AdministeredAtLocation() {
        LA2 retVal = (LA2)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getAdministeredPerTimeUnit() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getRxa12_AdministeredPerTimeUnit() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getAdministeredStrength() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getRxa13_AdministeredStrength() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getAdministeredStrengthUnits() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getRxa14_AdministeredStrengthUnits() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public ST[] getSubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(15, new ST[0]);
        return retVal;
    }

    public ST[] getRxa15_SubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(15, new ST[0]);
        return retVal;
    }

    public int getSubstanceLotNumberReps() {
        return this.getReps(15);
    }

    public ST getSubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(15, rep);
        return retVal;
    }

    public ST getRxa15_SubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(15, rep);
        return retVal;
    }

    public int getRxa15_SubstanceLotNumberReps() {
        return this.getReps(15);
    }

    public ST insertSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(15, rep);
    }

    public ST insertRxa15_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(15, rep);
    }

    public ST removeSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(15, rep);
    }

    public ST removeRxa15_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(15, rep);
    }

    public DTM[] getSubstanceExpirationDate() {
        DTM[] retVal = (DTM[])this.getTypedField(16, new DTM[0]);
        return retVal;
    }

    public DTM[] getRxa16_SubstanceExpirationDate() {
        DTM[] retVal = (DTM[])this.getTypedField(16, new DTM[0]);
        return retVal;
    }

    public int getSubstanceExpirationDateReps() {
        return this.getReps(16);
    }

    public DTM getSubstanceExpirationDate(int rep) {
        DTM retVal = (DTM)this.getTypedField(16, rep);
        return retVal;
    }

    public DTM getRxa16_SubstanceExpirationDate(int rep) {
        DTM retVal = (DTM)this.getTypedField(16, rep);
        return retVal;
    }

    public int getRxa16_SubstanceExpirationDateReps() {
        return this.getReps(16);
    }

    public DTM insertSubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.insertRepetition(16, rep);
    }

    public DTM insertRxa16_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.insertRepetition(16, rep);
    }

    public DTM removeSubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.removeRepetition(16, rep);
    }

    public DTM removeRxa16_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.removeRepetition(16, rep);
    }

    public CWE[] getSubstanceManufacturerName() {
        CWE[] retVal = (CWE[])this.getTypedField(17, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxa17_SubstanceManufacturerName() {
        CWE[] retVal = (CWE[])this.getTypedField(17, new CWE[0]);
        return retVal;
    }

    public int getSubstanceManufacturerNameReps() {
        return this.getReps(17);
    }

    public CWE getSubstanceManufacturerName(int rep) {
        CWE retVal = (CWE)this.getTypedField(17, rep);
        return retVal;
    }

    public CWE getRxa17_SubstanceManufacturerName(int rep) {
        CWE retVal = (CWE)this.getTypedField(17, rep);
        return retVal;
    }

    public int getRxa17_SubstanceManufacturerNameReps() {
        return this.getReps(17);
    }

    public CWE insertSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(17, rep);
    }

    public CWE insertRxa17_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(17, rep);
    }

    public CWE removeSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(17, rep);
    }

    public CWE removeRxa17_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(17, rep);
    }

    public CWE[] getSubstanceTreatmentRefusalReason() {
        CWE[] retVal = (CWE[])this.getTypedField(18, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxa18_SubstanceTreatmentRefusalReason() {
        CWE[] retVal = (CWE[])this.getTypedField(18, new CWE[0]);
        return retVal;
    }

    public int getSubstanceTreatmentRefusalReasonReps() {
        return this.getReps(18);
    }

    public CWE getSubstanceTreatmentRefusalReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public CWE getRxa18_SubstanceTreatmentRefusalReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public int getRxa18_SubstanceTreatmentRefusalReasonReps() {
        return this.getReps(18);
    }

    public CWE insertSubstanceTreatmentRefusalReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE insertRxa18_SubstanceTreatmentRefusalReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE removeSubstanceTreatmentRefusalReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public CWE removeRxa18_SubstanceTreatmentRefusalReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public CWE[] getIndication() {
        CWE[] retVal = (CWE[])this.getTypedField(19, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxa19_Indication() {
        CWE[] retVal = (CWE[])this.getTypedField(19, new CWE[0]);
        return retVal;
    }

    public int getIndicationReps() {
        return this.getReps(19);
    }

    public CWE getIndication(int rep) {
        CWE retVal = (CWE)this.getTypedField(19, rep);
        return retVal;
    }

    public CWE getRxa19_Indication(int rep) {
        CWE retVal = (CWE)this.getTypedField(19, rep);
        return retVal;
    }

    public int getRxa19_IndicationReps() {
        return this.getReps(19);
    }

    public CWE insertIndication(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(19, rep);
    }

    public CWE insertRxa19_Indication(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(19, rep);
    }

    public CWE removeIndication(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(19, rep);
    }

    public CWE removeRxa19_Indication(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(19, rep);
    }

    public ID getCompletionStatus() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getRxa20_CompletionStatus() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getActionCodeRXA() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getRxa21_ActionCodeRXA() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public DTM getSystemEntryDateTime() {
        DTM retVal = (DTM)this.getTypedField(22, 0);
        return retVal;
    }

    public DTM getRxa22_SystemEntryDateTime() {
        DTM retVal = (DTM)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getAdministeredDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getRxa23_AdministeredDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE getAdministeredDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(24, 0);
        return retVal;
    }

    public CWE getRxa24_AdministeredDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(24, 0);
        return retVal;
    }

    public CWE getAdministeredBarcodeIdentifier() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getRxa25_AdministeredBarcodeIdentifier() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getPharmacyOrderType() {
        ID retVal = (ID)this.getTypedField(26, 0);
        return retVal;
    }

    public ID getRxa26_PharmacyOrderType() {
        ID retVal = (ID)this.getTypedField(26, 0);
        return retVal;
    }

    public PL getAdministerAt() {
        PL retVal = (PL)this.getTypedField(27, 0);
        return retVal;
    }

    public PL getRxa27_AdministerAt() {
        PL retVal = (PL)this.getTypedField(27, 0);
        return retVal;
    }

    public XAD getAdministeredAtAddress() {
        XAD retVal = (XAD)this.getTypedField(28, 0);
        return retVal;
    }

    public XAD getRxa28_AdministeredAtAddress() {
        XAD retVal = (XAD)this.getTypedField(28, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new XCN(this.getMessage());
            }
            case 10: {
                return new LA2(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new NM(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new DTM(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new CWE(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(322));
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 21: {
                return new DTM(this.getMessage());
            }
            case 22: {
                return new NM(this.getMessage());
            }
            case 23: {
                return new CWE(this.getMessage());
            }
            case 24: {
                return new CWE(this.getMessage());
            }
            case 25: {
                return new ID(this.getMessage(), new Integer(480));
            }
            case 26: {
                return new PL(this.getMessage());
            }
            case 27: {
                return new XAD(this.getMessage());
            }
        }
        return null;
    }
}

