/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.CQ;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.CX;
import ca.uhn.hl7v2.model.v26.datatype.DR;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PSL
extends AbstractSegment {
    public PSL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 73, new Object[]{this.getMessage()}, "Provider Product/Service Line Item Number");
            this.add(EI.class, false, 1, 73, new Object[]{this.getMessage()}, "Payer Product/Service Line Item Number");
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Product/Service Line Item Sequence Number");
            this.add(EI.class, false, 1, 20, new Object[]{this.getMessage()}, "Provider Tracking ID");
            this.add(EI.class, false, 1, 20, new Object[]{this.getMessage()}, "Payer Tracking ID");
            this.add(CWE.class, true, 1, 2, new Object[]{this.getMessage()}, "Product/Service Line Item Status");
            this.add(CWE.class, true, 1, 177, new Object[]{this.getMessage()}, "Product/Service Code");
            this.add(CWE.class, false, 1, 177, new Object[]{this.getMessage()}, "Product/Service Code Modifier");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Product/Service Code Description");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Product/Service Effective Date");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Product/Service Expiration Date");
            this.add(CQ.class, false, 1, 222, new Object[]{this.getMessage()}, "Product/Service Quantity");
            this.add(CP.class, false, 1, 254, new Object[]{this.getMessage()}, "Product/Service Unit Cost");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "Number of Items per Unit");
            this.add(CP.class, false, 1, 254, new Object[]{this.getMessage()}, "Product/Service Gross Amount");
            this.add(CP.class, false, 1, 254, new Object[]{this.getMessage()}, "Product/Service Billed Amount");
            this.add(IS.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(561)}, "Product/Service Clarification Code Type");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Product/Service Clarification Code Value");
            this.add(EI.class, false, 1, 73, new Object[]{this.getMessage()}, "Health Document Reference Identifier");
            this.add(IS.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(562)}, "Processing Consideration Code");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(532)}, "Restricted Disclosure Indicator");
            this.add(CWE.class, false, 1, 177, new Object[]{this.getMessage()}, "Related Product/Service Code Indicator");
            this.add(CP.class, false, 1, 254, new Object[]{this.getMessage()}, "Product/Service Amount for Physician");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Product/Service Cost Factor");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Cost Center");
            this.add(DR.class, false, 1, 49, new Object[]{this.getMessage()}, "Billing Period");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Days without Billing");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Session-No");
            this.add(XCN.class, false, 1, 20, new Object[]{this.getMessage()}, "Executing Physician ID");
            this.add(XCN.class, false, 1, 20, new Object[]{this.getMessage()}, "Responsible Physician ID");
            this.add(CWE.class, false, 1, 10, new Object[]{this.getMessage()}, "Role Executing Physician");
            this.add(CWE.class, false, 1, 10, new Object[]{this.getMessage()}, "Medical Role Executing Physician");
            this.add(CWE.class, false, 1, 3, new Object[]{this.getMessage()}, "Side of body");
            this.add(NM.class, false, 1, 6, new Object[]{this.getMessage()}, "Number of TP's PP");
            this.add(CP.class, false, 1, 6, new Object[]{this.getMessage()}, "TP-Value PP");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Internal Scaling Factor PP");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "External Scaling Factor PP");
            this.add(CP.class, false, 1, 7, new Object[]{this.getMessage()}, "Amount PP");
            this.add(NM.class, false, 1, 6, new Object[]{this.getMessage()}, "Number of TP's Technical Part");
            this.add(CP.class, false, 1, 6, new Object[]{this.getMessage()}, "TP-Value Technical Part");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Internal Scaling Factor Technical Part");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "External Scaling Factor Technical Part");
            this.add(CP.class, false, 1, 7, new Object[]{this.getMessage()}, "Amount Technical Part");
            this.add(CP.class, false, 1, 8, new Object[]{this.getMessage()}, "Total Amount Professional Part + Technical Part");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "VAT-Rate");
            this.add(ID.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Main-Service");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Validation");
            this.add(ST.class, false, 1, 255, new Object[]{this.getMessage()}, "Comment");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PSL - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getProviderProductServiceLineItemNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPsl1_ProviderProductServiceLineItemNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPayerProductServiceLineItemNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getPsl2_PayerProductServiceLineItemNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public SI getProductServiceLineItemSequenceNumber() {
        SI retVal = (SI)this.getTypedField(3, 0);
        return retVal;
    }

    public SI getPsl3_ProductServiceLineItemSequenceNumber() {
        SI retVal = (SI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getProviderTrackingID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getPsl4_ProviderTrackingID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getPayerTrackingID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getPsl5_PayerTrackingID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getProductServiceLineItemStatus() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getPsl6_ProductServiceLineItemStatus() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getProductServiceCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getPsl7_ProductServiceCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getProductServiceCodeModifier() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getPsl8_ProductServiceCodeModifier() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getProductServiceCodeDescription() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getPsl9_ProductServiceCodeDescription() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public DTM getProductServiceEffectiveDate() {
        DTM retVal = (DTM)this.getTypedField(10, 0);
        return retVal;
    }

    public DTM getPsl10_ProductServiceEffectiveDate() {
        DTM retVal = (DTM)this.getTypedField(10, 0);
        return retVal;
    }

    public DTM getProductServiceExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(11, 0);
        return retVal;
    }

    public DTM getPsl11_ProductServiceExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ getProductServiceQuantity() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ getPsl12_ProductServiceQuantity() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public CP getProductServiceUnitCost() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public CP getPsl13_ProductServiceUnitCost() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getNumberOfItemsPerUnit() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getPsl14_NumberOfItemsPerUnit() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public CP getProductServiceGrossAmount() {
        CP retVal = (CP)this.getTypedField(15, 0);
        return retVal;
    }

    public CP getPsl15_ProductServiceGrossAmount() {
        CP retVal = (CP)this.getTypedField(15, 0);
        return retVal;
    }

    public CP getProductServiceBilledAmount() {
        CP retVal = (CP)this.getTypedField(16, 0);
        return retVal;
    }

    public CP getPsl16_ProductServiceBilledAmount() {
        CP retVal = (CP)this.getTypedField(16, 0);
        return retVal;
    }

    public IS getProductServiceClarificationCodeType() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public IS getPsl17_ProductServiceClarificationCodeType() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public ST getProductServiceClarificationCodeValue() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getPsl18_ProductServiceClarificationCodeValue() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public EI getHealthDocumentReferenceIdentifier() {
        EI retVal = (EI)this.getTypedField(19, 0);
        return retVal;
    }

    public EI getPsl19_HealthDocumentReferenceIdentifier() {
        EI retVal = (EI)this.getTypedField(19, 0);
        return retVal;
    }

    public IS getProcessingConsiderationCode() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getPsl20_ProcessingConsiderationCode() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getRestrictedDisclosureIndicator() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getPsl21_RestrictedDisclosureIndicator() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getRelatedProductServiceCodeIndicator() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getPsl22_RelatedProductServiceCodeIndicator() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public CP getProductServiceAmountForPhysician() {
        CP retVal = (CP)this.getTypedField(23, 0);
        return retVal;
    }

    public CP getPsl23_ProductServiceAmountForPhysician() {
        CP retVal = (CP)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getProductServiceCostFactor() {
        NM retVal = (NM)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getPsl24_ProductServiceCostFactor() {
        NM retVal = (NM)this.getTypedField(24, 0);
        return retVal;
    }

    public CX getCostCenter() {
        CX retVal = (CX)this.getTypedField(25, 0);
        return retVal;
    }

    public CX getPsl25_CostCenter() {
        CX retVal = (CX)this.getTypedField(25, 0);
        return retVal;
    }

    public DR getBillingPeriod() {
        DR retVal = (DR)this.getTypedField(26, 0);
        return retVal;
    }

    public DR getPsl26_BillingPeriod() {
        DR retVal = (DR)this.getTypedField(26, 0);
        return retVal;
    }

    public NM getDaysWithoutBilling() {
        NM retVal = (NM)this.getTypedField(27, 0);
        return retVal;
    }

    public NM getPsl27_DaysWithoutBilling() {
        NM retVal = (NM)this.getTypedField(27, 0);
        return retVal;
    }

    public NM getSessionNo() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public NM getPsl28_SessionNo() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public XCN getExecutingPhysicianID() {
        XCN retVal = (XCN)this.getTypedField(29, 0);
        return retVal;
    }

    public XCN getPsl29_ExecutingPhysicianID() {
        XCN retVal = (XCN)this.getTypedField(29, 0);
        return retVal;
    }

    public XCN getResponsiblePhysicianID() {
        XCN retVal = (XCN)this.getTypedField(30, 0);
        return retVal;
    }

    public XCN getPsl30_ResponsiblePhysicianID() {
        XCN retVal = (XCN)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getRoleExecutingPhysician() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getPsl31_RoleExecutingPhysician() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getMedicalRoleExecutingPhysician() {
        CWE retVal = (CWE)this.getTypedField(32, 0);
        return retVal;
    }

    public CWE getPsl32_MedicalRoleExecutingPhysician() {
        CWE retVal = (CWE)this.getTypedField(32, 0);
        return retVal;
    }

    public CWE getSideOfBody() {
        CWE retVal = (CWE)this.getTypedField(33, 0);
        return retVal;
    }

    public CWE getPsl33_SideOfBody() {
        CWE retVal = (CWE)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getNumberOfTPSPP() {
        NM retVal = (NM)this.getTypedField(34, 0);
        return retVal;
    }

    public NM getPsl34_NumberOfTPSPP() {
        NM retVal = (NM)this.getTypedField(34, 0);
        return retVal;
    }

    public CP getTPValuePP() {
        CP retVal = (CP)this.getTypedField(35, 0);
        return retVal;
    }

    public CP getPsl35_TPValuePP() {
        CP retVal = (CP)this.getTypedField(35, 0);
        return retVal;
    }

    public NM getInternalScalingFactorPP() {
        NM retVal = (NM)this.getTypedField(36, 0);
        return retVal;
    }

    public NM getPsl36_InternalScalingFactorPP() {
        NM retVal = (NM)this.getTypedField(36, 0);
        return retVal;
    }

    public NM getExternalScalingFactorPP() {
        NM retVal = (NM)this.getTypedField(37, 0);
        return retVal;
    }

    public NM getPsl37_ExternalScalingFactorPP() {
        NM retVal = (NM)this.getTypedField(37, 0);
        return retVal;
    }

    public CP getAmountPP() {
        CP retVal = (CP)this.getTypedField(38, 0);
        return retVal;
    }

    public CP getPsl38_AmountPP() {
        CP retVal = (CP)this.getTypedField(38, 0);
        return retVal;
    }

    public NM getNumberOfTPSTechnicalPart() {
        NM retVal = (NM)this.getTypedField(39, 0);
        return retVal;
    }

    public NM getPsl39_NumberOfTPSTechnicalPart() {
        NM retVal = (NM)this.getTypedField(39, 0);
        return retVal;
    }

    public CP getTPValueTechnicalPart() {
        CP retVal = (CP)this.getTypedField(40, 0);
        return retVal;
    }

    public CP getPsl40_TPValueTechnicalPart() {
        CP retVal = (CP)this.getTypedField(40, 0);
        return retVal;
    }

    public NM getInternalScalingFactorTechnicalPart() {
        NM retVal = (NM)this.getTypedField(41, 0);
        return retVal;
    }

    public NM getPsl41_InternalScalingFactorTechnicalPart() {
        NM retVal = (NM)this.getTypedField(41, 0);
        return retVal;
    }

    public NM getExternalScalingFactorTechnicalPart() {
        NM retVal = (NM)this.getTypedField(42, 0);
        return retVal;
    }

    public NM getPsl42_ExternalScalingFactorTechnicalPart() {
        NM retVal = (NM)this.getTypedField(42, 0);
        return retVal;
    }

    public CP getAmountTechnicalPart() {
        CP retVal = (CP)this.getTypedField(43, 0);
        return retVal;
    }

    public CP getPsl43_AmountTechnicalPart() {
        CP retVal = (CP)this.getTypedField(43, 0);
        return retVal;
    }

    public CP getTotalAmountProfessionalPartTechnicalPart() {
        CP retVal = (CP)this.getTypedField(44, 0);
        return retVal;
    }

    public CP getPsl44_TotalAmountProfessionalPartTechnicalPart() {
        CP retVal = (CP)this.getTypedField(44, 0);
        return retVal;
    }

    public NM getVATRate() {
        NM retVal = (NM)this.getTypedField(45, 0);
        return retVal;
    }

    public NM getPsl45_VATRate() {
        NM retVal = (NM)this.getTypedField(45, 0);
        return retVal;
    }

    public ID getMainService() {
        ID retVal = (ID)this.getTypedField(46, 0);
        return retVal;
    }

    public ID getPsl46_MainService() {
        ID retVal = (ID)this.getTypedField(46, 0);
        return retVal;
    }

    public ID getValidation() {
        ID retVal = (ID)this.getTypedField(47, 0);
        return retVal;
    }

    public ID getPsl47_Validation() {
        ID retVal = (ID)this.getTypedField(47, 0);
        return retVal;
    }

    public ST getComment() {
        ST retVal = (ST)this.getTypedField(48, 0);
        return retVal;
    }

    public ST getPsl48_Comment() {
        ST retVal = (ST)this.getTypedField(48, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new SI(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new EI(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new DTM(this.getMessage());
            }
            case 10: {
                return new DTM(this.getMessage());
            }
            case 11: {
                return new CQ(this.getMessage());
            }
            case 12: {
                return new CP(this.getMessage());
            }
            case 13: {
                return new NM(this.getMessage());
            }
            case 14: {
                return new CP(this.getMessage());
            }
            case 15: {
                return new CP(this.getMessage());
            }
            case 16: {
                return new IS(this.getMessage(), new Integer(561));
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new EI(this.getMessage());
            }
            case 19: {
                return new IS(this.getMessage(), new Integer(562));
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(532));
            }
            case 21: {
                return new CWE(this.getMessage());
            }
            case 22: {
                return new CP(this.getMessage());
            }
            case 23: {
                return new NM(this.getMessage());
            }
            case 24: {
                return new CX(this.getMessage());
            }
            case 25: {
                return new DR(this.getMessage());
            }
            case 26: {
                return new NM(this.getMessage());
            }
            case 27: {
                return new NM(this.getMessage());
            }
            case 28: {
                return new XCN(this.getMessage());
            }
            case 29: {
                return new XCN(this.getMessage());
            }
            case 30: {
                return new CWE(this.getMessage());
            }
            case 31: {
                return new CWE(this.getMessage());
            }
            case 32: {
                return new CWE(this.getMessage());
            }
            case 33: {
                return new NM(this.getMessage());
            }
            case 34: {
                return new CP(this.getMessage());
            }
            case 35: {
                return new NM(this.getMessage());
            }
            case 36: {
                return new NM(this.getMessage());
            }
            case 37: {
                return new CP(this.getMessage());
            }
            case 38: {
                return new NM(this.getMessage());
            }
            case 39: {
                return new CP(this.getMessage());
            }
            case 40: {
                return new NM(this.getMessage());
            }
            case 41: {
                return new NM(this.getMessage());
            }
            case 42: {
                return new CP(this.getMessage());
            }
            case 43: {
                return new CP(this.getMessage());
            }
            case 44: {
                return new NM(this.getMessage());
            }
            case 45: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 46: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 47: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

