/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CX;
import ca.uhn.hl7v2.model.v26.datatype.XPN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MRG
extends AbstractSegment {
    public MRG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CX.class, true, 0, 250, new Object[]{this.getMessage()}, "Prior Patient Identifier List");
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Prior Alternate Patient ID");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Prior Patient Account Number");
            this.add(CX.class, false, 1, 0, new Object[]{this.getMessage()}, "Prior Patient ID");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Prior Visit Number");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Prior Alternate Visit ID");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Prior Patient Name");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MRG - this is probably a bug in the source code generator.", e);
        }
    }

    public CX[] getPriorPatientIdentifierList() {
        CX[] retVal = (CX[])this.getTypedField(1, new CX[0]);
        return retVal;
    }

    public CX[] getMrg1_PriorPatientIdentifierList() {
        CX[] retVal = (CX[])this.getTypedField(1, new CX[0]);
        return retVal;
    }

    public int getPriorPatientIdentifierListReps() {
        return this.getReps(1);
    }

    public CX getPriorPatientIdentifierList(int rep) {
        CX retVal = (CX)this.getTypedField(1, rep);
        return retVal;
    }

    public CX getMrg1_PriorPatientIdentifierList(int rep) {
        CX retVal = (CX)this.getTypedField(1, rep);
        return retVal;
    }

    public int getMrg1_PriorPatientIdentifierListReps() {
        return this.getReps(1);
    }

    public CX insertPriorPatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(1, rep);
    }

    public CX insertMrg1_PriorPatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(1, rep);
    }

    public CX removePriorPatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(1, rep);
    }

    public CX removeMrg1_PriorPatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(1, rep);
    }

    public CX[] getPriorAlternatePatientID() {
        CX[] retVal = (CX[])this.getTypedField(2, new CX[0]);
        return retVal;
    }

    public CX[] getMrg2_PriorAlternatePatientID() {
        CX[] retVal = (CX[])this.getTypedField(2, new CX[0]);
        return retVal;
    }

    public int getPriorAlternatePatientIDReps() {
        return this.getReps(2);
    }

    public CX getPriorAlternatePatientID(int rep) {
        CX retVal = (CX)this.getTypedField(2, rep);
        return retVal;
    }

    public CX getMrg2_PriorAlternatePatientID(int rep) {
        CX retVal = (CX)this.getTypedField(2, rep);
        return retVal;
    }

    public int getMrg2_PriorAlternatePatientIDReps() {
        return this.getReps(2);
    }

    public CX insertPriorAlternatePatientID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX insertMrg2_PriorAlternatePatientID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX removePriorAlternatePatientID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public CX removeMrg2_PriorAlternatePatientID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public CX getPriorPatientAccountNumber() {
        CX retVal = (CX)this.getTypedField(3, 0);
        return retVal;
    }

    public CX getMrg3_PriorPatientAccountNumber() {
        CX retVal = (CX)this.getTypedField(3, 0);
        return retVal;
    }

    public CX getPriorPatientID() {
        CX retVal = (CX)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getMrg4_PriorPatientID() {
        CX retVal = (CX)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getPriorVisitNumber() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CX getMrg5_PriorVisitNumber() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CX getPriorAlternateVisitID() {
        CX retVal = (CX)this.getTypedField(6, 0);
        return retVal;
    }

    public CX getMrg6_PriorAlternateVisitID() {
        CX retVal = (CX)this.getTypedField(6, 0);
        return retVal;
    }

    public XPN[] getPriorPatientName() {
        XPN[] retVal = (XPN[])this.getTypedField(7, new XPN[0]);
        return retVal;
    }

    public XPN[] getMrg7_PriorPatientName() {
        XPN[] retVal = (XPN[])this.getTypedField(7, new XPN[0]);
        return retVal;
    }

    public int getPriorPatientNameReps() {
        return this.getReps(7);
    }

    public XPN getPriorPatientName(int rep) {
        XPN retVal = (XPN)this.getTypedField(7, rep);
        return retVal;
    }

    public XPN getMrg7_PriorPatientName(int rep) {
        XPN retVal = (XPN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getMrg7_PriorPatientNameReps() {
        return this.getReps(7);
    }

    public XPN insertPriorPatientName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(7, rep);
    }

    public XPN insertMrg7_PriorPatientName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(7, rep);
    }

    public XPN removePriorPatientName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(7, rep);
    }

    public XPN removeMrg7_PriorPatientName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(7, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CX(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new CX(this.getMessage());
            }
            case 3: {
                return new CX(this.getMessage());
            }
            case 4: {
                return new CX(this.getMessage());
            }
            case 5: {
                return new CX(this.getMessage());
            }
            case 6: {
                return new XPN(this.getMessage());
            }
        }
        return null;
    }
}

