/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v251.segment.EQU;
import ca.uhn.hl7v2.model.v251.segment.ISD;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.ROL;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ESU_U01
extends AbstractMessage {
    public ESU_U01() {
        this(new DefaultModelClassFactory());
    }

    public ESU_U01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EQU.class, true, false);
            this.add(ISD.class, false, true);
            this.add(ROL.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ESU_U01 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EQU getEQU() {
        return this.getTyped("EQU", EQU.class);
    }

    public ISD getISD() {
        return this.getTyped("ISD", ISD.class);
    }

    public ISD getISD(int rep) {
        return this.getTyped("ISD", rep, ISD.class);
    }

    public int getISDReps() {
        return this.getReps("ISD");
    }

    public List<ISD> getISDAll() throws HL7Exception {
        return this.getAllAsList("ISD", ISD.class);
    }

    public void insertISD(ISD structure, int rep) throws HL7Exception {
        super.insertRepetition("ISD", structure, rep);
    }

    public ISD insertISD(int rep) throws HL7Exception {
        return (ISD)super.insertRepetition("ISD", rep);
    }

    public ISD removeISD(int rep) throws HL7Exception {
        return (ISD)super.removeRepetition("ISD", rep);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }
}

