/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.CQ;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.SRT;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RCP
extends AbstractSegment {
    public RCP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(91)}, "Query Priority");
            this.add(CQ.class, false, 1, 10, new Object[]{this.getMessage()}, "Quantity Limited Request");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Response Modality");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Execution and Delivery Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(395)}, "Modify Indicator");
            this.add(SRT.class, false, 0, 512, new Object[]{this.getMessage()}, "Sort-by Field");
            this.add(ID.class, false, 0, 256, new Object[]{this.getMessage(), new Integer(0)}, "Segment group inclusion");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RCP - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getQueryPriority() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getRcp1_QueryPriority() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public CQ getQuantityLimitedRequest() {
        CQ retVal = (CQ)this.getTypedField(2, 0);
        return retVal;
    }

    public CQ getRcp2_QuantityLimitedRequest() {
        CQ retVal = (CQ)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getResponseModality() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getRcp3_ResponseModality() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getExecutionAndDeliveryTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getRcp4_ExecutionAndDeliveryTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getModifyIndicator() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getRcp5_ModifyIndicator() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public SRT[] getSortByField() {
        SRT[] retVal = (SRT[])this.getTypedField(6, new SRT[0]);
        return retVal;
    }

    public SRT[] getRcp6_SortByField() {
        SRT[] retVal = (SRT[])this.getTypedField(6, new SRT[0]);
        return retVal;
    }

    public int getSortByFieldReps() {
        return this.getReps(6);
    }

    public SRT getSortByField(int rep) {
        SRT retVal = (SRT)this.getTypedField(6, rep);
        return retVal;
    }

    public SRT getRcp6_SortByField(int rep) {
        SRT retVal = (SRT)this.getTypedField(6, rep);
        return retVal;
    }

    public int getRcp6_SortByFieldReps() {
        return this.getReps(6);
    }

    public SRT insertSortByField(int rep) throws HL7Exception {
        return (SRT)super.insertRepetition(6, rep);
    }

    public SRT insertRcp6_SortByField(int rep) throws HL7Exception {
        return (SRT)super.insertRepetition(6, rep);
    }

    public SRT removeSortByField(int rep) throws HL7Exception {
        return (SRT)super.removeRepetition(6, rep);
    }

    public SRT removeRcp6_SortByField(int rep) throws HL7Exception {
        return (SRT)super.removeRepetition(6, rep);
    }

    public ID[] getSegmentGroupInclusion() {
        ID[] retVal = (ID[])this.getTypedField(7, new ID[0]);
        return retVal;
    }

    public ID[] getRcp7_SegmentGroupInclusion() {
        ID[] retVal = (ID[])this.getTypedField(7, new ID[0]);
        return retVal;
    }

    public int getSegmentGroupInclusionReps() {
        return this.getReps(7);
    }

    public ID getSegmentGroupInclusion(int rep) {
        ID retVal = (ID)this.getTypedField(7, rep);
        return retVal;
    }

    public ID getRcp7_SegmentGroupInclusion(int rep) {
        ID retVal = (ID)this.getTypedField(7, rep);
        return retVal;
    }

    public int getRcp7_SegmentGroupInclusionReps() {
        return this.getReps(7);
    }

    public ID insertSegmentGroupInclusion(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(7, rep);
    }

    public ID insertRcp7_SegmentGroupInclusion(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(7, rep);
    }

    public ID removeSegmentGroupInclusion(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(7, rep);
    }

    public ID removeRcp7_SegmentGroupInclusion(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(7, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(91));
            }
            case 1: {
                return new CQ(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(395));
            }
            case 5: {
                return new SRT(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(0));
            }
        }
        return null;
    }
}

