/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.ID;
import ca.uhn.hl7v2.model.v231.datatype.NM;
import ca.uhn.hl7v2.model.v231.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MSA
extends AbstractSegment {
    public MSA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(8)}, "Acknowledgement Code");
            this.add(ST.class, true, 1, 20, new Object[]{this.getMessage()}, "Message Control ID");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Text Message");
            this.add(NM.class, false, 1, 15, new Object[]{this.getMessage()}, "Expected Sequence Number");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(102)}, "Delayed Acknowledgment Type");
            this.add(CE.class, false, 1, 100, new Object[]{this.getMessage()}, "Error Condition");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MSA - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getAcknowledgementCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getMsa1_AcknowledgementCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getMessageControlID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getMsa2_MessageControlID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getTextMessage() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getMsa3_TextMessage() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getExpectedSequenceNumber() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getMsa4_ExpectedSequenceNumber() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getDelayedAcknowledgmentType() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getMsa5_DelayedAcknowledgmentType() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getErrorCondition() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getMsa6_ErrorCondition() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(8));
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(102));
            }
            case 5: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

