/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.DT;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.PL;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.model.v23.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PV2
extends AbstractSegment {
    public PV2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, false, 1, 12, new Object[]{this.getMessage()}, "Prior Pending Location");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Accommodation Code");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Admit Reason");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Transfer Reason");
            this.add(ST.class, false, 0, 25, new Object[]{this.getMessage()}, "Patient Valuables");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "Patient Valuables Location");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(130)}, "Visit User Code");
            this.add(TS.class, false, 1, 8, new Object[]{this.getMessage()}, "Expected Admit Date");
            this.add(TS.class, false, 1, 8, new Object[]{this.getMessage()}, "Expected Discharge Date");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Estimated Length of Inpatient Stay");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Actual Length of Inpatient Stay");
            this.add(ST.class, false, 1, 50, new Object[]{this.getMessage()}, "Visit Description");
            this.add(XCN.class, false, 1, 90, new Object[]{this.getMessage()}, "Referral Source Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Previous Service Date");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Employment Illness Related Indicator");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(213)}, "Purge Status Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Purge Status Date");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(214)}, "Special Program Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Retention Indicator");
            this.add(NM.class, false, 1, 1, new Object[]{this.getMessage()}, "Expected Number of Insurance Plans");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(215)}, "Visit Publicity Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Visit Protection Indicator");
            this.add(XON.class, false, 0, 90, new Object[]{this.getMessage()}, "Clinic Organization Name");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(216)}, "Patient Status Code");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(217)}, "Visit Priority Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Previous Treatment Date");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(112)}, "Expected Discharge Disposition");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Signature on File Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "First Similar Illness Date");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(218)}, "Patient Charge Adjustment Code");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(219)}, "Recurring Service Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Billing Media Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Expected Surgery Date & Time");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(136)}, "Military Partnership Code");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(136)}, "Military Non-Availabiltiy Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Newborn Baby Indicator");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Baby Detained Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PV2 - this is probably a bug in the source code generator.", e);
        }
    }

    public PL getPriorPendingLocation() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getPv21_PriorPendingLocation() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getAccommodationCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getPv22_AccommodationCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getAdmitReason() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getPv23_AdmitReason() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getTransferReason() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getPv24_TransferReason() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public ST[] getPatientValuables() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public ST[] getPv25_PatientValuables() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public int getPatientValuablesReps() {
        return this.getReps(5);
    }

    public ST getPatientValuables(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getPv25_PatientValuables(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPv25_PatientValuablesReps() {
        return this.getReps(5);
    }

    public ST insertPatientValuables(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertPv25_PatientValuables(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removePatientValuables(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removePv25_PatientValuables(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST getPatientValuablesLocation() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getPv26_PatientValuablesLocation() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public IS getVisitUserCode() {
        IS retVal = (IS)this.getTypedField(7, 0);
        return retVal;
    }

    public IS getPv27_VisitUserCode() {
        IS retVal = (IS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getExpectedAdmitDate() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getPv28_ExpectedAdmitDate() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getExpectedDischargeDate() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public TS getPv29_ExpectedDischargeDate() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getEstimatedLengthOfInpatientStay() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getPv210_EstimatedLengthOfInpatientStay() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getActualLengthOfInpatientStay() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getPv211_ActualLengthOfInpatientStay() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getVisitDescription() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getPv212_VisitDescription() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public XCN getReferralSourceCode() {
        XCN retVal = (XCN)this.getTypedField(13, 0);
        return retVal;
    }

    public XCN getPv213_ReferralSourceCode() {
        XCN retVal = (XCN)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getPreviousServiceDate() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public DT getPv214_PreviousServiceDate() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getEmploymentIllnessRelatedIndicator() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getPv215_EmploymentIllnessRelatedIndicator() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public IS getPurgeStatusCode() {
        IS retVal = (IS)this.getTypedField(16, 0);
        return retVal;
    }

    public IS getPv216_PurgeStatusCode() {
        IS retVal = (IS)this.getTypedField(16, 0);
        return retVal;
    }

    public DT getPurgeStatusDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getPv217_PurgeStatusDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public IS getSpecialProgramCode() {
        IS retVal = (IS)this.getTypedField(18, 0);
        return retVal;
    }

    public IS getPv218_SpecialProgramCode() {
        IS retVal = (IS)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getRetentionIndicator() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getPv219_RetentionIndicator() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public NM getExpectedNumberOfInsurancePlans() {
        NM retVal = (NM)this.getTypedField(20, 0);
        return retVal;
    }

    public NM getPv220_ExpectedNumberOfInsurancePlans() {
        NM retVal = (NM)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getVisitPublicityCode() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public IS getPv221_VisitPublicityCode() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getVisitProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getPv222_VisitProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public XON[] getClinicOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(23, new XON[0]);
        return retVal;
    }

    public XON[] getPv223_ClinicOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(23, new XON[0]);
        return retVal;
    }

    public int getClinicOrganizationNameReps() {
        return this.getReps(23);
    }

    public XON getClinicOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(23, rep);
        return retVal;
    }

    public XON getPv223_ClinicOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(23, rep);
        return retVal;
    }

    public int getPv223_ClinicOrganizationNameReps() {
        return this.getReps(23);
    }

    public XON insertClinicOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(23, rep);
    }

    public XON insertPv223_ClinicOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(23, rep);
    }

    public XON removeClinicOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(23, rep);
    }

    public XON removePv223_ClinicOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(23, rep);
    }

    public IS getPatientStatusCode() {
        IS retVal = (IS)this.getTypedField(24, 0);
        return retVal;
    }

    public IS getPv224_PatientStatusCode() {
        IS retVal = (IS)this.getTypedField(24, 0);
        return retVal;
    }

    public IS getVisitPriorityCode() {
        IS retVal = (IS)this.getTypedField(25, 0);
        return retVal;
    }

    public IS getPv225_VisitPriorityCode() {
        IS retVal = (IS)this.getTypedField(25, 0);
        return retVal;
    }

    public DT getPreviousTreatmentDate() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public DT getPv226_PreviousTreatmentDate() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public IS getExpectedDischargeDisposition() {
        IS retVal = (IS)this.getTypedField(27, 0);
        return retVal;
    }

    public IS getPv227_ExpectedDischargeDisposition() {
        IS retVal = (IS)this.getTypedField(27, 0);
        return retVal;
    }

    public DT getSignatureOnFileDate() {
        DT retVal = (DT)this.getTypedField(28, 0);
        return retVal;
    }

    public DT getPv228_SignatureOnFileDate() {
        DT retVal = (DT)this.getTypedField(28, 0);
        return retVal;
    }

    public DT getFirstSimilarIllnessDate() {
        DT retVal = (DT)this.getTypedField(29, 0);
        return retVal;
    }

    public DT getPv229_FirstSimilarIllnessDate() {
        DT retVal = (DT)this.getTypedField(29, 0);
        return retVal;
    }

    public IS getPatientChargeAdjustmentCode() {
        IS retVal = (IS)this.getTypedField(30, 0);
        return retVal;
    }

    public IS getPv230_PatientChargeAdjustmentCode() {
        IS retVal = (IS)this.getTypedField(30, 0);
        return retVal;
    }

    public IS getRecurringServiceCode() {
        IS retVal = (IS)this.getTypedField(31, 0);
        return retVal;
    }

    public IS getPv231_RecurringServiceCode() {
        IS retVal = (IS)this.getTypedField(31, 0);
        return retVal;
    }

    public ID getBillingMediaCode() {
        ID retVal = (ID)this.getTypedField(32, 0);
        return retVal;
    }

    public ID getPv232_BillingMediaCode() {
        ID retVal = (ID)this.getTypedField(32, 0);
        return retVal;
    }

    public TS getExpectedSurgeryDateTime() {
        TS retVal = (TS)this.getTypedField(33, 0);
        return retVal;
    }

    public TS getPv233_ExpectedSurgeryDateTime() {
        TS retVal = (TS)this.getTypedField(33, 0);
        return retVal;
    }

    public ID getMilitaryPartnershipCode() {
        ID retVal = (ID)this.getTypedField(34, 0);
        return retVal;
    }

    public ID getPv234_MilitaryPartnershipCode() {
        ID retVal = (ID)this.getTypedField(34, 0);
        return retVal;
    }

    public ID getMilitaryNonAvailabiltiyCode() {
        ID retVal = (ID)this.getTypedField(35, 0);
        return retVal;
    }

    public ID getPv235_MilitaryNonAvailabiltiyCode() {
        ID retVal = (ID)this.getTypedField(35, 0);
        return retVal;
    }

    public ID getNewbornBabyIndicator() {
        ID retVal = (ID)this.getTypedField(36, 0);
        return retVal;
    }

    public ID getPv236_NewbornBabyIndicator() {
        ID retVal = (ID)this.getTypedField(36, 0);
        return retVal;
    }

    public ID getBabyDetainedIndicator() {
        ID retVal = (ID)this.getTypedField(37, 0);
        return retVal;
    }

    public ID getPv237_BabyDetainedIndicator() {
        ID retVal = (ID)this.getTypedField(37, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new IS(this.getMessage(), new Integer(130));
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new TS(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new XCN(this.getMessage());
            }
            case 13: {
                return new DT(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 15: {
                return new IS(this.getMessage(), new Integer(213));
            }
            case 16: {
                return new DT(this.getMessage());
            }
            case 17: {
                return new IS(this.getMessage(), new Integer(214));
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 19: {
                return new NM(this.getMessage());
            }
            case 20: {
                return new IS(this.getMessage(), new Integer(215));
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 22: {
                return new XON(this.getMessage());
            }
            case 23: {
                return new IS(this.getMessage(), new Integer(216));
            }
            case 24: {
                return new IS(this.getMessage(), new Integer(217));
            }
            case 25: {
                return new DT(this.getMessage());
            }
            case 26: {
                return new IS(this.getMessage(), new Integer(112));
            }
            case 27: {
                return new DT(this.getMessage());
            }
            case 28: {
                return new DT(this.getMessage());
            }
            case 29: {
                return new IS(this.getMessage(), new Integer(218));
            }
            case 30: {
                return new IS(this.getMessage(), new Integer(219));
            }
            case 31: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 32: {
                return new TS(this.getMessage());
            }
            case 33: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 34: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 35: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 36: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

