/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.CSU_C12_PATIENT;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CSU_C12
extends AbstractMessage {
    public CSU_C12() {
        this(new DefaultModelClassFactory());
    }

    public CSU_C12(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(CSU_C12_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CSU_C12 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public CSU_C12_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", CSU_C12_PATIENT.class);
    }

    public CSU_C12_PATIENT getPATIENT(int rep) {
        return this.getTyped("PATIENT", rep, CSU_C12_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<CSU_C12_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", CSU_C12_PATIENT.class);
    }

    public void insertPATIENT(CSU_C12_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", structure, rep);
    }

    public CSU_C12_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (CSU_C12_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public CSU_C12_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (CSU_C12_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

