/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.CN;
import ca.uhn.hl7v2.model.v21.datatype.DT;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.NM;
import ca.uhn.hl7v2.model.v21.datatype.SI;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PV1
extends AbstractSegment {
    public PV1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "SET ID - PATIENT VISIT");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(4)}, "PATIENT CLASS");
            this.add(ID.class, true, 1, 12, new Object[]{this.getMessage(), new Integer(79)}, "ASSIGNED PATIENT LOCATION");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(7)}, "ADMISSION TYPE");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "PRE-ADMIT NUMBER");
            this.add(ID.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(79)}, "PRIOR PATIENT LOCATION");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "ATTENDING DOCTOR");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "REFERRING DOCTOR");
            this.add(CN.class, false, 0, 60, new Object[]{this.getMessage()}, "CONSULTING DOCTOR");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(69)}, "HOSPITAL SERVICE");
            this.add(ID.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(79)}, "TEMPORARY LOCATION");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(87)}, "PRE-ADMIT TEST INDICATOR");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(92)}, "RE-ADMISSION INDICATOR");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(23)}, "ADMIT SOURCE");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(9)}, "AMBULATORY STATUS");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(99)}, "VIP INDICATOR");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "ADMITTING DOCTOR");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(18)}, "PATIENT TYPE");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "VISIT NUMBER");
            this.add(ID.class, false, 4, 11, new Object[]{this.getMessage(), new Integer(64)}, "FINANCIAL CLASS");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(32)}, "CHARGE PRICE INDICATOR");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(45)}, "COURTESY CODE");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(46)}, "CREDIT RATING");
            this.add(ID.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(44)}, "CONTRACT CODE");
            this.add(DT.class, false, 0, 8, new Object[]{this.getMessage()}, "CONTRACT EFFECTIVE DATE");
            this.add(NM.class, false, 0, 12, new Object[]{this.getMessage()}, "CONTRACT AMOUNT");
            this.add(NM.class, false, 0, 3, new Object[]{this.getMessage()}, "CONTRACT PERIOD");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(73)}, "INTEREST CODE");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(110)}, "TRANSFER TO BAD DEBT CODE");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "TRANSFER TO BAD DEBT DATE");
            this.add(ST.class, false, 1, 10, new Object[]{this.getMessage()}, "BAD DEBT AGENCY CODE");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "BAD DEBT TRANSFER AMOUNT");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "BAD DEBT RECOVERY AMOUNT");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(111)}, "DELETE ACCOUNT INDICATOR");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "DELETE ACCOUNT DATE");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(112)}, "DISCHARGE DISPOSITION");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(113)}, "DISCHARGED TO LOCATION");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(114)}, "DIET TYPE");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(115)}, "SERVICING FACILITY");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(116)}, "BED STATUS");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(117)}, "ACCOUNT STATUS");
            this.add(ID.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(79)}, "PENDING LOCATION");
            this.add(ID.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(79)}, "PRIOR TEMPORARY LOCATION");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "ADMIT DATE/TIME");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "DISCHARGE DATE/TIME");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "CURRENT PATIENT BALANCE");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "TOTAL CHARGES");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "TOTAL ADJUSTMENTS");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "TOTAL PAYMENTS");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PV1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSETIDPATIENTVISIT() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPv11_SETIDPATIENTVISIT() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getPATIENTCLASS() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getPv12_PATIENTCLASS() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getASSIGNEDPATIENTLOCATION() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getPv13_ASSIGNEDPATIENTLOCATION() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getADMISSIONTYPE() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getPv14_ADMISSIONTYPE() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getPREADMITNUMBER() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getPv15_PREADMITNUMBER() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getPRIORPATIENTLOCATION() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getPv16_PRIORPATIENTLOCATION() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public CN getATTENDINGDOCTOR() {
        CN retVal = (CN)this.getTypedField(7, 0);
        return retVal;
    }

    public CN getPv17_ATTENDINGDOCTOR() {
        CN retVal = (CN)this.getTypedField(7, 0);
        return retVal;
    }

    public CN getREFERRINGDOCTOR() {
        CN retVal = (CN)this.getTypedField(8, 0);
        return retVal;
    }

    public CN getPv18_REFERRINGDOCTOR() {
        CN retVal = (CN)this.getTypedField(8, 0);
        return retVal;
    }

    public CN[] getCONSULTINGDOCTOR() {
        CN[] retVal = (CN[])this.getTypedField(9, new CN[0]);
        return retVal;
    }

    public CN[] getPv19_CONSULTINGDOCTOR() {
        CN[] retVal = (CN[])this.getTypedField(9, new CN[0]);
        return retVal;
    }

    public int getCONSULTINGDOCTORReps() {
        return this.getReps(9);
    }

    public CN getCONSULTINGDOCTOR(int rep) {
        CN retVal = (CN)this.getTypedField(9, rep);
        return retVal;
    }

    public CN getPv19_CONSULTINGDOCTOR(int rep) {
        CN retVal = (CN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getPv19_CONSULTINGDOCTORReps() {
        return this.getReps(9);
    }

    public CN insertCONSULTINGDOCTOR(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(9, rep);
    }

    public CN insertPv19_CONSULTINGDOCTOR(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(9, rep);
    }

    public CN removeCONSULTINGDOCTOR(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(9, rep);
    }

    public CN removePv19_CONSULTINGDOCTOR(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(9, rep);
    }

    public ID getHOSPITALSERVICE() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getPv110_HOSPITALSERVICE() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getTEMPORARYLOCATION() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getPv111_TEMPORARYLOCATION() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getPREADMITTESTINDICATOR() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getPv112_PREADMITTESTINDICATOR() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getREADMISSIONINDICATOR() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getPv113_READMISSIONINDICATOR() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getADMITSOURCE() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getPv114_ADMITSOURCE() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getAMBULATORYSTATUS() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getPv115_AMBULATORYSTATUS() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getVIPINDICATOR() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getPv116_VIPINDICATOR() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public CN getADMITTINGDOCTOR() {
        CN retVal = (CN)this.getTypedField(17, 0);
        return retVal;
    }

    public CN getPv117_ADMITTINGDOCTOR() {
        CN retVal = (CN)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getPATIENTTYPE() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getPv118_PATIENTTYPE() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public NM getVISITNUMBER() {
        NM retVal = (NM)this.getTypedField(19, 0);
        return retVal;
    }

    public NM getPv119_VISITNUMBER() {
        NM retVal = (NM)this.getTypedField(19, 0);
        return retVal;
    }

    public ID[] getFINANCIALCLASS() {
        ID[] retVal = (ID[])this.getTypedField(20, new ID[0]);
        return retVal;
    }

    public ID[] getPv120_FINANCIALCLASS() {
        ID[] retVal = (ID[])this.getTypedField(20, new ID[0]);
        return retVal;
    }

    public int getFINANCIALCLASSReps() {
        return this.getReps(20);
    }

    public ID getFINANCIALCLASS(int rep) {
        ID retVal = (ID)this.getTypedField(20, rep);
        return retVal;
    }

    public ID getPv120_FINANCIALCLASS(int rep) {
        ID retVal = (ID)this.getTypedField(20, rep);
        return retVal;
    }

    public int getPv120_FINANCIALCLASSReps() {
        return this.getReps(20);
    }

    public ID insertFINANCIALCLASS(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(20, rep);
    }

    public ID insertPv120_FINANCIALCLASS(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(20, rep);
    }

    public ID removeFINANCIALCLASS(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(20, rep);
    }

    public ID removePv120_FINANCIALCLASS(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(20, rep);
    }

    public ID getCHARGEPRICEINDICATOR() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getPv121_CHARGEPRICEINDICATOR() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getCOURTESYCODE() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getPv122_COURTESYCODE() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getCREDITRATING() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getPv123_CREDITRATING() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID[] getCONTRACTCODE() {
        ID[] retVal = (ID[])this.getTypedField(24, new ID[0]);
        return retVal;
    }

    public ID[] getPv124_CONTRACTCODE() {
        ID[] retVal = (ID[])this.getTypedField(24, new ID[0]);
        return retVal;
    }

    public int getCONTRACTCODEReps() {
        return this.getReps(24);
    }

    public ID getCONTRACTCODE(int rep) {
        ID retVal = (ID)this.getTypedField(24, rep);
        return retVal;
    }

    public ID getPv124_CONTRACTCODE(int rep) {
        ID retVal = (ID)this.getTypedField(24, rep);
        return retVal;
    }

    public int getPv124_CONTRACTCODEReps() {
        return this.getReps(24);
    }

    public ID insertCONTRACTCODE(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(24, rep);
    }

    public ID insertPv124_CONTRACTCODE(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(24, rep);
    }

    public ID removeCONTRACTCODE(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(24, rep);
    }

    public ID removePv124_CONTRACTCODE(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(24, rep);
    }

    public DT[] getCONTRACTEFFECTIVEDATE() {
        DT[] retVal = (DT[])this.getTypedField(25, new DT[0]);
        return retVal;
    }

    public DT[] getPv125_CONTRACTEFFECTIVEDATE() {
        DT[] retVal = (DT[])this.getTypedField(25, new DT[0]);
        return retVal;
    }

    public int getCONTRACTEFFECTIVEDATEReps() {
        return this.getReps(25);
    }

    public DT getCONTRACTEFFECTIVEDATE(int rep) {
        DT retVal = (DT)this.getTypedField(25, rep);
        return retVal;
    }

    public DT getPv125_CONTRACTEFFECTIVEDATE(int rep) {
        DT retVal = (DT)this.getTypedField(25, rep);
        return retVal;
    }

    public int getPv125_CONTRACTEFFECTIVEDATEReps() {
        return this.getReps(25);
    }

    public DT insertCONTRACTEFFECTIVEDATE(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(25, rep);
    }

    public DT insertPv125_CONTRACTEFFECTIVEDATE(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(25, rep);
    }

    public DT removeCONTRACTEFFECTIVEDATE(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(25, rep);
    }

    public DT removePv125_CONTRACTEFFECTIVEDATE(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(25, rep);
    }

    public NM[] getCONTRACTAMOUNT() {
        NM[] retVal = (NM[])this.getTypedField(26, new NM[0]);
        return retVal;
    }

    public NM[] getPv126_CONTRACTAMOUNT() {
        NM[] retVal = (NM[])this.getTypedField(26, new NM[0]);
        return retVal;
    }

    public int getCONTRACTAMOUNTReps() {
        return this.getReps(26);
    }

    public NM getCONTRACTAMOUNT(int rep) {
        NM retVal = (NM)this.getTypedField(26, rep);
        return retVal;
    }

    public NM getPv126_CONTRACTAMOUNT(int rep) {
        NM retVal = (NM)this.getTypedField(26, rep);
        return retVal;
    }

    public int getPv126_CONTRACTAMOUNTReps() {
        return this.getReps(26);
    }

    public NM insertCONTRACTAMOUNT(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(26, rep);
    }

    public NM insertPv126_CONTRACTAMOUNT(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(26, rep);
    }

    public NM removeCONTRACTAMOUNT(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(26, rep);
    }

    public NM removePv126_CONTRACTAMOUNT(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(26, rep);
    }

    public NM[] getCONTRACTPERIOD() {
        NM[] retVal = (NM[])this.getTypedField(27, new NM[0]);
        return retVal;
    }

    public NM[] getPv127_CONTRACTPERIOD() {
        NM[] retVal = (NM[])this.getTypedField(27, new NM[0]);
        return retVal;
    }

    public int getCONTRACTPERIODReps() {
        return this.getReps(27);
    }

    public NM getCONTRACTPERIOD(int rep) {
        NM retVal = (NM)this.getTypedField(27, rep);
        return retVal;
    }

    public NM getPv127_CONTRACTPERIOD(int rep) {
        NM retVal = (NM)this.getTypedField(27, rep);
        return retVal;
    }

    public int getPv127_CONTRACTPERIODReps() {
        return this.getReps(27);
    }

    public NM insertCONTRACTPERIOD(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(27, rep);
    }

    public NM insertPv127_CONTRACTPERIOD(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(27, rep);
    }

    public NM removeCONTRACTPERIOD(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(27, rep);
    }

    public NM removePv127_CONTRACTPERIOD(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(27, rep);
    }

    public ID getINTERESTCODE() {
        ID retVal = (ID)this.getTypedField(28, 0);
        return retVal;
    }

    public ID getPv128_INTERESTCODE() {
        ID retVal = (ID)this.getTypedField(28, 0);
        return retVal;
    }

    public ID getTRANSFERTOBADDEBTCODE() {
        ID retVal = (ID)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getPv129_TRANSFERTOBADDEBTCODE() {
        ID retVal = (ID)this.getTypedField(29, 0);
        return retVal;
    }

    public DT getTRANSFERTOBADDEBTDATE() {
        DT retVal = (DT)this.getTypedField(30, 0);
        return retVal;
    }

    public DT getPv130_TRANSFERTOBADDEBTDATE() {
        DT retVal = (DT)this.getTypedField(30, 0);
        return retVal;
    }

    public ST getBADDEBTAGENCYCODE() {
        ST retVal = (ST)this.getTypedField(31, 0);
        return retVal;
    }

    public ST getPv131_BADDEBTAGENCYCODE() {
        ST retVal = (ST)this.getTypedField(31, 0);
        return retVal;
    }

    public NM getBADDEBTTRANSFERAMOUNT() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getPv132_BADDEBTTRANSFERAMOUNT() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getBADDEBTRECOVERYAMOUNT() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getPv133_BADDEBTRECOVERYAMOUNT() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public ID getDELETEACCOUNTINDICATOR() {
        ID retVal = (ID)this.getTypedField(34, 0);
        return retVal;
    }

    public ID getPv134_DELETEACCOUNTINDICATOR() {
        ID retVal = (ID)this.getTypedField(34, 0);
        return retVal;
    }

    public DT getDELETEACCOUNTDATE() {
        DT retVal = (DT)this.getTypedField(35, 0);
        return retVal;
    }

    public DT getPv135_DELETEACCOUNTDATE() {
        DT retVal = (DT)this.getTypedField(35, 0);
        return retVal;
    }

    public ID getDISCHARGEDISPOSITION() {
        ID retVal = (ID)this.getTypedField(36, 0);
        return retVal;
    }

    public ID getPv136_DISCHARGEDISPOSITION() {
        ID retVal = (ID)this.getTypedField(36, 0);
        return retVal;
    }

    public ID getDISCHARGEDTOLOCATION() {
        ID retVal = (ID)this.getTypedField(37, 0);
        return retVal;
    }

    public ID getPv137_DISCHARGEDTOLOCATION() {
        ID retVal = (ID)this.getTypedField(37, 0);
        return retVal;
    }

    public ID getDIETTYPE() {
        ID retVal = (ID)this.getTypedField(38, 0);
        return retVal;
    }

    public ID getPv138_DIETTYPE() {
        ID retVal = (ID)this.getTypedField(38, 0);
        return retVal;
    }

    public ID getSERVICINGFACILITY() {
        ID retVal = (ID)this.getTypedField(39, 0);
        return retVal;
    }

    public ID getPv139_SERVICINGFACILITY() {
        ID retVal = (ID)this.getTypedField(39, 0);
        return retVal;
    }

    public ID getBEDSTATUS() {
        ID retVal = (ID)this.getTypedField(40, 0);
        return retVal;
    }

    public ID getPv140_BEDSTATUS() {
        ID retVal = (ID)this.getTypedField(40, 0);
        return retVal;
    }

    public ID getACCOUNTSTATUS() {
        ID retVal = (ID)this.getTypedField(41, 0);
        return retVal;
    }

    public ID getPv141_ACCOUNTSTATUS() {
        ID retVal = (ID)this.getTypedField(41, 0);
        return retVal;
    }

    public ID getPENDINGLOCATION() {
        ID retVal = (ID)this.getTypedField(42, 0);
        return retVal;
    }

    public ID getPv142_PENDINGLOCATION() {
        ID retVal = (ID)this.getTypedField(42, 0);
        return retVal;
    }

    public ID getPRIORTEMPORARYLOCATION() {
        ID retVal = (ID)this.getTypedField(43, 0);
        return retVal;
    }

    public ID getPv143_PRIORTEMPORARYLOCATION() {
        ID retVal = (ID)this.getTypedField(43, 0);
        return retVal;
    }

    public TS getADMITDATETIME() {
        TS retVal = (TS)this.getTypedField(44, 0);
        return retVal;
    }

    public TS getPv144_ADMITDATETIME() {
        TS retVal = (TS)this.getTypedField(44, 0);
        return retVal;
    }

    public TS getDISCHARGEDATETIME() {
        TS retVal = (TS)this.getTypedField(45, 0);
        return retVal;
    }

    public TS getPv145_DISCHARGEDATETIME() {
        TS retVal = (TS)this.getTypedField(45, 0);
        return retVal;
    }

    public NM getCURRENTPATIENTBALANCE() {
        NM retVal = (NM)this.getTypedField(46, 0);
        return retVal;
    }

    public NM getPv146_CURRENTPATIENTBALANCE() {
        NM retVal = (NM)this.getTypedField(46, 0);
        return retVal;
    }

    public NM getTOTALCHARGES() {
        NM retVal = (NM)this.getTypedField(47, 0);
        return retVal;
    }

    public NM getPv147_TOTALCHARGES() {
        NM retVal = (NM)this.getTypedField(47, 0);
        return retVal;
    }

    public NM getTOTALADJUSTMENTS() {
        NM retVal = (NM)this.getTypedField(48, 0);
        return retVal;
    }

    public NM getPv148_TOTALADJUSTMENTS() {
        NM retVal = (NM)this.getTypedField(48, 0);
        return retVal;
    }

    public NM getTOTALPAYMENTS() {
        NM retVal = (NM)this.getTypedField(49, 0);
        return retVal;
    }

    public NM getPv149_TOTALPAYMENTS() {
        NM retVal = (NM)this.getTypedField(49, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(4));
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(79));
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(7));
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(79));
            }
            case 6: {
                return new CN(this.getMessage());
            }
            case 7: {
                return new CN(this.getMessage());
            }
            case 8: {
                return new CN(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(69));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(79));
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(87));
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(92));
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(23));
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(9));
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(99));
            }
            case 16: {
                return new CN(this.getMessage());
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(18));
            }
            case 18: {
                return new NM(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(64));
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(32));
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(45));
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(46));
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(44));
            }
            case 24: {
                return new DT(this.getMessage());
            }
            case 25: {
                return new NM(this.getMessage());
            }
            case 26: {
                return new NM(this.getMessage());
            }
            case 27: {
                return new ID(this.getMessage(), new Integer(73));
            }
            case 28: {
                return new ID(this.getMessage(), new Integer(110));
            }
            case 29: {
                return new DT(this.getMessage());
            }
            case 30: {
                return new ST(this.getMessage());
            }
            case 31: {
                return new NM(this.getMessage());
            }
            case 32: {
                return new NM(this.getMessage());
            }
            case 33: {
                return new ID(this.getMessage(), new Integer(111));
            }
            case 34: {
                return new DT(this.getMessage());
            }
            case 35: {
                return new ID(this.getMessage(), new Integer(112));
            }
            case 36: {
                return new ID(this.getMessage(), new Integer(113));
            }
            case 37: {
                return new ID(this.getMessage(), new Integer(114));
            }
            case 38: {
                return new ID(this.getMessage(), new Integer(115));
            }
            case 39: {
                return new ID(this.getMessage(), new Integer(116));
            }
            case 40: {
                return new ID(this.getMessage(), new Integer(117));
            }
            case 41: {
                return new ID(this.getMessage(), new Integer(79));
            }
            case 42: {
                return new ID(this.getMessage(), new Integer(79));
            }
            case 43: {
                return new TS(this.getMessage());
            }
            case 44: {
                return new TS(this.getMessage());
            }
            case 45: {
                return new NM(this.getMessage());
            }
            case 46: {
                return new NM(this.getMessage());
            }
            case 47: {
                return new NM(this.getMessage());
            }
            case 48: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

