/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IRelativeDate;
import ca.infodata.util1.date.RelativeDate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RelativeDateParser {
    public static final String DAY_SYMBOL = "d";
    public static final String MONTH_SYMBOL = "m";
    public static final String YEAR_SYMBOL = "y";

    public IRelativeDate parse(String s) {
        if (StringUtils.isBlank(s)) {
            return null;
        }
        Integer day = null;
        Integer month = null;
        Integer year = null;
        Pattern pattern = Pattern.compile("\\s*((-?\\d+)([dDwW]){1})?\\s*((-?\\d+)[mM]{1})?\\s*((-?\\d+)[yY]{1})?\\s*");
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) {
            String sday = matcher.group(2);
            String sdayUnit = matcher.group(3);
            String smonth = matcher.group(5);
            String syear = matcher.group(7);
            if (sday != null) {
                day = Integer.parseInt(sday);
                if (sdayUnit.equals("w") || sdayUnit.equals("W")) {
                    day = day * 7;
                }
            }
            if (smonth != null) {
                month = Integer.parseInt(smonth);
            }
            if (syear != null) {
                year = Integer.parseInt(syear);
            }
            return new RelativeDate(day, month, year);
        }
        return null;
    }

    public static void main(String[] args) {
        RelativeDateParser parser = new RelativeDateParser();
        System.out.println(parser.parse("1d"));
        System.out.println(parser.parse("1m"));
        System.out.println(parser.parse("1y"));
        System.out.println(parser.parse("1d 1m 1y"));
        System.out.println(parser.parse("9999y"));
        System.out.println(parser.parse("-1y"));
        System.out.println(parser.parse("  1111d     222222m     333333y    "));
        System.out.println(parser.parse("-1w"));
    }
}

