/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import ca.infodata.util1.RangeNotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class FastShortRange {
    public static final short NULL = Short.MIN_VALUE;
    private volatile int hashCodeCache;
    private short start;
    private short end;
    private RangeNotation notation;

    public FastShortRange() {
        this(Short.MIN_VALUE, Short.MIN_VALUE, (RangeNotation)null);
    }

    public FastShortRange(RangeNotation notation) {
        this(Short.MIN_VALUE, Short.MIN_VALUE, notation);
    }

    public FastShortRange(int start, int end, RangeNotation notation) {
        this.start = (short)start;
        this.end = (short)end;
        this.notation = notation;
    }

    public FastShortRange(short start, short end, RangeNotation notation) {
        this.start = start;
        this.end = end;
        this.notation = notation;
    }

    public short getStart() {
        return this.start;
    }

    public void setStart(short start) {
        this.start = start;
        this.hashCodeCache = Integer.MIN_VALUE;
    }

    public short getEnd() {
        return this.end;
    }

    public void setEnd(short end) {
        this.end = end;
        this.hashCodeCache = Integer.MIN_VALUE;
    }

    public RangeNotation getNotation() {
        return this.notation;
    }

    public void setNotation(RangeNotation notation) {
        this.notation = notation;
        this.hashCodeCache = Integer.MIN_VALUE;
    }

    public void valid() {
        if (this.notation == null) {
            throw new IllegalArgumentException("notation cant be null");
        }
        if (this.start != Short.MIN_VALUE && this.end != Short.MIN_VALUE) {
            int compareTo = this.start - this.end;
            if (compareTo > 0) {
                throw new IllegalArgumentException("start must be lower than or equals to end");
            }
            switch (this.notation) {
                case LEFT_CLOSED: 
                case RIGHT_CLOSED: 
                case OPEN: {
                    if (compareTo != 0) break;
                    throw new IllegalArgumentException("with LEFT_CLOSED, RIGHT_CLOSED or OPEN notation, start cant be equals to end");
                }
            }
        }
        if (this.start != Short.MIN_VALUE && this.end != Short.MIN_VALUE && this.notation == RangeNotation.OPEN && this.start + 1 == this.end) {
            throw new IllegalArgumentException("]n,n+1[ is invalid. was " + this);
        }
    }

    public boolean contains(short other) {
        this.valid();
        return this.inRange(other, this.start, this.end, this.notation);
    }

    public String toString() {
        String starts = this.start == Short.MIN_VALUE ? "" : String.valueOf(this.start);
        String ends = this.end == Short.MIN_VALUE ? "" : String.valueOf(this.end);
        switch (this.notation) {
            case OPEN: {
                return String.format("]%s...%s[", starts, ends);
            }
            case CLOSED: {
                return String.format("[%s...%s]", starts, ends);
            }
            case LEFT_CLOSED: {
                return String.format("[%s...%s[", starts, ends);
            }
            case RIGHT_CLOSED: {
                return String.format("]%s...%s]", starts, ends);
            }
        }
        return super.toString();
    }

    public List<FastShortRange> remove(FastShortRange range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        if (this.intersect(range)) {
            FastShortRange r;
            short start1 = this.toClosedStart(this.start, this.notation);
            short end1 = this.toClosedEnd(this.end, this.notation);
            short start2 = this.toClosedStart(range.start, range.notation);
            short end2 = this.toClosedEnd(range.end, range.notation);
            if (start2 == Short.MIN_VALUE && end2 == Short.MIN_VALUE) {
                return Collections.emptyList();
            }
            if (start2 == Short.MIN_VALUE) {
                return Arrays.asList(new FastShortRange(end2, end1, end1 == Short.MIN_VALUE ? RangeNotation.OPEN : RangeNotation.RIGHT_CLOSED));
            }
            if (end2 == Short.MIN_VALUE) {
                return Arrays.asList(new FastShortRange(start1, start2, start1 == Short.MIN_VALUE ? RangeNotation.OPEN : RangeNotation.LEFT_CLOSED));
            }
            if (start1 == Short.MIN_VALUE && end1 == Short.MIN_VALUE) {
                FastShortRange r1 = new FastShortRange(Short.MIN_VALUE, start2, RangeNotation.OPEN);
                FastShortRange r2 = new FastShortRange(end2, Short.MIN_VALUE, RangeNotation.OPEN);
                return Arrays.asList(r1, r2);
            }
            if (start1 == Short.MIN_VALUE) {
                ArrayList<FastShortRange> list = new ArrayList<FastShortRange>(2);
                FastShortRange r1 = new FastShortRange(Short.MIN_VALUE, start2, RangeNotation.OPEN);
                list.add(r1);
                if (end1 > end2) {
                    FastShortRange r2 = new FastShortRange(end2, end1, RangeNotation.RIGHT_CLOSED);
                    list.add(r2);
                }
                return list;
            }
            if (end1 == Short.MIN_VALUE) {
                ArrayList<FastShortRange> list = new ArrayList<FastShortRange>(2);
                FastShortRange r1 = new FastShortRange(end2, Short.MIN_VALUE, RangeNotation.OPEN);
                list.add(r1);
                if (start1 < start2) {
                    FastShortRange r2 = new FastShortRange(start1, start2, RangeNotation.LEFT_CLOSED);
                    list.add(r2);
                }
                return list;
            }
            ArrayList<FastShortRange> list = new ArrayList<FastShortRange>(2);
            if (start1 < start2) {
                r = new FastShortRange(start1, start2, RangeNotation.LEFT_CLOSED);
                list.add(r);
            }
            if (end1 > end2) {
                r = new FastShortRange(end2, end1, RangeNotation.RIGHT_CLOSED);
                list.add(r);
            }
            return list;
        }
        return Arrays.asList(this);
    }

    public boolean intersect(FastShortRange range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        short start1 = this.toClosedStart(this.start, this.notation);
        short end1 = this.toClosedEnd(this.end, this.notation);
        short start2 = this.toClosedStart(range.start, range.notation);
        short end2 = this.toClosedEnd(range.end, range.notation);
        return start1 == Short.MIN_VALUE && end1 == Short.MIN_VALUE && start2 == Short.MIN_VALUE && end2 == Short.MIN_VALUE || this.inRange(start2, start1, end1, RangeNotation.CLOSED) || this.inRange(end2, start1, end1, RangeNotation.CLOSED) || this.inRange(start1, start2, end2, RangeNotation.CLOSED) || this.inRange(end1, start2, end2, RangeNotation.CLOSED);
    }

    private boolean inRange(short value, short lowerLimit, short upperLimit, RangeNotation notation) {
        if (value == Short.MIN_VALUE) {
            return false;
        }
        if (lowerLimit == Short.MIN_VALUE) {
            return true;
        }
        if (upperLimit == Short.MIN_VALUE) {
            return true;
        }
        return notation.inRange(value, lowerLimit, upperLimit);
    }

    public FastShortRange merge(FastShortRange range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        short start1 = this.toClosedStart(this.start, this.notation);
        short end1 = this.toClosedEnd(this.end, this.notation);
        short start2 = this.toClosedStart(range.start, range.notation);
        short end2 = this.toClosedEnd(range.end, range.notation);
        short newStart = start1 == Short.MIN_VALUE || start2 == Short.MIN_VALUE ? (short)Short.MIN_VALUE : (short)(start1 < start2 ? start1 : start2);
        short newEnd = end1 == Short.MIN_VALUE || end2 == Short.MIN_VALUE ? (short)Short.MIN_VALUE : (short)(end1 > end2 ? end1 : end2);
        return new FastShortRange(newStart, newEnd, RangeNotation.CLOSED);
    }

    private short toClosedEnd(short end, RangeNotation notation) {
        if (end == Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        switch (notation) {
            case RIGHT_CLOSED: 
            case CLOSED: {
                return end;
            }
            case LEFT_CLOSED: 
            case OPEN: {
                return (short)(end - 1);
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    private short toClosedStart(short start, RangeNotation notation) {
        if (start == Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        switch (notation) {
            case LEFT_CLOSED: 
            case CLOSED: {
                return start;
            }
            case RIGHT_CLOSED: 
            case OPEN: {
                return (short)(start + 1);
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    public int hashCode() {
        if (this.hashCodeCache == Integer.MIN_VALUE) {
            int prime = 31;
            int result = 1;
            short start = this.toClosedStart(this.start, this.notation);
            short end = this.toClosedEnd(this.end, this.notation);
            result = 31 * result + (end == Short.MIN_VALUE ? (short)0 : end);
            result = 31 * result + (start == Short.MIN_VALUE ? (short)0 : start);
            this.hashCodeCache = result = 31 * result + RangeNotation.CLOSED.hashCode();
        }
        return this.hashCodeCache;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }
}

