/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.site2.search;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareGroup;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchComposite;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnPreferenceLoader;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.ofys.ui.site2.SiteMultiEditor;
import ca.infodata.ofys.ui.site2.menu.ISiteList;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SiteSearchComposite
extends BaseSearchComposite {
    private static final Logger logger = Logger.getLogger(SiteSearchComposite.class.getName());
    public static final String PREFERENCES_COLUMN_KEY = "SiteSearchComposite.columns_preferences";
    private static final String STAY_HERE = Messages.getString((String)"PatientSearchView.STAY_HERE", (String[])new String[0]);
    private static final String KEEP_CURSOR_HERE = Messages.getString((String)"PatientSearchView.KEEP_CURSOR_HERE", (String[])new String[0]);
    private static final String SITE_SEARCH_TEXT = Messages.getString((String)"SITE_SEARCH_TEXT", (String[])new String[0]);
    private static final String TOUS = Messages.getString((String)"TOUS", (String[])new String[0]);
    private static final String PHARMACIES = Messages.getString((String)"SLM_PHARMACIES", (String[])new String[0]);
    private static final String AUTRES = Messages.getString((String)"AUTRES", (String[])new String[0]);
    private static final String SITES_SUPPRIMES = Messages.getString((String)"SITES_SUPPRIMES", (String[])new String[0]);
    private static final String NOM_DUSAGE = Messages.getString((String)"NOM_DUSAGE", (String[])new String[0]);
    private static final String NOM_OFFICIEL = Messages.getString((String)"NOM_OFFICIEL", (String[])new String[0]);
    private static final String RUE = Messages.getString((String)"RUE", (String[])new String[0]);
    private static final String CP = Messages.getString((String)"CODE_POSTAL", (String[])new String[0]);
    protected MyLabel lblsearchText;
    protected MyMaskedText txtSearchTexte;
    private MyButton btnKeepFocus;
    private FontAwareGroup grpSiteType;
    private MyButton btnSiteTypeAll;
    private MyButton btnSiteTypePharm;
    private MyButton btnSiteTypeAutres;
    private MyButton btnIsDeleted;
    private SearchColumnChoiceElement[] columnChoice;
    private ArrayList<SearchColumnChoiceElement> sccesToInactive;

    public SiteSearchComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style, true);
    }

    public SiteSearchComposite(Composite parent, int style) {
        super(parent, style, true);
    }

    public SiteSearchComposite(Composite parent, FormToolkit toolkit, int style, boolean applySoundHelper) {
        super(parent, toolkit, style, applySoundHelper);
    }

    public SiteSearchComposite(Composite parent, int style, boolean applySoundHelper) {
        super(parent, style, applySoundHelper);
    }

    public void setFocus() {
        this.setVisible(true);
        this.txtSearchTexte.setFocus();
    }

    public void createMyPartControl(Composite theParent, FormToolkit toolkit, int style) {
        this.isWithTemplateTool = false;
        this.setUiAutoColumnAdjust(false);
        super.createMyPartControl(theParent, toolkit, style);
    }

    protected void createMyControl(Composite parent, FormToolkit toolkit) {
        this.setViewSelectInactive();
        this.setIsWithButtonNew(true);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        layout.spacing = 0;
        parent.setLayout((Layout)layout);
        this.lblsearchText = new MyLabel(parent, SITE_SEARCH_TEXT, 0, toolkit);
        this.lblsearchText.setToolTipText(SITE_SEARCH_TEXT);
        this.txtSearchTexte = new MyMaskedText(parent, 0, toolkit);
        this.txtSearchTexte.setMask(MyMasks.standardText);
        this.txtSearchTexte.setMessage(SITE_SEARCH_TEXT);
        this.txtSearchTexte.addKeyListener(this.enterCtrlEnterListener);
        this.txtSearchTexte.setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.addSearchControl("txtSearchTexte", (IControl)this.txtSearchTexte);
        this.btnKeepFocus = new MyButton(parent, STAY_HERE, 32, toolkit);
        this.btnKeepFocus.setToolTipText(KEEP_CURSOR_HERE);
        this.grpSiteType = new FontAwareGroup(parent, toolkit);
        FillLayout grpSiteTypeLayout = new FillLayout(256);
        grpSiteTypeLayout.spacing = 0;
        grpSiteTypeLayout.marginHeight = 5;
        grpSiteTypeLayout.marginWidth = 0;
        this.grpSiteType.setLayout((Layout)grpSiteTypeLayout);
        this.btnSiteTypeAll = new MyButton((Composite)this.grpSiteType, TOUS, 16, toolkit);
        this.btnSiteTypeAll.setSelection(true);
        this.btnSiteTypePharm = new MyButton((Composite)this.grpSiteType, PHARMACIES, 16, toolkit);
        this.btnSiteTypeAutres = new MyButton((Composite)this.grpSiteType, AUTRES, 16, toolkit);
        this.addSearchControl("btnSiteTypeAll", (IControl)this.btnSiteTypeAll);
        this.addSearchControl("btnSiteTypePharm", (IControl)this.btnSiteTypePharm);
        this.addSearchControl("btnSiteTypeAutres", (IControl)this.btnSiteTypeAutres);
        this.btnIsDeleted = new MyButton(parent, SITES_SUPPRIMES, 32, toolkit);
        this.addSearchControl("btnIsDeleted", (IControl)this.btnIsDeleted);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(0, 2);
        data.height = 0;
        this.lblsearchText.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblsearchText.getControl(), 3);
        data.right = new FormAttachment(100, 0);
        this.btnKeepFocus.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblsearchText.getControl(), 1);
        data.left = new FormAttachment(0, 2);
        data.right = new FormAttachment(this.btnKeepFocus.getControl(), -18);
        this.txtSearchTexte.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtSearchTexte.getControl(), 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100, 0);
        this.grpSiteType.setLayoutData((Object)data);
        this.grpSiteType.setVisible(true);
        data = new FormData();
        data.top = new FormAttachment((Control)this.grpSiteType, 5);
        data.left = new FormAttachment(0);
        this.btnIsDeleted.setLayoutData((Object)data);
        this.btnIsDeleted.setVisible(true);
    }

    protected void search() {
        this.putFocusInResultField = !this.btnKeepFocus.getSelection();
        this.disposeTableColumns();
        this.createLoadingTableColumns();
        if (this.getReferenceControl() instanceof ISiteList) {
            ((ISiteList)this.getReferenceControl()).clear();
            this.myClass = ((Object)((Object)this)).getClass();
        }
        try {
            String searchString = StringUtils.NormalizeToLowercase((String)this.txtSearchTexte.getText());
            List<XSite> lstFound = SitePlugin.getDefault().getSites().filter(x -> {
                if (this.btnIsDeleted.getSelection() ? !Boolean.TRUE.equals(x.isDeleted) : Boolean.TRUE.equals(x.isDeleted)) {
                    return false;
                }
                if (this.btnSiteTypePharm.getSelection() ? !Boolean.TRUE.equals(x.getIsDrugStore()) : this.btnSiteTypeAutres.getSelection() && Boolean.TRUE.equals(x.getIsDrugStore())) {
                    return false;
                }
                if (StringUtils.isBlank((CharSequence)this.txtSearchTexte.getText())) {
                    return true;
                }
                if (x.searchWord == null || x.searchWord.isEmpty()) {
                    x.searchWord = new ArrayList(8);
                    if (x.code != null && x.code.length() > 0) {
                        x.searchWord.add(StringUtils.NormalizeToLowercase((String)x.code));
                    }
                    if (x.nameCommon != null && x.nameCommon.length() > 0) {
                        x.searchWord.add(StringUtils.NormalizeToLowercase((String)x.nameCommon));
                    }
                    if (x.nameOfficial != null && x.nameOfficial.length() > 0) {
                        x.searchWord.add(StringUtils.NormalizeToLowercase((String)x.nameOfficial));
                    }
                    if (x.phonenumber1 != null && x.phonenumber1.length() > 0) {
                        x.searchWord.add(StringUtils.NormalizeToLowercase((String)x.phonenumber1));
                    }
                    if (x.phonenumber2 != null && x.phonenumber2.length() > 0) {
                        x.searchWord.add(StringUtils.NormalizeToLowercase((String)x.phonenumber2));
                    }
                    if (x.faxNumber != null && x.faxNumber.length() > 0) {
                        x.searchWord.add(StringUtils.NormalizeToLowercase((String)x.faxNumber));
                    }
                    if (x.rrssNiu != null && x.rrssNiu.length() > 0) {
                        x.searchWord.add(StringUtils.NormalizeToLowercase((String)x.rrssNiu));
                    }
                }
                String[] words = searchString.split("[-,; ]{1,3}");
                boolean found = true;
                String[] stringArray = words;
                int n = words.length;
                int n2 = 0;
                while (n2 < n) {
                    String word = stringArray[n2];
                    boolean foundWord = false;
                    for (String n3 : x.searchWord) {
                        if (!n3.contains(word)) continue;
                        foundWord = true;
                        break;
                    }
                    if (!foundWord) {
                        found = false;
                        break;
                    }
                    ++n2;
                }
                return found;
            }).collect(Collectors.toList());
            this.searchResponse(lstFound.toArray(new XSite[0]));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void searchResponse(final XSite[] sites) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!SiteSearchComposite.this.parent.isDisposed()) {
                        boolean fromSiteListControl = SiteSearchComposite.this.getReferenceControl() instanceof IReferenceControl;
                        ISiteList siteList = null;
                        if (fromSiteListControl) {
                            siteList = (ISiteList)SiteSearchComposite.this.getReferenceControl();
                        }
                        SiteSearchComposite.this.disposeTableColumns();
                        if (sites.length > 0) {
                            SiteSearchComposite.this.createTableColumns();
                        }
                        SearchItem[] search = new SearchItem[sites == null ? 0 : sites.length];
                        int i = 0;
                        while (i < search.length) {
                            XSite site = sites[i];
                            if (fromSiteListControl) {
                                siteList.addSite(site);
                            }
                            search[i] = SiteSearchComposite.this.newSearchItem(site);
                            ++i;
                        }
                        if (i == 0) {
                            SiteSearchComposite.this.setMessage(MSG_AUCUNES_DONNEES);
                            SiteSearchComposite.this.txtSearchTexte.setFocus();
                        } else {
                            SiteSearchComposite.this.setMessage(null);
                        }
                        SiteSearchComposite.this.loadSearchListInTable(search);
                        SiteSearchComposite.this.callbackContainerReferenceControlFromTableItems();
                        if (fromSiteListControl) {
                            IntroPlugin.getDefault().refreshViews((Object)siteList.getElementToRefresh());
                        }
                        if (!SiteSearchComposite.this.putFocusInResultField) {
                            SiteSearchComposite.this.txtSearchTexte.setFocus();
                            SiteSearchComposite.this.txtSearchTexte.selectAll();
                        }
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "", e);
                }
                if (SiteSearchComposite.this.sccesToInactive != null) {
                    for (SearchColumnChoiceElement scce : SiteSearchComposite.this.sccesToInactive) {
                        scce.setActive(false);
                    }
                }
            }
        });
    }

    protected void createTableColumns() {
        SearchColumnPreferenceLoader.ColumnOrderAndShow[] defaultPreferences = new SearchColumnPreferenceLoader.ColumnOrderAndShow[]{};
        try {
            defaultPreferences = new SearchColumnPreferenceLoader.ColumnOrderAndShow[]{new SearchColumnPreferenceLoader.ColumnOrderAndShow("ID;false;0;0"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("NOMC;true;1;300"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("NOMO;true;1;200"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("CODE;true;2;85"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("TEL1;true;3;115"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("TEL2;true;4;115"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("STREET;true;5;175"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("CP;true;6;100"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("RSS_NIU;true;7;80"), new SearchColumnPreferenceLoader.ColumnOrderAndShow("RVSQ_NO;true;8;80")};
        }
        catch (Exception e1) {
            logger.log(Level.SEVERE, "Unable to init default column for siteSearchComposite.", e1);
        }
        final SearchColumnPreferenceLoader.ColumnOrderAndShow[] loadPreferences = SearchColumnPreferenceLoader.loadPreferences((String)PREFERENCES_COLUMN_KEY, (SearchColumnPreferenceLoader.ColumnOrderAndShow[])defaultPreferences);
        this.tblSearch.setLinesVisible(false);
        this.tblSearch.setHeaderVisible(true);
        this.tableColumns = new ArrayList();
        ArrayList<SearchColumnChoiceElement> scces = new ArrayList<SearchColumnChoiceElement>();
        this.sccesToInactive = new ArrayList();
        int count = 0;
        SearchColumnPreferenceLoader.ColumnOrderAndShow[] columnOrderAndShowArray = loadPreferences;
        int n = loadPreferences.length;
        int n2 = 0;
        while (n2 < n) {
            final SearchColumnPreferenceLoader.ColumnOrderAndShow cos = columnOrderAndShowArray[n2];
            SearchColumn sc = null;
            if ("ID".equals(cos.name)) {
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    sc = new SearchColumn<XSite>((Table)this.tblSearch, "ID"){

                        public String getText(XSite e) {
                            return String.valueOf(e.getId());
                        }
                    };
                }
            } else if ("NOMC".equals(cos.name)) {
                sc = new SearchColumn<XSite>((Table)this.tblSearch, NOM_DUSAGE, NOM_DUSAGE){

                    public String getText(XSite e) {
                        return e.getNameCommon();
                    }
                };
                sc.getColumn().setData("maxWidth", (Object)300);
            } else if ("NOMO".equals(cos.name)) {
                sc = new SearchColumn<XSite>((Table)this.tblSearch, NOM_OFFICIEL, NOM_OFFICIEL){

                    public String getText(XSite e) {
                        return e.getNameOfficial();
                    }
                };
                sc.getColumn().setData("maxWidth", (Object)300);
            } else if ("CODE".equals(cos.name)) {
                sc = new SearchColumn<XSite>((Table)this.tblSearch, "CODE", "CODE"){

                    public String getText(XSite e) {
                        return e.getCode();
                    }
                };
            } else if ("TEL1".equals(cos.name)) {
                sc = new SearchColumn<XSite>((Table)this.tblSearch, "TEL 1", "TEL 1"){

                    public String getText(XSite e) {
                        return e.getPhonenumber1();
                    }
                };
            } else if ("TEL2".equals(cos.name)) {
                sc = new SearchColumn<XSite>((Table)this.tblSearch, "TEL 2", "TEL 2"){

                    public String getText(XSite e) {
                        return e.getPhonenumber2();
                    }
                };
            } else if ("STREET".equals(cos.name)) {
                sc = new SearchColumn<XSite>((Table)this.tblSearch, RUE, RUE){

                    public String getText(XSite e) {
                        return e.getStreet();
                    }
                };
            } else if ("CP".equals(cos.name)) {
                sc = new SearchColumn<XSite>((Table)this.tblSearch, CP, CP){

                    public String getText(XSite e) {
                        return e.getPostalCode();
                    }
                };
            } else if ("RSS_NIU".equals(cos.name)) {
                sc = new SearchColumn<XSite>((Table)this.tblSearch, "RSS_NIU", "RSS NIU"){

                    public String getText(XSite e) {
                        return e.getRrssNiu();
                    }
                };
            }
            if (sc != null) {
                if (cos.width > -1) {
                    sc.getColumn().setWidth(cos.width);
                }
                sc.getColumn().addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        cos.width = ((TableColumn)e.getSource()).getWidth();
                        SiteSearchComposite.this.saveWidthPref(loadPreferences, cos);
                    }
                });
                SearchColumnChoiceElement searchColumnChoiceElement = new SearchColumnChoiceElement(sc, true, count++);
                scces.add(searchColumnChoiceElement);
                this.tableColumns.add(sc);
                if (Boolean.FALSE.equals(cos.show)) {
                    this.sccesToInactive.add(searchColumnChoiceElement);
                }
            }
            ++n2;
        }
        this.columnChoice = new SearchColumnChoiceElement[this.tableColumns.size()];
        this.columnChoice = scces.toArray(this.columnChoice);
    }

    protected void saveWidthPref(SearchColumnPreferenceLoader.ColumnOrderAndShow[] coss, SearchColumnPreferenceLoader.ColumnOrderAndShow c) {
        String[][] prefs = new String[this.columnChoice.length][];
        int[] order = new int[this.columnChoice.length];
        int i = 0;
        while (i < this.columnChoice.length) {
            order[i] = this.columnChoice[i].getOriginalOrder();
            if (this.columnChoice[i].getColumnName().equals(c.name)) {
                this.columnChoice[i].setWidth(c.width);
            }
            prefs[i] = new String[]{this.columnChoice[i].getColumnName(), "" + this.columnChoice[i].isActive(), "" + i, "" + this.columnChoice[i].getWidth()};
            ++i;
        }
        SearchColumnPreferenceLoader.savePref((String)this.getPreferencesKeys(), (String[][])prefs);
    }

    protected void createNew() {
        try {
            XSite site = new XSite();
            site.initialize();
            BaseEditor.openEditor((IEditorInput)new EditorInput((IDataObject)site), (String)SiteMultiEditor.class.getName());
        }
        catch (PartInitException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    protected void itemSelected(SearchItem item) {
        if (item != null && item.getData() instanceof XSite) {
            SearchItem item2 = new SearchItem((Object)((XSite)item.getData()), item.getText());
            super.itemSelected(item2);
        }
    }

    protected void processSelection(SearchItem item) {
        if (this.getReferenceControl() instanceof IReferenceControl) {
            return;
        }
        this.openSiteMultiEditor((XSite)item.getData());
    }

    private void openSiteMultiEditor(XSite dataObject) {
        try {
            BaseEditor.openEditor((IEditorInput)new EditorInput((IDataObject)dataObject), (String)SiteMultiEditor.class.getName());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void reset() {
        this.txtSearchTexte.clear();
        super.reset();
    }

    public void setSearchText(String s) {
        this.txtSearchTexte.setText(s);
        if (this.txtSearchTexte.getText() != null) {
            this.txtSearchTexte.setSelection(this.txtSearchTexte.getText().length());
        }
    }

    public void doSearch() {
        this.search();
    }

    protected SearchColumnChoiceElement[] getSearchColumnChoiceElements() {
        return this.columnChoice;
    }

    protected String getPreferencesKeys() {
        return PREFERENCES_COLUMN_KEY;
    }

    public void hideKeepFocus() {
        FormData data = new FormData();
        data.top = new FormAttachment(this.lblsearchText.getControl(), 3);
        data.right = new FormAttachment(100, 0);
        data.width = 0;
        this.btnKeepFocus.setLayoutData((Object)data);
        this.btnKeepFocus.getParent().pack();
    }
}

